/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/
package com.clustercontrol.commons.ejb;

/**
 * UsedFacilityException は、ファシリティの使用チェックにて、
 * ファシリティが使用されている場合にスローされます。
 * 
 * @version 2.1.2
 * @since 2.1.2
 */
public class UsedFacilityException extends Exception {
	private static final long serialVersionUID = -4336899260255632965L;

	public int plugin = 0;
	
	/**
	 * コンストラクタ
	 * 
	 * @param plugin プラグイン(機能)
	 * 
	 * @see com.clustercontrol.bean.PluginConstant
	 */
	public UsedFacilityException(int plugin) {
		super();
		this.plugin = plugin;
	}

	/**
	 * プラグイン(機能)を返します。
	 * 
	 * @return プラグイン(機能)
	 * 
	 * @see com.clustercontrol.bean.PluginConstant
	 */
	public int getPlugin() {
		return plugin;
	}
}