/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

import javax.ejb.FinderException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 *
 * 一括制御セッション（履歴）情報のEntity Beanです。
 * 
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CRunSession"
 *	jndi-name="CRunSession"
 *	type="CMP"
 *  primkey-field="session_id" 
 *  schema="CRunSession" 
 *  cmp-version="2.x"
 *  data-source="java:/HinemosDS"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.persistence 
 *   table-name="cc_crun_session" 
 *   
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSession as a"  
 *    signature="java.util.Collection findAll()"  
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSession as a WHERE a.status = ?1"  
 *    signature="java.util.Collection findByStatus(java.lang.Integer status)"  
 * 
 * @ejb.select
 *    result-type-mapping= "Local" 
 *    method-intf= "LocalHome"
 *    query=""
 *    signature="java.util.Collection ejbSelectGeneric(java.lang.String jbossQL, java.lang.Object[] arg)"
 * @jboss.query
 *    dynamic="true"
 *    signature="java.util.Collection ejbSelectGeneric(java.lang.String jbossQL, java.lang.Object[] arg)"
 *
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CRunSession as a WHERE a.facility_id = ?1"  
 *    signature="java.util.Collection findByFacilityId(java.lang.String facilityId)"  
 *    
 * @ejb.pk class="java.lang.String"
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public abstract class CRunSessionBean implements javax.ejb.EntityBean {
    protected static Log m_log = LogFactory.getLog( CRunSessionBean.class );
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public java.lang.String ejbCreate(
            String session_id, 
            Date start_date, 
            Date end_date, 
            String type_id, 
            String command_id, 
            String facility_id, 
            String scope_text, 
            Integer node_cnt, 
            Integer wait_cnt, 
            Integer running_cnt, 
            Integer end_nomal_cnt, 
            Integer end_warning_cnt, 
            Integer end_abnomal_cnt, 
            Integer status) throws javax.ejb.CreateException {
        setSession_id(session_id);
        setStart_date(start_date);
        setEnd_date(end_date);
        setType_id(type_id);
        setCommand_id(command_id);
        setFacility_id(facility_id);
        setScope_text(scope_text);
        setNode_cnt(node_cnt);
        setWait_cnt(wait_cnt);
        setRunning_cnt(running_cnt);
        setEnd_nomal_cnt(end_nomal_cnt);
        setEnd_warning_cnt(end_warning_cnt);
        setEnd_abnomal_cnt(end_abnomal_cnt);
        setStatus(status);
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field session_id
     *
     * Returns the session_id
     * @return the session_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="session_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     * @ejb.pk-field 
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getSession_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the session_id
     * 
     * @param java.lang.String the new session_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setSession_id(java.lang.String session_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field start_date
     *
     * Returns the start_date
     * @return the start_date
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="start_date"
     *     jdbc-type="TIMESTAMP"
     *     sql-type="TIMESTAMP"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.util.Date getStart_date();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the start_date
     * 
     * @param java.util.Date the new start_date value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setStart_date(java.util.Date start_date);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_date
     *
     * Returns the end_date
     * @return the end_date
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_date"
     *     jdbc-type="TIMESTAMP"
     *     sql-type="TIMESTAMP"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.util.Date getEnd_date();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_date
     * 
     * @param java.util.Date the new end_date value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_date(java.util.Date end_date);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field type_id
     *
     * Returns the type_id
     * @return the type_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="type_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getType_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the type_id
     * 
     * @param java.lang.String the new type_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setType_id(java.lang.String type_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field command_id
     *
     * Returns the command_id
     * @return the command_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="command_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getCommand_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the command_id
     * 
     * @param java.lang.String the new command_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setCommand_id(java.lang.String command_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field facility_id
     *
     * Returns the facility_id
     * @return the facility_id
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="facility_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getFacility_id();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the facility_id
     * 
     * @param java.lang.String the new facility_id value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setFacility_id(java.lang.String facility_id);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field scope_text
     *
     * Returns the scope_text
     * @return the scope_text
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="scope_text"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.String getScope_text();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the scope_text
     * 
     * @param java.lang.String the new scope_text value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setScope_text(java.lang.String scope_text);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field node_cnt
     *
     * Returns the node_cnt
     * @return the node_cnt
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="node_cnt"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getNode_cnt();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the node_cnt
     * 
     * @param java.lang.Integer the new node_cnt value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setNode_cnt(java.lang.Integer node_cnt);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field wait_cnt
     *
     * Returns the wait_cnt
     * @return the wait_cnt
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="wait_cnt"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getWait_cnt();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the wait_cnt
     * 
     * @param java.lang.Integer the new wait_cnt value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setWait_cnt(java.lang.Integer wait_cnt);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field running_cnt
     *
     * Returns the running_cnt
     * @return the running_cnt
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="running_cnt"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getRunning_cnt();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the running_cnt
     * 
     * @param java.lang.Integer the new running_cnt value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setRunning_cnt(java.lang.Integer running_cnt);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_nomal_cnt
     *
     * Returns the end_nomal_cnt
     * @return the end_nomal_cnt
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_nomal_cnt"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getEnd_nomal_cnt();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_nomal_cnt
     * 
     * @param java.lang.Integer the new end_nomal_cnt value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_nomal_cnt(java.lang.Integer end_nomal_cnt);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_warning_cnt
     *
     * Returns the end_warning_cnt
     * @return the end_warning_cnt
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_warning_cnt"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getEnd_warning_cnt();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_warning_cnt
     * 
     * @param java.lang.Integer the new end_warning_cnt value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_warning_cnt(java.lang.Integer end_warning_cnt);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field end_abnomal_cnt
     *
     * Returns the end_abnomal_cnt
     * @return the end_abnomal_cnt
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="end_abnomal_cnt"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getEnd_abnomal_cnt();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the end_abnomal_cnt
     * 
     * @param java.lang.Integer the new end_abnomal_cnt value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setEnd_abnomal_cnt(java.lang.Integer end_abnomal_cnt);
    
    /**
     *
     *
     * <!-- begin-user-doc -->
     * CMP Field status
     *
     * Returns the status
     * @return the status
     * 
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     *
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="status"
     *     jdbc-type="SMALLINT"
     *     sql-type="SMALLINT"
     *     read-only="false"
     *  
     *
     * @ejb.interface-method
     * 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public abstract java.lang.Integer getStatus();
    
    /**
     * <!-- begin-user-doc -->
     * Sets the status
     * 
     * @param java.lang.Integer the new status value
     * <!-- end-user-doc -->
     * 
     * <!-- begin-xdoclet-definition --> 
     * @ejb.interface-method
     * <!-- end-xdoclet-definition -->
     * @generated 
     */
    public abstract void setStatus(java.lang.Integer status);
    
    //	==========================================
    //	 CMR fields
    //	==========================================
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="CRunSession-CRunSessionDetail"
     * role-name="CRunSession-CRunSessionDetail(single)"
     * 
     */
    public abstract Collection getSessionDetail();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setSessionDetail(Collection collection);
    
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="CRunSession-CRunSessionParam"
     * role-name="CRunSession-CRunSessionParam(single)"
     * 
     */
    public abstract Collection getSessionParam();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setSessionParam(Collection collection);
   
	/** 
	 * DynamicQL
	 * 
	 * @param jbossQl JBossQL
	 * @param args query arguments as parameters
	 * 
	 * @jboss.dynamic-ql 
	 */
	public abstract Set ejbSelectGeneric(String jbossQl, Object[] arguments) throws FinderException;
	
	/**
	 * 履歴フィルタ用検索
	 * 
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.home-method
	 *  view-type= "local"
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public Collection ejbHomeSelectHistoryFilter(
	        Date startFromDate, 
	        Date startToDate, 
	        Date endFromDate, 
	        Date endToDate, 
	        String typeId, 
	        Integer status, 
	        Integer limit) throws FinderException {
		
		StringBuffer jbossQl = new StringBuffer();
		jbossQl.append("SELECT OBJECT(a) ");
		jbossQl.append("FROM CRunSession as a");
		
		ArrayList arguments = new ArrayList();
		int count = 1;

		if(startFromDate instanceof Date) {
		    jbossQl.append(" WHERE a.start_date >= ?" + count);
			arguments.add(startFromDate);
			count++;
		}
		if(startToDate instanceof Date) {
		    if(count == 1){
		        jbossQl.append(" WHERE a.start_date <= ?" + count);
		    }
		    else{
		        jbossQl.append(" AND a.start_date <= ?" + count);
		    }
			arguments.add(startToDate);
			count++;
		}
		if(endFromDate instanceof Date) {
		    if(count == 1){
		        jbossQl.append(" WHERE a.end_date >= ?" + count);
		    }
		    else{
		        jbossQl.append(" AND a.end_date >= ?" + count);
		    }
			arguments.add(endFromDate);
			count++;
		}
		if(endToDate instanceof Date) {
		    if(count == 1){
		        jbossQl.append(" WHERE a.end_date <= ?" + count);
		    }
		    else{
		        jbossQl.append(" AND a.end_date <= ?" + count);
		    }
			arguments.add(endToDate);
			count++;
		}
		if(typeId != null && typeId.length() > 0) {
		    if(count == 1){
		        jbossQl.append(" WHERE a.type_id = ?" + count);
		    }
		    else{
		        jbossQl.append(" AND a.type_id = ?" + count);
		    }
			arguments.add(typeId);
			count++;
		}
		if(status instanceof Integer && status.intValue() != -1) {
		    if(count == 1){
		        jbossQl.append(" WHERE a.status = ?" + count);
		    }
		    else{
		        jbossQl.append(" AND a.status = ?" + count);
		    }
			arguments.add(status);
			count++;
		}
		jbossQl.append(" ORDER BY a.session_id DESC");
		if(limit instanceof Integer) {
		    jbossQl.append(" LIMIT " + limit.toString());
		}
		
		Object[] args = arguments.toArray();
		m_log.debug(jbossQl.toString());
		return ejbSelectGeneric(jbossQl.toString(), args);
	}
}
