/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.bean;


/**
 * 一括制御のパラメータ情報を保持するクラスです。<BR>
 * 一括制御[作成・変更]ダイアログから設定します。
 * 
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParameterInfo extends ItemInfo {
	private static final long serialVersionUID = -8291998799865546000L;

	/** パラメータID */
	protected String id;

	/** 接頭語 */
	protected int paramType;

	/**
	 * @return
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return
	 */
	public int getParamType() {
		return paramType;
	}

	/**
	 * @param paramType
	 */
	public void setParamType(int paramType) {
		this.paramType = paramType;
	}

	/* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.1.0
     */
	public Object clone() {
    	ParameterInfo clone = (ParameterInfo)super.clone();
    	
    	clone.setId(this.getId());
    	clone.setParamType(this.getParamType());
    	
    	return clone;
    }
}