/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.bean;

import com.clustercontrol.bean.EventConfirmConstant;

/**
 * 通知グループ情報を保持するクラス
 * 
 * 
 * 通知グループ情報とは、ジョブ、監視、メンテナンスなどで複数設定される
 * 通知情報をまとめる関連テーブルであり、notifyGroupInfoは、ジョブ、
 * 各種監視、メンテナンスにまたがって、一意に定まるIDとする。
 * notifyGroupIdは、com.clustercontrol.bean.HinemosModuleConstantで
 * 定義される識別子を必ず先頭に持つ（識別子により名前空間を分割する）
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class NotifyRelationInfo 
implements java.io.Serializable
{
	/*通知グループID*/
	private String notifyGroupId;
	/*通知ID*/
	private String notifyId;
	/*通知タイプ*/
	private Integer notifyType;
	/*通知フラグ*/
	private Integer notifyFlg;
	

	/**
	 * コンストラクター
	 * 
	 */
    public NotifyRelationInfo() {

	}


	/**
     * コンストラクター
     * 
     * @param notifyGroupId
     * @param notifyId
     * @param notifyType
     * @param notifyFlg
     */
	public NotifyRelationInfo(String notifyGroupId, String notifyId,
			Integer notifyType, Integer notifyFlg) {
		
		this.notifyGroupId = notifyGroupId;
		this.notifyId = notifyId;
		this.notifyType = notifyType;
		this.notifyFlg = notifyFlg;
	}
	
	
	/**
	 * 通知グループIDを生成します。(ジョブ定義用)
	 *  
	 * @return 通知グループID
	 */
	public static String createNotifyGroupIdMaintenance(String maintenanceId){

		String ret = com.clustercontrol.bean.HinemosModuleConstant.SYSYTEM_MAINTENANCE
		             +"-"+maintenanceId + "-0";
		return ret;
	}

	/**
	 * 通知グループIDを生成します。(ジョブ定義用)
	 *  
	 * @return 通知グループID
	 */
	public static String createNotifyGroupIdJob(String jobID, Integer noticeType){

		String ret = com.clustercontrol.bean.HinemosModuleConstant.JOB_MST
		             +"-"+jobID
		             +"-"+noticeType.toString();

		return ret;
	}

	/**
	 * 通知グループIDを生成します。(ジョブセッション用)
	 *  
	 * @return 通知グループID
	 */
	public static  String createNotifyGroupIdJobInfo(String sessionId, String jobID, Integer noticeType){

		String ret = com.clustercontrol.bean.HinemosModuleConstant.JOB_SESSION
		             +"-"+sessionId
		             +"-"+jobID
		             +"-"+noticeType.toString();

		return ret;
	}


	/**
	 * 通知グループIDを生成します。(SNMPトラップ監視用)
	 *  
	 * @return 通知グループID
	 */
	public static String createNotifyGroupId( String monitorID){

		return  createNotifyGroupId(com.clustercontrol.bean.HinemosModuleConstant.MONITOR_SNMPTRAP, monitorID, 0);	
	}


	/**
	 * 通知グループIDを生成します。(数値監視、真偽値監視用)
	 *  
	 * @param monitorTypeId 監視タイプID
	 * @param monitorID 監視項目ID
	 * @return 通知グループID
	 * 
	 * @see com.clustercontrol.bean.HinemosModuleConstant
	 */
	public static String createNotifyGroupId(String monitorTypeId, String monitorID){



		return  createNotifyGroupId(monitorTypeId, monitorID, 0);	
	}

	/**
	 * 通知グループIDを生成します。(文字列監視用)
	 *  
	 * @return 通知グループID
	 */
	public static  String createNotifyGroupId(String monitorTypeId, String monitorID, Integer orderNo){


		/*monitorTypeが存在するかチェック*/
		if(!com.clustercontrol.bean.HinemosModuleConstant.isExist(monitorTypeId)){
			return null;
		}

		String ret =  monitorTypeId + "-" + monitorID + "-" + orderNo.toString();

		return ret;
	}
	
	/**
	 * 通知グループIDを生成します。(障害検知用)
	 * 
	 * @return 通知グループID
	 */
	public static  String createNotifyGroupIdTrouble(/*String monitorId*/){

//		return createNotifyGroupId(com.clustercontrol.bean.HinemosModuleConstant.SYSYTEM_TROUBLE_DETECTION, monitorId, 0);
		return com.clustercontrol.bean.HinemosModuleConstant.SYSYTEM_TROUBLE_DETECTION + "-0";
		
	}

	/**
	 * 通知グループIDを返します。
	 * 
	 * @return
	 */
	public String getNotifyGroupId() {
		return notifyGroupId;
	}
	/**
	 * 通知グループIDを設定します。
	 * 
	 * @param notifyGroupId
	 */
	public void setNotifyGroupId(String notifyGroupId) {
		this.notifyGroupId = notifyGroupId;
	}
	/**
	 * 通知IDを返します。
	 * 
	 * @return
	 */
	public String getNotifyId() {
		return notifyId;
	}
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId
	 */
	public void setNotifyId(String notifyId) {
		this.notifyId = notifyId;
	}
	/**
	 * 通知タイプを返します。
	 * 
	 * @return 通知タイプ
	 * 
	 * @see com.clustercontrol.bean.NotifyTypeConstant
	 */
	public Integer getNotifyType() {
		return notifyType;
	}
	/**
	 * 通知タイプを設定します。
	 * @param notifyType
	 * 
	 * @see com.clustercontrol.bean.NotifyTypeConstant
	 */
	public void setNotifyType(Integer notifyType) {
		this.notifyType = notifyType;
	}
	/**
	 * 通知フラグを返します。
	 * @return
	 */
	public Integer getNotifyFlg() {
		return notifyFlg;
	}
	/**
	 * 通知フラグを設定します。
	 * 
	 * @param notifyFlg
	 */
	public void setNotifyFlg(Integer notifyFlg) {
		this.notifyFlg = notifyFlg;
	}




}
