/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * CommonTableTreeViewerクラス用にツリー構造化するためのクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableTreeItem implements Serializable {
    /**
	 * 
	 */
	private static final long serialVersionUID = -8296030294371572681L;

	/** 親 */
    private CommonTableTreeItem parent = null;

    /** 情報オブジェクト */
    private ArrayList data = null;

    /** 子の格納リスト */
    private List childrens = null;

    /**
     * 引数の情報を保持したインスタンスを取得します。<BR>
     * 
     * @param parent
     *            親のオブジェクト
     * @param data
     *            スコープ情報オブジェクト
     */
    public CommonTableTreeItem(CommonTableTreeItem parent, ArrayList data) {

        this.setParent(parent);
        this.setData(data);

        if (parent != null) {
            parent.addChildren(this);
        }

        this.childrens = new ArrayList();
    }

    /**
     * 親のオブジェクトを取得します。<BR>
     * 
     * @return 親
     */
    public CommonTableTreeItem getParent() {
        return this.parent;
    }

    /**
     * 親のオブジェクトを設定します。<BR>
     * <p>
     * 
     * インスタンス化の際に親へ関係付けているため、子を削除するメソッドを実装した 後に可視性(スコープ)を拡大して下さい。 <br>
     * また、新しい親への関係付けも行うように実装して下さい。
     * 
     * @return 親
     */
    public void setParent(CommonTableTreeItem parent) {
        this.parent = parent;
    }

    /**
     * 情報を取得します。<BR>
     * 
     * @return 情報
     */
    public ArrayList getData() {
        return this.data;
    }

    /**
     * 情報を設定します。<BR>
     * 
     * @param data 情報
     */
    public void setData(ArrayList data) {
        this.data = data;
    }

    /**
     * 子のオブジェクトを追加します。<BR>
     * <p>
     * 
     * childenの親はこのオブジェクトとして設定されます。
     * 
     * @param child   子
     */
    public void addChildren(CommonTableTreeItem child) {
        child.setParent(this);
        childrens.add(child);
    }

    /**
     * 子のオブジェクト数を取得します。<BR>
     * 
     * @return 子オブジェクトの数
     */
    public int size() {
        return childrens.size();
    }

    /**
     * 全ての子オブジェクトを取得します。<BR>
     * <p>
     * 
     * 並び順は、追加された順となっています。
     * 
     * @return 全ての子。
     */
    public CommonTableTreeItem[] getChildren() {
        CommonTableTreeItem[] result = new CommonTableTreeItem[this.size()];
        return (CommonTableTreeItem[]) childrens.toArray(result);
    }
}