/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xinclude;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xinclude.XIncludeFatalError;
import org.apache.xerces.xinclude.XIncludeMessageFormatter;
import org.apache.xerces.xinclude.XIncludeNamespaceSupport;
import org.apache.xerces.xinclude.XIncludeResourceError;
import org.apache.xerces.xinclude.XIncludeTextReader;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDFilter;
import org.apache.xerces.xni.parser.XMLDTDSource;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;

public class XIncludeHandler
implements XMLComponent,
XMLDocumentFilter,
XMLDTDFilter {
    public static final String XINCLUDE_DEFAULT_CONFIGURATION = "org.apache.xerces.parsers.XIncludeParserConfiguration";
    public static final String XINCLUDE_NS_URI = "http://www.w3.org/2001/XInclude".intern();
    public static final String XINCLUDE_INCLUDE = "include".intern();
    public static final String XINCLUDE_FALLBACK = "fallback".intern();
    public static final String XINCLUDE_PARSE_XML = "xml".intern();
    public static final String XINCLUDE_PARSE_TEXT = "text".intern();
    public static final String XINCLUDE_ATTR_HREF = "href".intern();
    public static final String XINCLUDE_ATTR_PARSE = "parse".intern();
    public static final String XINCLUDE_ATTR_ENCODING = "encoding".intern();
    public static final String XINCLUDE_INCLUDED = "[included]".intern();
    public static final String XINCLUDE_BASE = "base";
    public static final QName XML_BASE_QNAME = new QName(XMLSymbols.PREFIX_XML, "base", XMLSymbols.PREFIX_XML + ":" + "base", NamespaceContext.XML_URI);
    public static final QName NEW_NS_ATTR_QNAME = new QName(XMLSymbols.PREFIX_XMLNS, "", XMLSymbols.PREFIX_XMLNS + ":", NamespaceContext.XMLNS_URI);
    private static final int STATE_NORMAL_PROCESSING = 1;
    private static final int STATE_IGNORE = 2;
    private static final int STATE_EXPECT_FALLBACK = 3;
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/allow-dtd-events-after-endDTD"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null};
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDSource fDTDSource;
    protected XIncludeHandler fParentXIncludeHandler;
    protected XMLParserConfiguration fChildConfig;
    protected XMLLocator fDocLocation;
    protected XIncludeNamespaceSupport fNamespaceContext;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected ParserConfigurationSettings fSettings;
    private int fDepth = 0;
    private int fRootDepth = 0;
    private static final int INITIAL_SIZE = 8;
    private boolean[] fSawInclude = new boolean[8];
    private boolean[] fSawFallback = new boolean[8];
    private int[] fState = new int[8];
    private Vector fNotations;
    private Vector fUnparsedEntities;
    private boolean fSendUEAndNotationEvents;

    public XIncludeHandler() {
        this.fSawFallback[this.fDepth] = false;
        this.fSawInclude[this.fDepth] = false;
        this.fState[this.fDepth] = 1;
        this.fNotations = new Vector();
        this.fUnparsedEntities = new Vector();
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        Object object;
        this.fNamespaceContext = null;
        this.fDepth = 0;
        this.fRootDepth = 0;
        this.fNotations = new Vector();
        this.fUnparsedEntities = new Vector();
        int n = 0;
        while (n < this.fState.length) {
            this.fSawFallback[n] = false;
            this.fSawInclude[n] = false;
            this.fState[n] = 1;
            ++n;
        }
        try {
            this.fSendUEAndNotationEvents = xMLComponentManager.getFeature(ALLOW_UE_AND_NOTATION_EVENTS);
            if (this.fChildConfig != null) {
                this.fChildConfig.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, this.fSendUEAndNotationEvents);
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        try {
            object = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
            if (object != null) {
                this.setErrorReporter((XMLErrorReporter)object);
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ERROR_REPORTER, object);
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fErrorReporter = null;
        }
        try {
            object = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
            if (object != null) {
                this.fEntityResolver = object;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ENTITY_RESOLVER, object);
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        this.fSettings = new ParserConfigurationSettings();
        this.copyFeatures(xMLComponentManager, this.fSettings);
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (string.equals(ALLOW_UE_AND_NOTATION_EVENTS)) {
            this.fSendUEAndNotationEvents = bl;
        }
        if (this.fSettings != null) {
            this.fSettings.setFeature(string, bl);
        }
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(ERROR_REPORTER)) {
            this.setErrorReporter((XMLErrorReporter)object);
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(string, object);
            }
        }
        if (string.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)object;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(string, object);
            }
        }
    }

    public Boolean getFeatureDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n].equals(string)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[n].equals(string)) {
                return PROPERTY_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        try {
            if (!this.isRootDocument() && this.fParentXIncludeHandler.searchForRecursiveIncludes(xMLLocator)) {
                throw new XIncludeFatalError("RecursiveInclude", null);
            }
        }
        catch (XIncludeFatalError xIncludeFatalError) {
            this.reportFatalError(xIncludeFatalError.getKey(), xIncludeFatalError.getArgs());
        }
        if (!(namespaceContext instanceof XIncludeNamespaceSupport)) {
            throw new XIncludeFatalError("IncompatibleNamespaceContext", null);
        }
        this.fNamespaceContext = (XIncludeNamespaceSupport)namespaceContext;
        this.fDocLocation = xMLLocator;
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            ++this.fDepth;
            augmentations = this.modifyAugmentations(augmentations);
            this.fDocumentHandler.comment(xMLString, augmentations);
            --this.fDepth;
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            ++this.fDepth;
            augmentations = this.modifyAugmentations(augmentations);
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
            --this.fDepth;
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fDepth;
        this.setState(this.getState(this.fDepth - 1));
        if (this.isIncludeElement(qName)) {
            try {
                this.handleIncludeElement(xMLAttributes);
                this.setState(2);
            }
            catch (XIncludeResourceError xIncludeResourceError) {
                this.setState(3);
            }
        } else if (this.isFallbackElement(qName)) {
            this.handleFallbackElement();
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            if (this.fRootDepth < 1) {
                this.fRootDepth = this.fDepth;
            }
            augmentations = this.modifyAugmentations(augmentations);
            xMLAttributes = this.processAttributes(xMLAttributes);
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fDepth;
        this.setState(this.getState(this.fDepth - 1));
        if (this.isIncludeElement(qName)) {
            try {
                this.handleIncludeElement(xMLAttributes);
                this.setState(2);
            }
            catch (XIncludeResourceError xIncludeResourceError) {
                this.reportFatalError("NoFallback");
            }
        } else if (this.isFallbackElement(qName)) {
            this.handleFallbackElement();
        } else if (this.hasXIncludeNamespace(qName)) {
            if (this.getSawInclude(this.fDepth - 1)) {
                this.reportFatalError("IncludeChild", new Object[]{qName.rawname});
            }
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            if (this.fRootDepth < 1) {
                this.fRootDepth = this.fDepth;
            }
            augmentations = this.modifyAugmentations(augmentations);
            xMLAttributes = this.processAttributes(xMLAttributes);
            this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
            if (this.fRootDepth == this.fDepth) {
                this.fRootDepth = 0;
            }
        }
        --this.fDepth;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.isIncludeElement(qName) && this.getState() == 3 && !this.getSawFallback(this.fDepth + 1)) {
            this.reportFatalError("NoFallback");
        }
        if (this.isFallbackElement(qName)) {
            if (this.getState() == 1) {
                this.setState(2);
            }
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endElement(qName, augmentations);
            if (this.fRootDepth == this.fDepth) {
                this.fRootDepth = 0;
            }
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth + 1, false);
        --this.fDepth;
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            ++this.fDepth;
            augmentations = this.modifyAugmentations(augmentations);
            this.fDocumentHandler.characters(xMLString, augmentations);
            --this.fDepth;
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.attributeDecl(string, string2, string3, stringArray, string4, xMLString, xMLString2, augmentations);
        }
    }

    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.elementDecl(string, string2, augmentations);
        }
    }

    public void endAttlist(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endAttlist(augmentations);
        }
    }

    public void endConditional(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endConditional(augmentations);
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endDTD(augmentations);
        }
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endExternalSubset(augmentations);
        }
    }

    public void endParameterEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endParameterEntity(string, augmentations);
        }
    }

    public void externalEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.externalEntityDecl(string, xMLResourceIdentifier, augmentations);
        }
    }

    public XMLDTDSource getDTDSource() {
        return this.fDTDSource;
    }

    public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.ignoredCharacters(xMLString, augmentations);
        }
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.internalEntityDecl(string, xMLString, xMLString2, augmentations);
        }
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.addNotation(string, xMLResourceIdentifier, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(string, xMLResourceIdentifier, augmentations);
        }
    }

    public void setDTDSource(XMLDTDSource xMLDTDSource) {
        this.fDTDSource = xMLDTDSource;
    }

    public void startAttlist(String string, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startAttlist(string, augmentations);
        }
    }

    public void startConditional(short s, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startConditional(s, augmentations);
        }
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(xMLLocator, augmentations);
        }
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startExternalSubset(xMLResourceIdentifier, augmentations);
        }
    }

    public void startParameterEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startParameterEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void unparsedEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.addUnparsedEntity(string, xMLResourceIdentifier, string2, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.unparsedEntityDecl(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    private void setErrorReporter(XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
        if (this.fErrorReporter != null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xinclude", new XIncludeMessageFormatter());
        }
    }

    protected void handleFallbackElement() {
        this.setSawInclude(this.fDepth, false);
        this.fNamespaceContext.setContextInvalid();
        if (!this.getSawInclude(this.fDepth - 1)) {
            this.reportFatalError("FallbackParent");
        }
        if (this.getSawFallback(this.fDepth)) {
            this.reportFatalError("MultipleFallbacks");
        } else {
            this.setSawFallback(this.fDepth, true);
        }
        if (this.getState() == 3) {
            this.setState(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleIncludeElement(XMLAttributes xMLAttributes) throws XNIException {
        this.setSawInclude(this.fDepth, true);
        this.fNamespaceContext.setContextInvalid();
        if (this.getSawInclude(this.fDepth - 1)) {
            this.reportFatalError("IncludeChild", new Object[]{XINCLUDE_INCLUDE});
        }
        if (this.getState() == 2) {
            return;
        }
        String string = xMLAttributes.getValue(XINCLUDE_ATTR_HREF);
        String string2 = xMLAttributes.getValue(XINCLUDE_ATTR_PARSE);
        if (string == null) {
            this.reportFatalError("HrefMissing");
        }
        if (string2 == null) {
            string2 = XINCLUDE_PARSE_XML;
        }
        XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(null, string, this.fDocLocation.getBaseSystemId(), null);
        XMLInputSource xMLInputSource = null;
        if (this.fEntityResolver != null) {
            try {
                xMLInputSource = this.fEntityResolver.resolveEntity(xMLResourceIdentifierImpl);
            }
            catch (IOException iOException) {
                throw new XIncludeResourceError("XMLResourceError", new Object[]{iOException.getMessage()});
            }
        }
        if (xMLInputSource == null) {
            xMLInputSource = new XMLInputSource(null, string, this.fDocLocation.getBaseSystemId());
        }
        if (string2.equals(XINCLUDE_PARSE_XML)) {
            if (this.fChildConfig == null) {
                String string3 = XINCLUDE_DEFAULT_CONFIGURATION;
                this.fChildConfig = (XMLParserConfiguration)ObjectFactory.newInstance(string3, ObjectFactory.findClassLoader(), true);
                this.fChildConfig.setProperty(ERROR_REPORTER, this.fErrorReporter);
                this.fChildConfig.setProperty("http://apache.org/xml/properties/internal/namespace-context", this.fNamespaceContext);
                XIncludeHandler xIncludeHandler = (XIncludeHandler)this.fChildConfig.getProperty("http://apache.org/xml/properties/internal/xinclude-handler");
                xIncludeHandler.setParent(this);
                xIncludeHandler.setDocumentHandler(this.getDocumentHandler());
            }
            this.copyFeatures((XMLComponentManager)this.fSettings, this.fChildConfig);
            this.fChildConfig.setFeature("http://apache.org/xml/features/validation/schema", false);
            try {
                try {
                    this.fNamespaceContext.pushScope();
                    this.fChildConfig.parse(xMLInputSource);
                }
                catch (XIncludeFatalError xIncludeFatalError) {
                    this.reportFatalError(xIncludeFatalError.getKey(), xIncludeFatalError.getArgs());
                    Object var10_14 = null;
                    this.fNamespaceContext.popScope();
                    return;
                }
                catch (XNIException xNIException) {
                    this.reportFatalError("XMLParseError");
                    Object var10_15 = null;
                    this.fNamespaceContext.popScope();
                    return;
                }
                catch (IOException iOException) {
                    throw new XIncludeResourceError("XMLResourceError", new Object[]{iOException.getMessage()});
                }
                Object var10_13 = null;
                this.fNamespaceContext.popScope();
                return;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                this.fNamespaceContext.popScope();
                throw throwable;
            }
        }
        if (!string2.equals(XINCLUDE_PARSE_TEXT)) {
            this.reportFatalError("InvalidParseValue", new Object[]{string2});
            return;
        }
        String string4 = xMLAttributes.getValue(XINCLUDE_ATTR_ENCODING);
        xMLInputSource.setEncoding(string4);
        XIncludeTextReader xIncludeTextReader = null;
        try {
            try {
                xIncludeTextReader = new XIncludeTextReader(xMLInputSource, this);
                xIncludeTextReader.parse();
            }
            catch (IOException iOException) {
                throw new XIncludeResourceError("TextResourceError", new Object[]{iOException.getMessage()});
            }
            Object var12_20 = null;
            if (xIncludeTextReader == null) return;
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            if (xIncludeTextReader == null) throw throwable;
            try {
                xIncludeTextReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new XIncludeResourceError("TextResourceError", new Object[]{iOException.getMessage()});
            }
        }
        try {}
        catch (IOException iOException) {
            throw new XIncludeResourceError("TextResourceError", new Object[]{iOException.getMessage()});
        }
        xIncludeTextReader.close();
    }

    protected boolean hasXIncludeNamespace(QName qName) {
        return qName.uri == XINCLUDE_NS_URI || this.fNamespaceContext.getURI(qName.prefix) == XINCLUDE_NS_URI;
    }

    protected boolean isIncludeElement(QName qName) {
        return qName.localpart.equals(XINCLUDE_INCLUDE) && this.hasXIncludeNamespace(qName);
    }

    protected boolean isFallbackElement(QName qName) {
        return qName.localpart.equals(XINCLUDE_FALLBACK) && this.hasXIncludeNamespace(qName);
    }

    protected boolean sameBaseURISourceAsParent() {
        if (this.fDepth == this.fRootDepth) {
            try {
                URL uRL = new URL(this.fDocLocation.getExpandedSystemId());
                URL uRL2 = new URL(this.fParentXIncludeHandler.fDocLocation.getExpandedSystemId());
                URL uRL3 = new URL(uRL2, new File(uRL.getFile()).getName());
                return uRL.sameFile(uRL3);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    protected boolean searchForRecursiveIncludes(XMLLocator xMLLocator) {
        String string = xMLLocator.getExpandedSystemId();
        if (string == null) {
            try {
                string = XMLEntityManager.expandSystemId(xMLLocator.getLiteralSystemId(), xMLLocator.getBaseSystemId(), false);
            }
            catch (URI.MalformedURIException malformedURIException) {
                throw new XIncludeFatalError("ExpandedSystemId", null);
            }
        }
        if (string.equals(this.fDocLocation.getExpandedSystemId())) {
            return true;
        }
        if (this.fParentXIncludeHandler == null) {
            return false;
        }
        return this.fParentXIncludeHandler.searchForRecursiveIncludes(xMLLocator);
    }

    protected boolean isTopLevelIncludedItem() {
        return this.isTopLevelIncludedItemViaInclude() || this.isTopLevelIncludedItemViaFallback();
    }

    protected boolean isTopLevelIncludedItemViaInclude() {
        return this.fDepth == 1 && !this.isRootDocument();
    }

    protected boolean isTopLevelIncludedItemViaFallback() {
        return this.getSawFallback(this.fDepth - 1);
    }

    protected XMLAttributes processAttributes(XMLAttributes xMLAttributes) {
        Object object;
        String string;
        String string2;
        if (this.isTopLevelIncludedItem()) {
            if (!this.sameBaseURISourceAsParent()) {
                if (xMLAttributes == null) {
                    xMLAttributes = new XMLAttributesImpl();
                }
                int n = xMLAttributes.addAttribute(XML_BASE_QNAME, XMLSymbols.fCDATASymbol, this.fDocLocation.getBaseSystemId());
                xMLAttributes.setSpecified(n, true);
            }
            Enumeration enumeration = this.fNamespaceContext.getAllPrefixes();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                string2 = this.fNamespaceContext.getURIFromIncludeParent(string3);
                if (string2 == (string = this.fNamespaceContext.getURI(string3)) || xMLAttributes == null) continue;
                if (string3 == XMLSymbols.EMPTY_STRING) {
                    if (xMLAttributes.getValue(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS) != null) continue;
                    if (xMLAttributes == null) {
                        xMLAttributes = new XMLAttributesImpl();
                    }
                    object = (QName)NEW_NS_ATTR_QNAME.clone();
                    ((QName)object).localpart = XMLSymbols.PREFIX_XMLNS;
                    ((QName)object).rawname = XMLSymbols.PREFIX_XMLNS;
                    xMLAttributes.addAttribute((QName)object, XMLSymbols.fCDATASymbol, string);
                    continue;
                }
                if (xMLAttributes.getValue(NamespaceContext.XMLNS_URI, string3) != null) continue;
                if (xMLAttributes == null) {
                    xMLAttributes = new XMLAttributesImpl();
                }
                object = (QName)NEW_NS_ATTR_QNAME.clone();
                ((QName)object).localpart = string3;
                ((QName)object).rawname = ((QName)object).rawname + string3;
                xMLAttributes.addAttribute((QName)object, XMLSymbols.fCDATASymbol, string);
            }
        }
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                string2 = xMLAttributes.getType(n2);
                string = xMLAttributes.getValue(n2);
                if (string2 == XMLSymbols.fENTITYSymbol) {
                    this.checkUnparsedEntity(string);
                }
                if (string2 == XMLSymbols.fENTITIESSymbol) {
                    object = new StringTokenizer(string);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        this.checkUnparsedEntity(string4);
                    }
                } else if (string2 == XMLSymbols.fNOTATIONSymbol) {
                    this.checkNotation(string);
                }
                ++n2;
            }
        }
        return xMLAttributes;
    }

    protected Augmentations modifyAugmentations(Augmentations augmentations) {
        return this.modifyAugmentations(augmentations, false);
    }

    protected Augmentations modifyAugmentations(Augmentations augmentations, boolean bl) {
        if (bl || this.isTopLevelIncludedItem()) {
            if (augmentations == null) {
                augmentations = new AugmentationsImpl();
            }
            augmentations.putItem(XINCLUDE_INCLUDED, Boolean.TRUE);
        }
        return augmentations;
    }

    protected int getState(int n) {
        return this.fState[n];
    }

    protected int getState() {
        return this.fState[this.fDepth];
    }

    protected void setState(int n) {
        if (this.fDepth >= this.fState.length) {
            int[] nArray = new int[this.fDepth * 2];
            System.arraycopy(this.fState, 0, nArray, 0, this.fState.length);
            this.fState = nArray;
        }
        this.fState[this.fDepth] = n;
    }

    protected void setSawFallback(int n, boolean bl) {
        if (n >= this.fSawFallback.length) {
            boolean[] blArray = new boolean[n * 2];
            System.arraycopy(this.fSawFallback, 0, blArray, 0, this.fSawFallback.length);
            this.fSawFallback = blArray;
        }
        this.fSawFallback[n] = bl;
    }

    protected boolean getSawFallback(int n) {
        if (n >= this.fSawFallback.length) {
            return false;
        }
        return this.fSawFallback[n];
    }

    protected void setSawInclude(int n, boolean bl) {
        if (n >= this.fSawInclude.length) {
            boolean[] blArray = new boolean[n * 2];
            System.arraycopy(this.fSawInclude, 0, blArray, 0, this.fSawInclude.length);
            this.fSawInclude = blArray;
        }
        this.fSawInclude[n] = bl;
    }

    protected boolean getSawInclude(int n) {
        if (n >= this.fSawInclude.length) {
            return false;
        }
        return this.fSawInclude[n];
    }

    protected void reportFatalError(String string) {
        this.reportFatalError(string, null);
    }

    protected void reportFatalError(String string, Object[] objectArray) {
        if (this.fErrorReporter != null) {
            this.fErrorReporter.reportError(this.fDocLocation, "http://www.w3.org/TR/xinclude", string, objectArray, (short)2);
        }
    }

    protected void setParent(XIncludeHandler xIncludeHandler) {
        this.fParentXIncludeHandler = xIncludeHandler;
    }

    protected boolean isRootDocument() {
        return this.fParentXIncludeHandler == null;
    }

    protected void addUnparsedEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) {
        UnparsedEntity unparsedEntity = new UnparsedEntity();
        unparsedEntity.name = string;
        unparsedEntity.systemId = xMLResourceIdentifier.getLiteralSystemId();
        unparsedEntity.publicId = xMLResourceIdentifier.getPublicId();
        unparsedEntity.baseURI = xMLResourceIdentifier.getBaseSystemId();
        unparsedEntity.notation = string2;
        unparsedEntity.augmentations = augmentations;
        this.fUnparsedEntities.add(unparsedEntity);
    }

    protected void addNotation(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) {
        Notation notation = new Notation();
        notation.name = string;
        notation.systemId = xMLResourceIdentifier.getLiteralSystemId();
        notation.publicId = xMLResourceIdentifier.getPublicId();
        notation.baseURI = xMLResourceIdentifier.getBaseSystemId();
        notation.augmentations = augmentations;
        this.fNotations.add(notation);
    }

    protected void checkUnparsedEntity(String string) {
        UnparsedEntity unparsedEntity = new UnparsedEntity();
        unparsedEntity.name = string;
        int n = this.fUnparsedEntities.indexOf(unparsedEntity);
        if (n != -1) {
            unparsedEntity = (UnparsedEntity)this.fUnparsedEntities.get(n);
            try {
                this.checkNotation(unparsedEntity.notation);
            }
            catch (XIncludeFatalError xIncludeFatalError) {
                this.reportFatalError(xIncludeFatalError.getKey(), xIncludeFatalError.getArgs());
            }
            try {
                this.checkAndSendUnparsedEntity(unparsedEntity);
            }
            catch (XIncludeFatalError xIncludeFatalError) {
                this.reportFatalError(xIncludeFatalError.getKey(), xIncludeFatalError.getArgs());
            }
        }
    }

    protected void checkNotation(String string) {
        Notation notation = new Notation();
        notation.name = string;
        int n = this.fNotations.indexOf(notation);
        if (n != -1) {
            notation = (Notation)this.fNotations.get(n);
            try {
                this.checkAndSendNotation(notation);
            }
            catch (XIncludeFatalError xIncludeFatalError) {
                this.reportFatalError(xIncludeFatalError.getKey(), xIncludeFatalError.getArgs());
            }
        }
    }

    protected void checkAndSendUnparsedEntity(UnparsedEntity unparsedEntity) throws XIncludeFatalError {
        if (this.isRootDocument()) {
            int n = this.fUnparsedEntities.indexOf(unparsedEntity);
            if (n == -1) {
                XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(unparsedEntity.publicId, unparsedEntity.systemId, unparsedEntity.baseURI, null);
                this.addUnparsedEntity(unparsedEntity.name, xMLResourceIdentifierImpl, unparsedEntity.notation, unparsedEntity.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.unparsedEntityDecl(unparsedEntity.name, xMLResourceIdentifierImpl, unparsedEntity.notation, unparsedEntity.augmentations);
                }
            } else {
                UnparsedEntity unparsedEntity2 = (UnparsedEntity)this.fUnparsedEntities.get(n);
                if (!unparsedEntity.isDuplicate(unparsedEntity2)) {
                    throw new XIncludeFatalError("NonDuplicateUnparsedEntity", new Object[]{unparsedEntity.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendUnparsedEntity(unparsedEntity);
        }
    }

    protected void checkAndSendNotation(Notation notation) throws XIncludeFatalError {
        if (this.isRootDocument()) {
            int n = this.fNotations.indexOf(notation);
            if (n == -1) {
                XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(notation.publicId, notation.systemId, notation.baseURI, null);
                this.addNotation(notation.name, xMLResourceIdentifierImpl, notation.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.notationDecl(notation.name, xMLResourceIdentifierImpl, notation.augmentations);
                }
            } else {
                Notation notation2 = (Notation)this.fNotations.get(n);
                if (!notation.isDuplicate(notation2)) {
                    throw new XIncludeFatalError("NonDuplicateNotation", new Object[]{notation.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendNotation(notation);
        }
    }

    protected void copyFeatures(XMLComponentManager xMLComponentManager, ParserConfigurationSettings parserConfigurationSettings) {
        Enumeration enumeration = Constants.getXercesFeatures();
        this.copyFeatures1(enumeration, "http://apache.org/xml/features/", xMLComponentManager, parserConfigurationSettings);
        enumeration = Constants.getSAXFeatures();
        this.copyFeatures1(enumeration, "http://xml.org/sax/features/", xMLComponentManager, parserConfigurationSettings);
    }

    protected void copyFeatures(XMLComponentManager xMLComponentManager, XMLParserConfiguration xMLParserConfiguration) {
        Enumeration enumeration = Constants.getXercesFeatures();
        this.copyFeatures1(enumeration, "http://apache.org/xml/features/", xMLComponentManager, xMLParserConfiguration);
        enumeration = Constants.getSAXFeatures();
        this.copyFeatures1(enumeration, "http://xml.org/sax/features/", xMLComponentManager, xMLParserConfiguration);
    }

    private void copyFeatures1(Enumeration enumeration, String string, XMLComponentManager xMLComponentManager, ParserConfigurationSettings parserConfigurationSettings) {
        while (enumeration.hasMoreElements()) {
            String string2 = string + (String)enumeration.nextElement();
            parserConfigurationSettings.addRecognizedFeatures(new String[]{string2});
            try {
                parserConfigurationSettings.setFeature(string2, xMLComponentManager.getFeature(string2));
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                // empty catch block
            }
        }
    }

    private void copyFeatures1(Enumeration enumeration, String string, XMLComponentManager xMLComponentManager, XMLParserConfiguration xMLParserConfiguration) {
        while (enumeration.hasMoreElements()) {
            String string2 = string + (String)enumeration.nextElement();
            boolean bl = xMLComponentManager.getFeature(string2);
            try {
                xMLParserConfiguration.setFeature(string2, bl);
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                // empty catch block
            }
        }
    }

    protected class UnparsedEntity {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public String notation;
        public Augmentations augmentations;

        protected UnparsedEntity() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof UnparsedEntity) {
                UnparsedEntity unparsedEntity = (UnparsedEntity)object;
                return this.name.equals(unparsedEntity.name);
            }
            return false;
        }

        public boolean isDuplicate(Object object) {
            if (object != null && object instanceof UnparsedEntity) {
                UnparsedEntity unparsedEntity = (UnparsedEntity)object;
                return this.name.equals(unparsedEntity.name) && (this.systemId == unparsedEntity.systemId || this.systemId != null && this.systemId.equals(unparsedEntity.systemId)) && (this.publicId == unparsedEntity.publicId || this.publicId != null && this.publicId.equals(unparsedEntity.publicId)) && (this.baseURI == unparsedEntity.baseURI || this.baseURI != null && this.baseURI.equals(unparsedEntity.baseURI)) && (this.notation == unparsedEntity.notation || this.notation != null && this.notation.equals(unparsedEntity.notation));
            }
            return false;
        }
    }

    protected class Notation {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public Augmentations augmentations;

        protected Notation() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Notation) {
                Notation notation = (Notation)object;
                return this.name.equals(notation.name);
            }
            return false;
        }

        public boolean isDuplicate(Object object) {
            if (object != null && object instanceof Notation) {
                Notation notation = (Notation)object;
                return this.name.equals(notation.name) && (this.systemId == notation.systemId || this.systemId != null && this.systemId.equals(notation.systemId)) && (this.publicId == notation.publicId || this.publicId != null && this.publicId.equals(notation.publicId)) && (this.baseURI == notation.baseURI || this.baseURI != null && this.baseURI.equals(notation.baseURI));
            }
            return false;
        }
    }
}

