/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.menus.IContributionRoot;

final class ContributionRoot
implements IContributionRoot {
    private List topLevelItems = new ArrayList();
    private List itemsToExpressions = new ArrayList();
    private InternalMenuService menuService;
    private Expression restriction;
    private String namespace;

    public ContributionRoot(InternalMenuService menuService, Expression restriction, String namespace) {
        this.menuService = menuService;
        this.restriction = restriction;
        this.namespace = namespace;
    }

    public void addContributionItem(IContributionItem item, Expression visibleWhen) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        this.topLevelItems.add(item);
        if (visibleWhen == null) {
            visibleWhen = AlwaysEnabledExpression.INSTANCE;
        }
        this.menuService.registerVisibleWhen(item, visibleWhen, this.restriction, this.createIdentifierId(item));
        this.itemsToExpressions.add(item);
    }

    private String createIdentifierId(IContributionItem item) {
        String identifierID = this.namespace != null ? String.valueOf(this.namespace) + '/' + item.getId() : null;
        return identifierID;
    }

    public Collection getItems() {
        return this.topLevelItems;
    }

    public void release() {
        Iterator itemIter = this.itemsToExpressions.iterator();
        while (itemIter.hasNext()) {
            IContributionItem item = (IContributionItem)itemIter.next();
            this.menuService.unregisterVisibleWhen(item);
        }
    }

    public void registerVisibilityForChild(IContributionItem item, Expression visibleWhen) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (visibleWhen == null) {
            visibleWhen = AlwaysEnabledExpression.INSTANCE;
        }
        this.menuService.registerVisibleWhen(item, visibleWhen, this.restriction, this.createIdentifierId(item));
        this.itemsToExpressions.add(item);
    }
}

