/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class ClearableSemaphore {
    protected Logger log = Logger.getLogger(ClearableSemaphore.class);
    private volatile Semaphore semaphore;
    private int permits;

    private void createSemaphore() {
        this.semaphore = new Semaphore(this.permits, true);
    }

    public ClearableSemaphore(int permits) {
        this.permits = permits;
        this.createSemaphore();
    }

    public void acquire() throws InterruptedException {
        Semaphore sem = this.semaphore;
        if (sem != null) {
            sem.acquire();
        }
    }

    public boolean tryAcquire(long timeout) throws InterruptedException {
        Semaphore sem = this.semaphore;
        if (sem != null) {
            return sem.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    public void release() {
        Semaphore sem = this.semaphore;
        if (sem != null) {
            sem.release();
        }
    }

    public synchronized void disable() {
        if (this.semaphore != null) {
            Semaphore oldSem = this.semaphore;
            this.semaphore = null;
            oldSem.release(this.permits);
        }
    }

    public synchronized void enable() {
        if (this.semaphore == null) {
            this.createSemaphore();
        }
    }
}

