/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.jboss.logging.Logger;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;

public class SpyConnectionConsumer
implements ConnectionConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger(SpyConnectionConsumer.class);
    static boolean trace = log.isTraceEnabled();
    Connection connection;
    Destination destination;
    ServerSessionPool serverSessionPool;
    int maxMessages;
    LinkedList queue = new LinkedList();
    boolean closed = false;
    boolean waitingForMessage = false;
    Subscription subscription = new Subscription();
    Thread internalThread;
    int id;
    static SynchronizedInt threadId = new SynchronizedInt(0);

    public SpyConnectionConsumer(Connection connection, Destination destination, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        trace = log.isTraceEnabled();
        this.connection = connection;
        this.destination = destination;
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = maxMessages;
        if (this.maxMessages < 1) {
            this.maxMessages = 1;
        }
        this.subscription.destination = (SpyDestination)destination;
        this.subscription.messageSelector = messageSelector;
        this.subscription.noLocal = false;
        connection.addConsumer(this);
        this.id = threadId.increment();
        this.internalThread = new Thread((Runnable)this, "Connection Consumer for dest " + this.subscription + " id=" + this.id);
        this.internalThread.start();
        if (trace) {
            log.trace("New " + this);
        }
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SpyMessage mes) throws JMSException {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.closed) {
                if (trace) {
                    log.trace("Consumer close nacking message=" + mes.header.jmsMessageID + " " + this);
                }
                log.warn("NACK issued. The connection consumer was closed.");
                this.connection.send(mes.getAcknowledgementRequest(false));
                return;
            }
            if (trace) {
                log.trace("Add message=" + mes.header.jmsMessageID + " " + this);
            }
            if (this.waitingForMessage) {
                this.queue.addLast(mes);
                this.queue.notifyAll();
            } else {
                if (trace) {
                    log.trace("Consumer not waiting nacking message=" + mes.header.jmsMessageID + " " + this);
                }
                this.connection.send(mes.getAcknowledgementRequest(false));
            }
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        LinkedList linkedList;
        block18: {
            linkedList = this.queue;
            synchronized (linkedList) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.queue.notifyAll();
            }
            if (trace) {
                log.trace("Close " + this);
            }
            if (this.internalThread != null && !this.internalThread.equals(Thread.currentThread())) {
                try {
                    if (trace) {
                        log.trace("Joining thread " + this);
                    }
                    this.internalThread.join();
                }
                catch (InterruptedException e) {
                    if (!trace) break block18;
                    log.trace("Ignoring interrupting while joining thread " + this);
                }
            }
        }
        linkedList = this.queue;
        synchronized (linkedList) {
            block20: {
                block19: {
                    if (trace) {
                        log.trace("Nacking messages on queue " + this);
                    }
                    try {
                        while (!this.queue.isEmpty()) {
                            SpyMessage message = (SpyMessage)this.queue.removeFirst();
                            this.connection.send(message.getAcknowledgementRequest(false));
                        }
                    }
                    catch (Throwable ignore) {
                        if (!trace) break block19;
                        log.trace("Ignoring error nacking messages in queue " + this, ignore);
                    }
                }
                try {
                    this.connection.removeConsumer(this);
                }
                catch (Throwable ignore) {
                    if (!trace) break block20;
                    log.trace("Ignoring error removing consumer from connection " + this, ignore);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<SpyMessage> mesList = new ArrayList<SpyMessage>();
        try {
            while (true) {
                Cloneable mes;
                LinkedList linkedList = this.queue;
                synchronized (linkedList) {
                    if (this.closed) {
                        if (trace) {
                            log.trace("run() closed " + this);
                        }
                        break;
                    }
                }
                for (int i = 0; i < this.maxMessages; ++i) {
                    mes = this.connection.receive(this.subscription, -1L);
                    if (mes == null) {
                        if (!trace) break;
                        log.trace("run() receivedNoWait got no message" + this);
                        break;
                    }
                    if (trace) {
                        log.trace("run() receivedNoWait message=" + mes.header.jmsMessageID + " " + this);
                    }
                    mesList.add((SpyMessage)mes);
                }
                if (mesList.isEmpty()) {
                    SpyMessage mes2 = null;
                    mes = this.queue;
                    synchronized (mes) {
                        mes2 = this.connection.receive(this.subscription, 0L);
                        if (mes2 == null) {
                            this.waitingForMessage = true;
                            while (this.queue.isEmpty() && !this.closed) {
                                if (trace) {
                                    log.trace("run() waiting for message " + this);
                                }
                                try {
                                    this.queue.wait();
                                }
                                catch (InterruptedException e) {
                                    if (!trace) continue;
                                    log.trace("Ignoring interruption waiting for message " + this, e);
                                }
                            }
                            if (this.closed) {
                                if (trace) {
                                    log.trace("run() closed while waiting " + this);
                                }
                                this.waitingForMessage = false;
                                break;
                            }
                            mes2 = (SpyMessage)this.queue.removeFirst();
                            this.waitingForMessage = false;
                            if (trace) {
                                log.trace("run() got message message=" + mes2.header.jmsMessageID + " " + this);
                            }
                        }
                    }
                    mesList.add(mes2);
                }
                if (trace) {
                    log.trace("Waiting for serverSesionPool " + this);
                }
                ServerSession serverSession = this.serverSessionPool.getServerSession();
                SpySession spySession = (SpySession)serverSession.getSession();
                if (trace) {
                    log.trace("Waited serverSesion=" + serverSession + " session=" + spySession + " " + this);
                }
                if (spySession.sessionConsumer == null) {
                    if (trace) {
                        log.trace("Session did not have a set MessageListner " + spySession + " " + this);
                    }
                } else {
                    spySession.sessionConsumer.subscription = this.subscription;
                }
                for (int i = 0; i < mesList.size(); ++i) {
                    spySession.addMessage((SpyMessage)mesList.get(i));
                }
                if (trace) {
                    log.trace(" Starting the ServerSession=" + serverSession + " " + this);
                }
                serverSession.start();
                mesList.clear();
            }
        }
        catch (Throwable t) {
            block37: {
                block36: {
                    try {
                        for (int i = 0; i < mesList.size(); ++i) {
                            SpyMessage msg = (SpyMessage)mesList.get(i);
                            this.connection.send(msg.getAcknowledgementRequest(false));
                        }
                    }
                    catch (Throwable ignore) {
                        if (!trace) break block36;
                        log.trace("Ignoring error nacking message " + this, ignore);
                    }
                }
                try {
                    this.close();
                }
                catch (Throwable ignore) {
                    if (!trace) break block37;
                    log.trace("Ignoring error during close " + this, ignore);
                }
            }
            this.connection.asynchFailure("Connection consumer closing due to error in listening thread" + this, t);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SpyConnectionConsumer[sub=").append(this.subscription);
        if (this.closed) {
            buffer.append(" CLOSED");
        }
        buffer.append(" messages=").append(this.queue.size());
        buffer.append(" waitingForMessage=").append(this.waitingForMessage);
        if (this.internalThread != null) {
            buffer.append(" internalThread=").append(this.internalThread);
        }
        buffer.append(" sessionPool=").append(this.serverSessionPool);
        buffer.append(" connection=").append(this.connection);
        buffer.append(']');
        return buffer.toString();
    }
}

