/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.jms.client.container.JMSClientVMIdentifier;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.ChannelFactory;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotifier;
import org.jboss.messaging.core.contract.Condition;
import org.jboss.messaging.core.contract.ConditionFactory;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.Filter;
import org.jboss.messaging.core.contract.FilterFactory;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.core.impl.IDManager;
import org.jboss.messaging.core.impl.JDBCSupport;
import org.jboss.messaging.core.impl.MessagingQueue;
import org.jboss.messaging.core.impl.postoffice.AckAllReplicatedDeliveriesMessage;
import org.jboss.messaging.core.impl.postoffice.AddAllReplicatedDeliveriesMessage;
import org.jboss.messaging.core.impl.postoffice.BindRequest;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.GetReplicatedDeliveriesRequest;
import org.jboss.messaging.core.impl.postoffice.GroupListener;
import org.jboss.messaging.core.impl.postoffice.GroupMember;
import org.jboss.messaging.core.impl.postoffice.JoinClusterRequest;
import org.jboss.messaging.core.impl.postoffice.LeaveClusterRequest;
import org.jboss.messaging.core.impl.postoffice.MappingInfo;
import org.jboss.messaging.core.impl.postoffice.MessageRequest;
import org.jboss.messaging.core.impl.postoffice.PostOfficeAddressInfo;
import org.jboss.messaging.core.impl.postoffice.PutReplicantRequest;
import org.jboss.messaging.core.impl.postoffice.RemoveReplicantRequest;
import org.jboss.messaging.core.impl.postoffice.ReplicateAckMessage;
import org.jboss.messaging.core.impl.postoffice.ReplicateDeliveryAckMessage;
import org.jboss.messaging.core.impl.postoffice.ReplicateDeliveryMessage;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jboss.messaging.core.impl.postoffice.SharedState;
import org.jboss.messaging.core.impl.postoffice.UnbindRequest;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.messaging.core.impl.tx.TransactionRepository;
import org.jboss.messaging.core.impl.tx.TxCallback;
import org.jboss.messaging.util.ClearableSemaphore;
import org.jboss.messaging.util.ConcurrentHashSet;
import org.jboss.messaging.util.StreamUtils;
import org.jgroups.Address;
import org.jgroups.View;

public class MessagingPostOffice
extends JDBCSupport
implements PostOffice,
RequestTarget,
GroupListener,
Replicator {
    private static final Logger log = Logger.getLogger(MessagingPostOffice.class);
    public static final String VIEW_CHANGED_NOTIFICATION = "VIEW_CHANGED";
    public static final String FAILOVER_COMPLETED_NOTIFICATION = "FAILOVER_COMPLETED";
    private static final long SEMAPHORE_ACQUIRE_TIMEOUT = 10000L;
    private boolean trace = log.isTraceEnabled();
    private MessageStore ms;
    private PersistenceManager pm;
    private TransactionRepository tr;
    private FilterFactory filterFactory;
    private ConditionFactory conditionFactory;
    private int thisNodeID;
    private Map mappings;
    private Map nameMaps;
    private Map localNameMap;
    private Map channelIDMap;
    private ReadWriteLock lock;
    private String officeName;
    private boolean clustered;
    private volatile boolean started;
    private GroupMember groupMember;
    private Map replicatedData;
    private Map failoverMap;
    private Set leftSet;
    private NotificationBroadcasterSupport nbSupport;
    private IDManager channelIDManager;
    private ClusterNotifier clusterNotifier;
    private Map nodeIDAddressMap;
    private Object waitForBindUnbindLock;
    private Map loadedBindings;
    private boolean supportsFailover = true;
    private ServerPeer serverPeer;
    private QueuedExecutor replyExecutor;
    private QueuedExecutor replicateResponseExecutor;
    private volatile int failoverNodeID = -1;
    private volatile boolean firstNode;
    private ClearableSemaphore replicateSemaphore;
    private boolean useJGroupsWorkaround;

    public static String dumpFailoverMap(Map map) {
        StringBuffer sb = new StringBuffer("\n");
        for (Map.Entry entry : map.entrySet()) {
            Integer primary = (Integer)entry.getKey();
            Integer secondary = (Integer)entry.getValue();
            sb.append("             ").append(primary).append("->").append(secondary).append("\n");
        }
        return sb.toString();
    }

    public static String dumpClusterMap(Map map) {
        StringBuffer sb = new StringBuffer("\n");
        for (Map.Entry entry : map.entrySet()) {
            Integer nodeID = (Integer)entry.getKey();
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
            sb.append("             ").append(nodeID).append("->").append(info).append("\n");
        }
        return sb.toString();
    }

    public MessagingPostOffice(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, int nodeId, String officeName, MessageStore ms, PersistenceManager pm, TransactionRepository tr, FilterFactory filterFactory, ConditionFactory conditionFactory, IDManager channelIDManager, ClusterNotifier clusterNotifier) throws Exception {
        super(ds, tm, sqlProperties, createTablesOnStartup);
        this.thisNodeID = nodeId;
        this.ms = ms;
        this.pm = pm;
        this.tr = tr;
        this.filterFactory = filterFactory;
        this.conditionFactory = conditionFactory;
        this.officeName = officeName;
        this.clustered = false;
        this.channelIDManager = channelIDManager;
        this.clusterNotifier = clusterNotifier;
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.waitForBindUnbindLock = new Object();
    }

    public MessagingPostOffice(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup, int nodeId, String officeName, MessageStore ms, PersistenceManager pm, TransactionRepository tr, FilterFactory filterFactory, ConditionFactory conditionFactory, IDManager channelIDManager, ClusterNotifier clusterNotifier, String groupName, ChannelFactory jChannelFactory, long stateTimeout, long castTimeout, boolean supportsFailover, int maxConcurrentReplications) throws Exception {
        this(ds, tm, sqlProperties, createTablesOnStartup, nodeId, officeName, ms, pm, tr, filterFactory, conditionFactory, channelIDManager, clusterNotifier);
        this.clustered = true;
        this.groupMember = new GroupMember(groupName, stateTimeout, castTimeout, jChannelFactory, this, this);
        this.supportsFailover = supportsFailover;
        this.nbSupport = new NotificationBroadcasterSupport();
        this.replicateSemaphore = new ClearableSemaphore(maxConcurrentReplications);
        this.useJGroupsWorkaround = "true".equals(System.getProperty("jboss.messaging.usejgroupsworkaround"));
        log.debug((Object)("Using JGroups flow control workaround: " + this.useJGroupsWorkaround));
    }

    public MessagingComponent getInstance() {
        return this;
    }

    public void start() throws Exception {
        if (this.started) {
            log.warn((Object)(this + " is already started"));
            return;
        }
        log.debug((Object)(this + " starting"));
        super.start();
        this.init();
        this.loadedBindings = this.getBindingsFromStorage();
        if (this.clustered) {
            this.groupMember.start();
            if (this.knowAboutNodeId(this.thisNodeID)) {
                throw new IllegalArgumentException("Cannot start post office since there is already a post office in the cluster with the same node id (" + this.thisNodeID + "). " + "Are you sure you have given each node a unique node id during installation?");
            }
            PostOfficeAddressInfo info = new PostOfficeAddressInfo(this.groupMember.getControlChannelAddress(), this.groupMember.getDataChannelAddress());
            this.nodeIDAddressMap.put(new Integer(this.thisNodeID), info);
            this.calculateFailoverMap();
            String clientVMId = JMSClientVMIdentifier.instance;
            this.put((Serializable)((Object)"JVMID"), (Serializable)((Object)clientVMId));
            this.groupMember.multicastControl(new JoinClusterRequest(this.thisNodeID, info), true);
        }
        this.loadBindings();
        this.started = true;
        log.debug((Object)(this + " started"));
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            log.warn((Object)(this + " is not started"));
            return;
        }
        if (this.trace) {
            log.trace((Object)(this + " stopping"));
        }
        super.stop();
        if (this.clustered) {
            this.groupMember.multicastControl(new LeaveClusterRequest(this.thisNodeID), true);
            this.groupMember.stop();
        }
        this.deInit();
        this.started = false;
        log.debug((Object)(this + " stopped"));
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.nbSupport.addNotificationListener(listener, filter, object);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.nbSupport.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public String getOfficeName() {
        return this.officeName;
    }

    public boolean addBinding(Binding binding, boolean allNodes) throws Exception {
        if (allNodes && !binding.queue.isClustered()) {
            throw new IllegalArgumentException("Cannot bind a non clustered queue on all nodes");
        }
        boolean added = this.internalAddBinding(binding, allNodes, true);
        if (added && allNodes && this.clustered && binding.queue.isClustered()) {
            this.waitForBindUnbind(binding.queue.getName(), true);
        }
        if (added) {
            this.requestDeliveries(binding.queue);
        }
        return added;
    }

    public Binding removeBinding(String queueName, boolean allNodes) throws Throwable {
        Binding binding = this.internalRemoveBinding(queueName, allNodes, true);
        if (binding != null && allNodes && this.clustered && binding.queue.isClustered()) {
            this.waitForBindUnbind(queueName, false);
        }
        return binding;
    }

    public boolean route(MessageReference ref, Condition condition, Transaction tx) throws Exception {
        if (ref == null) {
            throw new IllegalArgumentException("Message reference is null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        return this.routeInternal(ref, condition, tx, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getQueuesForCondition(Condition condition, boolean localOnly) throws Exception {
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        if (!localOnly && !this.clustered) {
            throw new IllegalArgumentException("Cannot request clustered queues on non clustered post office");
        }
        this.lock.readLock().acquire();
        try {
            List queues = (List)this.mappings.get(condition);
            if (queues == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList<Queue> list = new ArrayList<Queue>();
            for (Queue queue : queues) {
                if (localOnly && queue.getNodeID() != this.thisNodeID) continue;
                list.add(queue);
            }
            ArrayList<Queue> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding getBindingForQueueName(String queueName) throws Exception {
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        this.lock.readLock().acquire();
        try {
            if (this.localNameMap != null) {
                Binding binding;
                Binding binding2 = binding = (Binding)this.localNameMap.get(queueName);
                return binding2;
            }
            Binding binding = null;
            return binding;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding getBindingForChannelID(long channelID) throws Exception {
        this.lock.readLock().acquire();
        try {
            Binding binding;
            Binding binding2 = binding = (Binding)this.channelIDMap.get(new Long(channelID));
            return binding2;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    public boolean isClustered() {
        return this.clustered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFailoverMap() {
        Map map = this.failoverMap;
        synchronized (map) {
            HashMap map2 = new HashMap(this.failoverMap);
            return map2;
        }
    }

    public Collection getAllBindingsForQueueName(String queueName) throws Exception {
        return this.getBindings(queueName);
    }

    public Collection getAllBindings() throws Exception {
        return this.getBindings(null);
    }

    public Set nodeIDView() {
        return new HashSet(this.nodeIDAddressMap.keySet());
    }

    public void sendReplicateDeliveryMessage(String queueName, String sessionID, long messageID, long deliveryID, boolean reply, boolean sync) throws Exception {
        boolean ok;
        if (reply && this.useJGroupsWorkaround && !(ok = this.replicateSemaphore.tryAcquire(10000L))) {
            log.warn((Object)"Timed out trying to acquire replication semaphore");
            return;
        }
        try {
            Address address;
            Address replyAddress = null;
            if (reply) {
                PostOfficeAddressInfo info = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(new Integer(this.thisNodeID));
                replyAddress = info.getDataChannelAddress();
            }
            ReplicateDeliveryMessage request = new ReplicateDeliveryMessage(this.thisNodeID, queueName, sessionID, messageID, deliveryID, replyAddress);
            if (this.trace) {
                log.trace((Object)(this + " sending replicate delivery message " + queueName + " " + sessionID + " " + messageID));
            }
            if ((address = this.getFailoverNodeDataChannelAddress()) != null) {
                this.groupMember.unicastData(request, address);
            }
        }
        catch (Exception e) {
            if (reply) {
                this.replicateSemaphore.release();
            }
            throw e;
        }
    }

    public void sendReplicateAckMessage(String queueName, long messageID) throws Exception {
        ReplicateAckMessage request = new ReplicateAckMessage(this.thisNodeID, queueName, messageID);
        Address address = this.getFailoverNodeDataChannelAddress();
        if (address != null) {
            this.groupMember.unicastData(request, address);
        }
    }

    public void injectServerPeer(ServerPeer serverPeer) {
        this.serverPeer = serverPeer;
    }

    public boolean isFirstNode() {
        return this.firstNode;
    }

    public Map getRecoveryArea(String queueName) {
        Binding binding = (Binding)this.localNameMap.get(queueName);
        if (binding != null) {
            return binding.queue.getRecoveryArea();
        }
        return null;
    }

    public int getRecoveryMapSize(String queueName) {
        Binding binding = (Binding)this.localNameMap.get(queueName);
        if (binding != null) {
            return binding.queue.getRecoveryMapSize();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte[] bytes) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " received state from group"));
        }
        SharedState state = new SharedState();
        StreamUtils.fromBytes(state, bytes);
        if (this.trace) {
            log.trace((Object)(this + " received " + state.getMappings().size() + " bindings and map " + state.getReplicatedData()));
        }
        this.mappings.clear();
        List mappings = state.getMappings();
        for (MappingInfo mapping : mappings) {
            Filter filter = null;
            if (mapping.getFilterString() != null) {
                filter = this.filterFactory.createFilter(mapping.getFilterString());
            }
            MessagingQueue queue = new MessagingQueue(mapping.getNodeId(), mapping.getQueueName(), mapping.getChannelId(), mapping.isRecoverable(), filter, true);
            Condition condition = this.conditionFactory.createCondition(mapping.getConditionText());
            this.addBindingInMemory(new Binding(condition, queue, false));
            if (!mapping.isAllNodes() || this.loadedBindings.containsKey(queue.getName())) continue;
            long channelID = this.channelIDManager.getID();
            MessagingQueue queue2 = new MessagingQueue(this.thisNodeID, mapping.getQueueName(), channelID, this.ms, this.pm, mapping.isRecoverable(), mapping.getMaxSize(), filter, mapping.getFullSize(), mapping.getPageSize(), mapping.getDownCacheSize(), true, mapping.getRecoverDeliveriesTimeout());
            Binding localBinding = new Binding(condition, queue2, true);
            if (mapping.isRecoverable()) {
                if (this.trace) {
                    log.trace((Object)(this + " got all binding in state for queue " + queue.getName() + " inserting it in DB"));
                }
                this.insertBindingInStorage(condition, queue2, true);
            }
            this.loadedBindings.put(mapping.getQueueName(), localBinding);
        }
        Map map = this.replicatedData;
        synchronized (map) {
            this.replicatedData = this.copyReplicatedData(state.getReplicatedData());
        }
        this.nodeIDAddressMap = new HashMap(state.getNodeIDAddressMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getState() throws Exception {
        Map copy;
        Map map2;
        ArrayList<MappingInfo> list = new ArrayList<MappingInfo>();
        this.lock.readLock().acquire();
        try {
            for (Map map2 : this.nameMaps.values()) {
                for (Binding binding : map2.values()) {
                    Queue queue = binding.queue;
                    if (!queue.isClustered()) continue;
                    String filterString = queue.getFilter() == null ? null : queue.getFilter().getFilterString();
                    MappingInfo mapping = binding.allNodes ? new MappingInfo(queue.getNodeID(), queue.getName(), binding.condition.toText(), filterString, queue.getChannelID(), queue.isRecoverable(), true, true, queue.getFullSize(), queue.getPageSize(), queue.getDownCacheSize(), queue.getMaxSize(), queue.getRecoverDeliveriesTimeout()) : new MappingInfo(queue.getNodeID(), queue.getName(), binding.condition.toText(), filterString, queue.getChannelID(), queue.isRecoverable(), true, false);
                    list.add(mapping);
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
        map2 = this.replicatedData;
        synchronized (map2) {
            copy = this.copyReplicatedData(this.replicatedData);
        }
        SharedState state = new SharedState(list, copy, (Map)new ConcurrentHashMap(this.nodeIDAddressMap));
        return StreamUtils.toBytes(state);
    }

    public void nodeJoined(Address address) throws Exception {
        log.debug((Object)(this + ": " + address + " joined"));
    }

    public void nodesLeft(List addresses) throws Throwable {
        if (this.trace) {
            log.trace((Object)("Nodes left " + addresses.size()));
        }
        HashMap oldFailoverMap = new HashMap(this.failoverMap);
        int oldFailoverNodeID = this.failoverNodeID;
        if (this.trace) {
            log.trace((Object)("Old failover node id: " + oldFailoverNodeID));
        }
        this.calculateFailoverMap();
        if (this.trace) {
            log.trace((Object)("First node is now " + this.firstNode));
        }
        if (this.firstNode && this.useJGroupsWorkaround) {
            this.replicateSemaphore.disable();
        }
        for (Address address : addresses) {
            log.debug((Object)(this + ": " + address + " left"));
            Integer leftNodeID = this.getNodeIDForSyncAddress(address);
            if (leftNodeID == null) {
                throw new IllegalStateException(this + " cannot find node ID for address " + address);
            }
            boolean crashed = !this.leaveMessageReceived(leftNodeID);
            log.debug((Object)(this + ": node " + leftNodeID + " has " + (crashed ? "crashed" : "cleanly left the group")));
            Integer fnodeID = (Integer)oldFailoverMap.get(leftNodeID);
            log.debug((Object)(this + " the failover node for the crashed node is " + fnodeID));
            boolean doneFailover = false;
            ClusterNotification notification = new ClusterNotification(5, leftNodeID, null);
            this.clusterNotifier.sendNotification(notification);
            if (crashed && this.isSupportsFailover()) {
                if (fnodeID == null) {
                    throw new IllegalStateException("Cannot find failover node for node " + leftNodeID);
                }
                if (fnodeID == this.thisNodeID) {
                    log.debug((Object)(this + ": I am the failover node for node " + leftNodeID + " that crashed"));
                    this.performFailover(leftNodeID);
                    doneFailover = true;
                }
            }
            if (!doneFailover) {
                this.cleanDataForNode(leftNodeID);
            }
            if (this.trace) {
                log.trace((Object)("First node: " + this.firstNode + " oldFailoverNodeID: " + oldFailoverNodeID + " failoverNodeID: " + this.failoverNodeID));
            }
            if (oldFailoverNodeID == this.failoverNodeID) continue;
            this.failoverNodeChanged(oldFailoverNodeID, this.firstNode, false);
        }
        this.sendJMXNotification(VIEW_CHANGED_NOTIFICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBindingFromCluster(MappingInfo mapping, boolean allNodes) throws Exception {
        log.debug((Object)(this + " adding binding from node " + mapping.getNodeId() + ", queue " + mapping.getQueueName() + " with condition " + mapping.getConditionText() + " all nodes " + allNodes));
        if (!this.knowAboutNodeId(mapping.getNodeId())) {
            throw new IllegalStateException("Don't know about node id: " + mapping.getNodeId());
        }
        Filter filter = null;
        if (mapping.getFilterString() != null) {
            filter = this.filterFactory.createFilter(mapping.getFilterString());
        }
        MessagingQueue queue = new MessagingQueue(mapping.getNodeId(), mapping.getQueueName(), mapping.getChannelId(), mapping.isRecoverable(), filter, mapping.isClustered());
        Condition condition = this.conditionFactory.createCondition(mapping.getConditionText());
        this.addBindingInMemory(new Binding(condition, queue, false));
        if (allNodes) {
            if (this.trace) {
                log.trace((Object)"allNodes is true, so also forcing a local bind");
            }
            long channelID = this.channelIDManager.getID();
            MessagingQueue queue2 = new MessagingQueue(this.thisNodeID, mapping.getQueueName(), channelID, this.ms, this.pm, mapping.isRecoverable(), mapping.getMaxSize(), filter, mapping.getFullSize(), mapping.getPageSize(), mapping.getDownCacheSize(), true, mapping.getRecoverDeliveriesTimeout());
            boolean added = this.internalAddBinding(new Binding(condition, queue2, true), false, false);
            if (added) {
                if (this.trace) {
                    log.trace((Object)(this + " inserted in binding locally"));
                }
                queue2.load();
                queue2.activate();
            }
        }
        Object object = this.waitForBindUnbindLock;
        synchronized (object) {
            if (this.trace) {
                log.trace((Object)(this + " notifying bind unbind lock"));
            }
            this.waitForBindUnbindLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindingFromCluster(MappingInfo mapping, boolean allNodes) throws Throwable {
        log.debug((Object)(this + " removing binding from node " + mapping.getNodeId() + ", queue " + mapping.getQueueName() + " with condition " + mapping.getConditionText()));
        if (!this.knowAboutNodeId(mapping.getNodeId())) {
            throw new IllegalStateException("Don't know about node id: " + mapping.getNodeId());
        }
        this.removeBindingInMemory(mapping.getNodeId(), mapping.getQueueName());
        Object object = this.waitForBindUnbindLock;
        synchronized (object) {
            if (this.trace) {
                log.trace((Object)(this + " notifying bind unbind lock"));
            }
            this.waitForBindUnbindLock.notifyAll();
        }
        if (allNodes) {
            if (this.trace) {
                log.trace((Object)"allNodes is true, so also forcing a local unbind");
            }
            this.internalRemoveBinding(mapping.getQueueName(), false, false);
        }
    }

    public void handleNodeLeft(int nodeId) throws Exception {
        this.leftSet.add(new Integer(nodeId));
    }

    public void handleNodeJoined(int nodeId, PostOfficeAddressInfo info) throws Exception {
        this.nodeIDAddressMap.put(new Integer(nodeId), info);
        log.debug((Object)(this + " handleNodeJoined: " + nodeId + " size: " + this.nodeIDAddressMap.size()));
        final int oldFailoverNodeID = this.failoverNodeID;
        boolean wasFirstNode = this.firstNode;
        this.calculateFailoverMap();
        if (wasFirstNode && this.useJGroupsWorkaround) {
            this.replicateSemaphore.enable();
        }
        if (!wasFirstNode && oldFailoverNodeID != this.failoverNodeID) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        MessagingPostOffice.this.failoverNodeChanged(oldFailoverNodeID, MessagingPostOffice.this.firstNode, true);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to process failover node changed", (Throwable)e);
                    }
                }
            }).start();
        }
        ClusterNotification notification = new ClusterNotification(4, nodeId, null);
        this.clusterNotifier.sendNotification(notification);
        this.sendJMXNotification(VIEW_CHANGED_NOTIFICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putReplicantLocally(int originatorNodeID, Serializable key, Serializable replicant) throws Exception {
        LinkedHashMap<Integer, Serializable> m = null;
        Map map = this.replicatedData;
        synchronized (map) {
            log.debug((Object)(this + " puts replicant locally: " + key + "->" + replicant));
            m = (LinkedHashMap<Integer, Serializable>)this.replicatedData.get(key);
            if (m == null) {
                m = new LinkedHashMap<Integer, Serializable>();
                this.replicatedData.put(key, m);
            }
            m.put(new Integer(originatorNodeID), replicant);
            if (this.trace) {
                log.trace((Object)(this + " putReplicantLocally completed"));
            }
        }
        ClusterNotification notification = new ClusterNotification(6, originatorNodeID, key);
        this.clusterNotifier.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReplicantLocally(int originatorNodeID, Serializable key) throws Exception {
        Map m = null;
        Map map = this.replicatedData;
        synchronized (map) {
            if (this.trace) {
                log.trace((Object)(this + " removes " + originatorNodeID + "'s replicant locally for key " + key));
            }
            if ((m = (Map)this.replicatedData.get(key)) == null) {
                return false;
            }
            Object obj = m.remove(new Integer(originatorNodeID));
            if (obj == null) {
                return false;
            }
            if (m.isEmpty()) {
                this.replicatedData.remove(key);
            }
        }
        ClusterNotification notification = new ClusterNotification(7, originatorNodeID, key);
        this.clusterNotifier.sendNotification(notification);
        return true;
    }

    public void routeFromCluster(Message message, String routingKeyText, Set queueNames) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " routing from cluster " + message + ", routing key " + routingKeyText + ", queue names " + queueNames));
        }
        Condition routingKey = this.conditionFactory.createCondition(routingKeyText);
        MessageReference ref = message.createReference();
        this.routeInternal(ref, routingKey, null, true, queueNames);
    }

    public void handleReplicateDelivery(int nodeID, String queueName, String sessionID, long messageID, long deliveryID, final Address replyAddress) throws Exception {
        Binding binding;
        if (this.trace) {
            log.trace((Object)(this + " handleReplicateDelivery for queue " + queueName + " session " + sessionID + " message " + messageID));
        }
        if ((binding = this.getBindingForQueueName(queueName)) != null) {
            Queue queue = binding.queue;
            queue.addToRecoveryArea(nodeID, messageID, sessionID);
        }
        if (this.trace) {
            log.trace((Object)(this + " reply address is " + replyAddress));
        }
        if (replyAddress != null) {
            if (this.trace) {
                log.trace((Object)"Sending back response");
            }
            final ReplicateDeliveryAckMessage request = new ReplicateDeliveryAckMessage(sessionID, deliveryID);
            this.replyExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        MessagingPostOffice.this.groupMember.unicastData(request, replyAddress);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to cast message", (Throwable)e);
                    }
                }
            });
        }
    }

    public void handleGetReplicatedDeliveries(String queueName, Address returnAddress) throws Exception {
        Binding binding;
        if (this.trace) {
            log.trace((Object)(this + " handleGetReplicateDelivery for queue " + queueName));
        }
        if ((binding = this.getBindingForQueueName(queueName)) == null) {
            if (this.trace) {
                log.trace((Object)"Binding has not been deployed");
            }
        } else {
            this.replyExecutor.execute((Runnable)new SendReplicatedDeliveriesRunnable(queueName, returnAddress));
        }
    }

    public void handleReplicateAck(int nodeID, String queueName, long messageID) throws Exception {
        Binding binding = this.getBindingForQueueName(queueName);
        if (binding == null) {
            return;
        }
        Queue queue = binding.queue;
        queue.removeFromRecoveryArea(nodeID, messageID);
    }

    public void handleReplicateDeliveryAck(String sessionID, final long deliveryID) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " handleReplicateDeliveryAck " + sessionID + " " + deliveryID));
        }
        final ServerSessionEndpoint session = this.serverPeer.getSession(sessionID);
        if (this.useJGroupsWorkaround) {
            this.replicateSemaphore.release();
        }
        if (session == null) {
            log.warn((Object)("Cannot find session " + sessionID));
            return;
        }
        this.replicateResponseExecutor.execute(new Runnable(){

            public void run() {
                try {
                    session.replicateDeliveryResponseReceived(deliveryID);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to process response", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAckAllReplicatedDeliveries(int nodeID) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " handleAckAllDeliveries " + nodeID));
        }
        this.lock.readLock().acquire();
        try {
            if (this.localNameMap != null) {
                for (Binding binding : this.localNameMap.values()) {
                    binding.queue.removeAllFromRecoveryArea(nodeID);
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddAllReplicatedDeliveries(int nodeID, Map deliveries) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " handleAddAllReplicatedDeliveries " + nodeID));
        }
        this.lock.readLock().acquire();
        try {
            if (this.localNameMap == null) {
                throw new IllegalStateException("Cannot add all replicated deliveries since there are no bindings - probably the queues aren't deployed");
            }
            if (this.localNameMap != null) {
                for (Map.Entry entry : deliveries.entrySet()) {
                    String queueName = (String)entry.getKey();
                    Map ids = (Map)entry.getValue();
                    Binding binding = (Binding)this.localNameMap.get(queueName);
                    if (binding == null) {
                        throw new IllegalStateException("Cannot find binding with name " + queueName + " maybe it hasn't been deployed");
                    }
                    binding.queue.addAllToRecoveryArea(nodeID, ids);
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
    }

    public void put(Serializable key, Serializable replicant) throws Exception {
        this.putReplicantLocally(this.thisNodeID, key, replicant);
        PutReplicantRequest request = new PutReplicantRequest(this.thisNodeID, key, replicant);
        this.groupMember.multicastControl(request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(Serializable key) throws Exception {
        Map map = this.replicatedData;
        synchronized (map) {
            Map m = (Map)this.replicatedData.get(key);
            return m == null ? Collections.EMPTY_MAP : new HashMap(m);
        }
    }

    public boolean remove(Serializable key) throws Exception {
        if (this.removeReplicantLocally(this.thisNodeID, key)) {
            RemoveReplicantRequest request = new RemoveReplicantRequest(this.thisNodeID, key);
            this.groupMember.multicastControl(request, true);
            return true;
        }
        return false;
    }

    protected Map getDefaultDMLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("INSERT_BINDING", "INSERT INTO JBM_POSTOFFICE (POSTOFFICE_NAME, NODE_ID, QUEUE_NAME, CONDITION, SELECTOR, CHANNEL_ID, CLUSTERED, ALL_NODES) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        map.put("DELETE_BINDING", "DELETE FROM JBM_POSTOFFICE WHERE POSTOFFICE_NAME=? AND NODE_ID=? AND QUEUE_NAME=?");
        map.put("LOAD_BINDINGS", "SELECT QUEUE_NAME, CONDITION, SELECTOR, CHANNEL_ID, CLUSTERED, ALL_NODES FROM JBM_POSTOFFICE WHERE POSTOFFICE_NAME=? AND NODE_ID=?");
        return map;
    }

    protected Map getDefaultDDLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CREATE_POSTOFFICE_TABLE", "CREATE TABLE JBM_POSTOFFICE (POSTOFFICE_NAME VARCHAR(255), NODE_ID INTEGER,QUEUE_NAME VARCHAR(255), CONDITION VARCHAR(1023), SELECTOR VARCHAR(1023), CHANNEL_ID BIGINT, CLUSTERED CHAR(1), ALL_NODES CHAR(1), PRIMARY KEY(POSTOFFICE_NAME, NODE_ID, QUEUE_NAME))");
        return map;
    }

    public boolean isSupportsFailover() {
        return this.supportsFailover;
    }

    public String printBindingInformation() {
        return "";
    }

    private void init() {
        this.mappings = new HashMap();
        this.nameMaps = new HashMap();
        this.channelIDMap = new HashMap();
        this.nodeIDAddressMap = new ConcurrentHashMap();
        if (this.clustered) {
            this.replicatedData = new HashMap();
            this.failoverMap = new ConcurrentHashMap();
            this.leftSet = new ConcurrentHashSet();
        }
        this.replyExecutor = new QueuedExecutor((Channel)new LinkedQueue());
        this.replicateResponseExecutor = new QueuedExecutor((Channel)new LinkedQueue());
    }

    private void deInit() {
        this.mappings = null;
        this.nameMaps = null;
        this.channelIDMap = null;
        this.nodeIDAddressMap = null;
        if (this.clustered) {
            this.replicatedData = null;
            this.failoverMap = null;
            this.leftSet = null;
        }
        this.replyExecutor.shutdownNow();
        this.replicateResponseExecutor.shutdownNow();
    }

    private void requestDeliveries(Queue queue) throws Exception {
        Binding b;
        Map nameMap;
        Integer masterNodeID;
        if (!this.firstNode && this.supportsFailover && this.clustered && queue.isClustered() && (masterNodeID = this.getMasterForFailoverNodeID(this.thisNodeID)) != null && (nameMap = (Map)this.nameMaps.get(masterNodeID)) != null && (b = (Binding)nameMap.get(queue.getName())) != null) {
            if (this.trace) {
                log.trace((Object)"Telling master to send us deliveries");
            }
            MessagingPostOffice.dumpFailoverMap(this.failoverMap);
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(new Integer(this.thisNodeID));
            Address replyAddress = info.getDataChannelAddress();
            GetReplicatedDeliveriesRequest request = new GetReplicatedDeliveriesRequest(queue.getName(), replyAddress);
            info = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(masterNodeID);
            Address address = info.getDataChannelAddress();
            if (address != null) {
                this.groupMember.unicastData(request, address);
            }
        }
    }

    private Integer getMasterForFailoverNodeID(long failoverNodeID) {
        Iterator iter = this.failoverMap.entrySet().iterator();
        Integer nodeID = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer fnodeID = (Integer)entry.getValue();
            nodeID = (Integer)entry.getKey();
            if ((long)fnodeID.intValue() != failoverNodeID) continue;
            break;
        }
        return nodeID;
    }

    private Address getFailoverNodeDataChannelAddress() {
        PostOfficeAddressInfo info = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(new Integer(this.failoverNodeID));
        if (info == null) {
            return null;
        }
        Address address = info.getDataChannelAddress();
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBindUnbind(String queueName, boolean bind) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " waiting for " + (bind ? "bind" : "unbind") + " of " + queueName + " on all nodes"));
        }
        HashSet nodesToWaitFor = new HashSet(this.nodeIDAddressMap.keySet());
        long timeToWait = this.groupMember.getCastTimeout();
        long start = System.currentTimeMillis();
        boolean boundAll = true;
        boolean unboundAll = true;
        Object object = this.waitForBindUnbindLock;
        synchronized (object) {
            do {
                boundAll = true;
                unboundAll = true;
                this.lock.readLock().acquire();
                try {
                    Iterator iter = nodesToWaitFor.iterator();
                    while (iter.hasNext()) {
                        Integer node = (Integer)iter.next();
                        if (!this.nodeIDAddressMap.containsKey(node)) {
                            iter.remove();
                            continue;
                        }
                        Map nameMap = (Map)this.nameMaps.get(node);
                        if (nameMap != null && nameMap.get(queueName) != null) {
                            if (this.trace) {
                                log.trace((Object)(this + " queue " + queueName + " exists on node " + node));
                            }
                            unboundAll = false;
                            continue;
                        }
                        if (this.trace) {
                            log.trace((Object)(this + " queue " + queueName + " does not exist on node " + node));
                        }
                        boundAll = false;
                    }
                }
                finally {
                    this.lock.readLock().release();
                }
                if ((!bind || boundAll) && (bind || unboundAll)) continue;
                try {
                    if (this.trace) {
                        log.trace((Object)(this + " waiting for bind unbind lock, timeout=" + this.groupMember.getCastTimeout()));
                    }
                    this.waitForBindUnbindLock.wait(this.groupMember.getCastTimeout());
                    if (this.trace) {
                        log.trace((Object)(this + " woke up"));
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeToWait -= System.currentTimeMillis() - start;
            } while ((bind && !boundAll || !bind && !unboundAll) && timeToWait > 0L);
            if (this.trace) {
                log.trace((Object)(this + " waited ok"));
            }
        }
        if (bind && !boundAll || !bind && !unboundAll) {
            throw new IllegalStateException(this + " timed out waiting for " + (bind ? " bind " : " unbind ") + "ALL to occur");
        }
    }

    private boolean internalAddBinding(Binding binding, boolean allNodes, boolean sync) throws Exception {
        if (this.trace) {
            log.trace((Object)(this.thisNodeID + " binding " + binding.queue + " with condition " + binding.condition + " all nodes " + allNodes));
        }
        if (binding == null) {
            throw new IllegalArgumentException("Binding is null");
        }
        Condition condition = binding.condition;
        Queue queue = binding.queue;
        if (queue == null) {
            throw new IllegalArgumentException("Queue is null");
        }
        if (queue.getNodeID() != this.thisNodeID) {
            throw new IllegalArgumentException("Cannot bind a queue from another node");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        boolean added = this.addBindingInMemory(binding);
        if (added) {
            if (queue.isRecoverable()) {
                this.insertBindingInStorage(condition, queue, binding.allNodes);
            }
            if (this.clustered && queue.isClustered()) {
                String filterString = queue.getFilter() == null ? null : queue.getFilter().getFilterString();
                MappingInfo info = new MappingInfo(this.thisNodeID, queue.getName(), condition.toText(), filterString, queue.getChannelID(), queue.isRecoverable(), true, binding.allNodes, queue.getFullSize(), queue.getPageSize(), queue.getDownCacheSize(), queue.getMaxSize(), queue.getRecoverDeliveriesTimeout());
                BindRequest request = new BindRequest(info, allNodes);
                this.groupMember.multicastControl(request, sync);
            }
        }
        return added;
    }

    private Binding internalRemoveBinding(String queueName, boolean allNodes, boolean sync) throws Throwable {
        if (this.trace) {
            log.trace((Object)(this.thisNodeID + " unbind queue: " + queueName + " all nodes " + allNodes));
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name is null");
        }
        Binding removed = this.removeBindingInMemory(this.thisNodeID, queueName);
        if (removed != null) {
            Queue queue = removed.queue;
            Condition condition = removed.condition;
            if (queue.isRecoverable()) {
                this.deleteBindingFromStorage(queue);
            }
            if (this.clustered && queue.isClustered()) {
                String filterString = queue.getFilter() == null ? null : queue.getFilter().getFilterString();
                MappingInfo info = new MappingInfo(this.thisNodeID, queue.getName(), condition.toText(), filterString, queue.getChannelID(), queue.isRecoverable(), true, allNodes);
                UnbindRequest request = new UnbindRequest(info, allNodes);
                this.groupMember.multicastControl(request, sync);
            }
            queue.removeAllReferences();
        }
        return removed;
    }

    private synchronized void calculateFailoverMap() {
        this.failoverMap.clear();
        View view = this.groupMember.getCurrentView();
        Vector members = view.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            Address failoverAddress;
            Integer fnodeID;
            Address address = (Address)members.get(i);
            Integer theNodeID = this.findNodeIDForAddress(address);
            if (theNodeID == null) continue;
            int fi = i;
            do {
                if (++fi != members.size()) continue;
                fi = 0;
            } while ((fnodeID = this.findNodeIDForAddress(failoverAddress = (Address)members.get(fi))) == null);
            this.failoverMap.put(theNodeID, fnodeID);
        }
        Integer i = (Integer)this.failoverMap.get(new Integer(this.thisNodeID));
        if (i != null) {
            int fid = i;
            if (fid == this.thisNodeID) {
                this.firstNode = true;
                this.failoverNodeID = -1;
            } else {
                this.failoverNodeID = fid;
                this.firstNode = false;
            }
        }
        log.debug((Object)("Updated failover map:\n" + MessagingPostOffice.dumpFailoverMap(this.failoverMap)));
    }

    private Integer findNodeIDForAddress(Address address) {
        Integer theNodeID = null;
        for (Map.Entry entry : this.nodeIDAddressMap.entrySet()) {
            Integer nodeID = (Integer)entry.getKey();
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
            if (!info.getControlChannelAddress().equals(address)) continue;
            theNodeID = nodeID;
            break;
        }
        return theNodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getBindings(String queueName) throws Exception {
        this.lock.readLock().acquire();
        try {
            Iterator iter = this.nameMaps.values().iterator();
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            while (iter.hasNext()) {
                Map nameMap = (Map)iter.next();
                if (queueName != null) {
                    Binding binding = (Binding)nameMap.get(queueName);
                    if (binding == null) continue;
                    bindings.add(binding);
                    continue;
                }
                bindings.addAll(nameMap.values());
            }
            ArrayList<Binding> arrayList = bindings;
            return arrayList;
        }
        finally {
            this.lock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean routeInternal(MessageReference ref, Condition condition, Transaction tx, boolean fromCluster, Set names) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " routing " + ref + " with condition '" + condition + "'" + (tx == null ? "" : " transactionally in " + tx) + " from cluster " + fromCluster));
        }
        boolean routed = false;
        this.lock.readLock().acquire();
        try {
            List queues = (List)this.mappings.get(condition);
            if (queues != null) {
                Iterator iter = queues.iterator();
                int localReliableCount = 0;
                HashSet<Integer> remoteSet = null;
                ArrayList<Queue> targets = new ArrayList<Queue>();
                while (iter.hasNext()) {
                    Queue queue = (Queue)iter.next();
                    if (this.trace) {
                        log.trace((Object)(this + " considering queue " + queue));
                    }
                    if (queue.getNodeID() == this.thisNodeID) {
                        Filter filter;
                        if (this.trace) {
                            log.trace((Object)(this + " is a local queue"));
                        }
                        boolean routeLocal = false;
                        if (!fromCluster) {
                            routeLocal = true;
                        } else if (!(queue.isRecoverable() || !queue.isClustered() || names != null && names.contains(queue.getName()))) {
                            routeLocal = true;
                        }
                        if (!routeLocal || (filter = queue.getFilter()) != null && !filter.accept(ref.getMessage())) continue;
                        if (this.trace) {
                            log.trace((Object)(this + " Added queue " + queue + " to list of targets"));
                        }
                        targets.add(queue);
                        if (!ref.getMessage().isReliable() || !queue.isRecoverable()) continue;
                        ++localReliableCount;
                        continue;
                    }
                    if (fromCluster) continue;
                    if (this.trace) {
                        log.trace((Object)(this + " is a remote queue"));
                    }
                    if (!queue.isRecoverable() && queue.isClustered()) {
                        Filter filter = queue.getFilter();
                        if (filter != null && !filter.accept(ref.getMessage())) continue;
                        if (remoteSet == null) {
                            remoteSet = new HashSet<Integer>();
                        }
                        remoteSet.add(new Integer(queue.getNodeID()));
                        if (!this.trace) continue;
                        log.trace((Object)(this + " added it to the remote set for casting"));
                        continue;
                    }
                    if (!this.trace) continue;
                    log.trace((Object)(this + " is recoverable so not casting"));
                }
                boolean startedTx = false;
                if (tx == null && localReliableCount > 1) {
                    if (this.trace) {
                        log.trace((Object)("Starting internal tx, reliableCount = " + localReliableCount));
                    }
                    tx = this.tr.createTransaction();
                    startedTx = true;
                }
                iter = targets.iterator();
                HashSet<String> queueNames = null;
                while (iter.hasNext()) {
                    Queue queue = (Queue)iter.next();
                    if (this.trace) {
                        log.trace((Object)(this + " Routing ref to queue " + queue));
                    }
                    Delivery del = queue.handle(null, ref, tx);
                    if (this.trace) {
                        log.trace((Object)("Queue returned " + del));
                    }
                    if (del == null || !del.isSelectorAccepted()) continue;
                    routed = true;
                    if (remoteSet == null) continue;
                    if (queueNames == null) {
                        queueNames = new HashSet<String>();
                    }
                    queueNames.add(queue.getName());
                }
                if (remoteSet != null) {
                    MessageRequest request = new MessageRequest(condition.toText(), ref.getMessage(), queueNames);
                    if (this.trace) {
                        log.trace((Object)(this + " casting message to other node(s)"));
                    }
                    Integer nodeID = null;
                    if (remoteSet.size() == 1) {
                        nodeID = (Integer)remoteSet.iterator().next();
                    }
                    CastMessageCallback callback = new CastMessageCallback(nodeID, request);
                    if (tx != null) {
                        tx.addCallback(callback, this);
                    } else {
                        callback.afterCommit(true);
                    }
                    routed = true;
                }
                if (startedTx) {
                    if (this.trace) {
                        log.trace((Object)(this + " committing " + tx));
                    }
                    tx.commit();
                    if (this.trace) {
                        log.trace((Object)(this + " committed " + tx));
                    }
                }
            }
        }
        finally {
            this.lock.readLock().release();
        }
        return routed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binding removeBindingInMemory(int nodeID, String queueName) throws Exception {
        this.lock.writeLock().acquire();
        Binding binding = null;
        try {
            Integer nid = new Integer(nodeID);
            Map nameMap = (Map)this.nameMaps.get(nid);
            if (nameMap == null) {
                Binding binding2 = null;
                return binding2;
            }
            binding = (Binding)nameMap.remove(queueName);
            if (binding == null) {
                Binding binding3 = null;
                return binding3;
            }
            if (nameMap.isEmpty()) {
                this.nameMaps.remove(nid);
                if (nodeID == this.thisNodeID) {
                    this.localNameMap = null;
                }
            }
            if ((binding = (Binding)this.channelIDMap.remove(new Long(binding.queue.getChannelID()))) == null) {
                throw new IllegalStateException("Cannot find binding in channel id map for queue " + queueName);
            }
            List queues = (List)this.mappings.get(binding.condition);
            if (queues == null) {
                throw new IllegalStateException("Cannot find queues in condition map for condition " + binding.condition);
            }
            boolean removed = queues.remove(binding.queue);
            if (!removed) {
                throw new IllegalStateException("Cannot find queue in list for queue " + queueName);
            }
            if (queues.isEmpty()) {
                this.mappings.remove(binding.condition);
            }
        }
        finally {
            this.lock.writeLock().release();
        }
        ClusterNotification notification = new ClusterNotification(1, nodeID, queueName);
        this.clusterNotifier.sendNotification(notification);
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addBindingInMemory(Binding binding) throws Exception {
        Queue queue = binding.queue;
        if (this.trace) {
            log.trace((Object)(this + " Adding binding in memory " + binding));
        }
        this.lock.writeLock().acquire();
        try {
            Integer nid = new Integer(queue.getNodeID());
            HashMap<String, Binding> nameMap = (HashMap<String, Binding>)this.nameMaps.get(nid);
            if (nameMap != null && nameMap.containsKey(queue.getName())) {
                boolean bl = false;
                return bl;
            }
            Long cid = new Long(queue.getChannelID());
            if (this.channelIDMap.containsKey(cid)) {
                throw new IllegalStateException("Channel id map for node " + nid + " already contains binding for queue " + cid);
            }
            if (nameMap == null) {
                nameMap = new HashMap<String, Binding>();
                this.nameMaps.put(nid, nameMap);
                if (queue.getNodeID() == this.thisNodeID) {
                    this.localNameMap = nameMap;
                }
            }
            nameMap.put(queue.getName(), binding);
            this.channelIDMap.put(cid, binding);
            Condition condition = binding.condition;
            ArrayList<Queue> queues = (ArrayList<Queue>)this.mappings.get(condition);
            if (queues == null) {
                queues = new ArrayList<Queue>();
                if (queues.contains(queue)) {
                    throw new IllegalArgumentException("Queue is already bound with condition " + condition);
                }
                this.mappings.put(condition, queues);
            }
            queues.add(queue);
        }
        finally {
            this.lock.writeLock().release();
        }
        if (this.trace) {
            log.trace((Object)(this + " Sending cluster notification"));
        }
        ClusterNotification notification = new ClusterNotification(0, queue.getNodeID(), queue.getName());
        this.clusterNotifier.sendNotification(notification);
        return true;
    }

    private void multicastRequest(ClusterRequest request) throws Exception {
        if (this.trace) {
            log.trace((Object)(this + " Unicasting request " + request));
        }
        this.groupMember.multicastData(request);
    }

    private void unicastRequest(ClusterRequest request, int nodeId) throws Exception {
        Address address = this.getAddressForNodeId(nodeId, false);
        if (address == null) {
            throw new IllegalArgumentException("Cannot find address for node " + nodeId);
        }
        if (this.trace) {
            log.trace((Object)(this + "Unicasting request " + request + " to node " + nodeId));
        }
        this.groupMember.unicastData(request, address);
    }

    private Map getBindingsFromStorage() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LoadBindings
        extends JDBCSupport.JDBCTxRunner<Map> {
            LoadBindings() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map doTransaction() throws Exception {
                HashMap<String, Binding> hashMap;
                PreparedStatement ps = null;
                ResultSet rs = null;
                HashMap<String, Binding> bindings = new HashMap<String, Binding>();
                try {
                    ps = this.conn.prepareStatement(MessagingPostOffice.this.getSQLStatement("LOAD_BINDINGS"));
                    ps.setString(1, MessagingPostOffice.this.officeName);
                    ps.setInt(2, MessagingPostOffice.this.thisNodeID);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String queueName = rs.getString(1);
                        String conditionText = rs.getString(2);
                        String selector = rs.getString(3);
                        if (rs.wasNull()) {
                            selector = null;
                        }
                        long channelID = rs.getLong(4);
                        boolean bindingClustered = rs.getString(5).equals("Y");
                        boolean allNodes = rs.getString(6).equals("Y");
                        Filter filter = null;
                        if (selector != null) {
                            filter = MessagingPostOffice.this.filterFactory.createFilter(selector);
                        }
                        MessagingQueue queue = new MessagingQueue(MessagingPostOffice.this.thisNodeID, queueName, channelID, MessagingPostOffice.this.ms, MessagingPostOffice.this.pm, true, filter, bindingClustered && MessagingPostOffice.this.clustered);
                        if (MessagingPostOffice.this.trace) {
                            log.trace((Object)(this + " loaded binding from storage: " + queueName));
                        }
                        Condition condition = MessagingPostOffice.this.conditionFactory.createCondition(conditionText);
                        Binding binding = new Binding(condition, queue, allNodes);
                        bindings.put(queueName, binding);
                    }
                    hashMap = bindings;
                }
                catch (Throwable throwable) {
                    MessagingPostOffice.this.closeResultSet(rs);
                    MessagingPostOffice.this.closeStatement(ps);
                    throw throwable;
                }
                MessagingPostOffice.this.closeResultSet(rs);
                MessagingPostOffice.this.closeStatement(ps);
                return hashMap;
            }
        }
        return (Map)new LoadBindings().executeWithRetry();
    }

    private void loadBindings() throws Exception {
        Iterator iter = this.loadedBindings.values().iterator();
        log.trace((Object)"Loading bindings");
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            this.addBindingInMemory(binding);
            Queue queue = binding.queue;
            if (this.clustered && queue.isClustered()) {
                String filterString = queue.getFilter() == null ? null : queue.getFilter().getFilterString();
                MappingInfo info = new MappingInfo(this.thisNodeID, queue.getName(), binding.condition.toText(), filterString, queue.getChannelID(), queue.isRecoverable(), true, binding.allNodes, queue.getFullSize(), queue.getPageSize(), queue.getDownCacheSize(), queue.getMaxSize(), queue.getRecoverDeliveriesTimeout());
                BindRequest request = new BindRequest(info, binding.allNodes);
                log.trace((Object)"Multicasting bind all");
                this.groupMember.multicastControl(request, false);
            }
            this.requestDeliveries(queue);
        }
    }

    private void insertBindingInStorage(final Condition condition, final Queue queue, final boolean allNodes) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InsertBindings
        extends JDBCSupport.JDBCTxRunner {
            InsertBindings() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doTransaction() throws Exception {
                PreparedStatement ps = null;
                try {
                    String filterString;
                    ps = this.conn.prepareStatement(MessagingPostOffice.this.getSQLStatement("INSERT_BINDING"));
                    ps.setString(1, MessagingPostOffice.this.officeName);
                    ps.setInt(2, MessagingPostOffice.this.thisNodeID);
                    ps.setString(3, queue.getName());
                    ps.setString(4, condition.toText());
                    String string = filterString = queue.getFilter() != null ? queue.getFilter().getFilterString() : null;
                    if (filterString != null) {
                        ps.setString(5, filterString);
                    } else {
                        ps.setNull(5, 12);
                    }
                    ps.setLong(6, queue.getChannelID());
                    if (queue.isClustered()) {
                        ps.setString(7, "Y");
                    } else {
                        ps.setString(7, "N");
                    }
                    if (allNodes) {
                        ps.setString(8, "Y");
                    } else {
                        ps.setString(8, "N");
                    }
                    ps.executeUpdate();
                }
                catch (Throwable throwable) {
                    MessagingPostOffice.this.closeStatement(ps);
                    throw throwable;
                }
                MessagingPostOffice.this.closeStatement(ps);
                return null;
            }
        }
        new InsertBindings().executeWithRetry();
    }

    private boolean deleteBindingFromStorage(final Queue queue) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeleteBindings
        extends JDBCSupport.JDBCTxRunner<Boolean> {
            DeleteBindings() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doTransaction() throws Exception {
                Boolean bl;
                PreparedStatement ps = null;
                try {
                    ps = this.conn.prepareStatement(MessagingPostOffice.this.getSQLStatement("DELETE_BINDING"));
                    ps.setString(1, MessagingPostOffice.this.officeName);
                    ps.setInt(2, queue.getNodeID());
                    ps.setString(3, queue.getName());
                    int rows = ps.executeUpdate();
                    bl = rows == 1;
                }
                catch (Throwable throwable) {
                    MessagingPostOffice.this.closeStatement(ps);
                    throw throwable;
                }
                MessagingPostOffice.this.closeStatement(ps);
                return bl;
            }
        }
        return (Boolean)new DeleteBindings().executeWithRetry();
    }

    private boolean leaveMessageReceived(Integer nodeId) throws Exception {
        return this.leftSet.remove(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDataForNode(Integer nodeToRemove) throws Exception {
        Object toRemove;
        log.debug((Object)(this + " cleaning data for node " + nodeToRemove));
        this.lock.writeLock().acquire();
        if (this.trace) {
            log.trace((Object)(this + " cleaning data for node " + nodeToRemove));
        }
        try {
            Iterator iter = this.mappings.entrySet().iterator();
            toRemove = new ArrayList();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Condition condition = (Condition)entry.getKey();
                List queues = (List)entry.getValue();
                for (Queue queue : queues) {
                    if (queue.getNodeID() != nodeToRemove.intValue()) continue;
                    toRemove.add(new Binding(condition, queue, false));
                }
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                Binding binding = (Binding)((Object)iter.next());
                this.removeBindingInMemory(nodeToRemove, binding.queue.getName());
            }
        }
        finally {
            this.lock.writeLock().release();
        }
        HashMap<String, Map> toNotify = new HashMap<String, Map>();
        toRemove = this.replicatedData;
        synchronized (toRemove) {
            Iterator i = this.replicatedData.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                Map replicants = (Map)entry.getValue();
                replicants.remove(nodeToRemove);
                if (replicants.isEmpty()) {
                    i.remove();
                }
                toNotify.put(key, replicants);
            }
        }
        this.nodeIDAddressMap.remove(nodeToRemove);
        toRemove = this.waitForBindUnbindLock;
        synchronized (toRemove) {
            if (this.trace) {
                log.trace((Object)(this + " notifying bind unbind lock"));
            }
            this.waitForBindUnbindLock.notifyAll();
        }
        for (Map.Entry entry : toNotify.entrySet()) {
            String key = (String)entry.getKey();
            ClusterNotification notification = new ClusterNotification(7, nodeToRemove, key);
            this.clusterNotifier.sendNotification(notification);
        }
    }

    private Integer getNodeIDForSyncAddress(Address address) throws Exception {
        Iterator iter = this.nodeIDAddressMap.entrySet().iterator();
        Integer nodeID = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            PostOfficeAddressInfo info = (PostOfficeAddressInfo)entry.getValue();
            if (!info.getControlChannelAddress().equals(address)) continue;
            nodeID = (Integer)entry.getKey();
            break;
        }
        return nodeID;
    }

    private boolean knowAboutNodeId(int nodeID) {
        return this.nodeIDAddressMap.get(new Integer(nodeID)) != null;
    }

    private Map copyReplicatedData(Map toCopy) {
        HashMap copy = new HashMap();
        for (Map.Entry entry : toCopy.entrySet()) {
            Serializable key = (Serializable)entry.getKey();
            Map replicants = (Map)entry.getValue();
            LinkedHashMap m = new LinkedHashMap();
            m.putAll(replicants);
            copy.put(key, m);
        }
        return copy;
    }

    private Address getAddressForNodeId(int nodeId, boolean sync) throws Exception {
        PostOfficeAddressInfo info = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(new Integer(nodeId));
        if (info == null) {
            return null;
        }
        if (sync) {
            return info.getControlChannelAddress();
        }
        return info.getDataChannelAddress();
    }

    private void failoverNodeChanged(int oldFailoverNodeID, boolean firstNode, boolean joined) throws Exception {
        PostOfficeAddressInfo info;
        if (this.trace) {
            log.trace((Object)("Failover node has changed from " + oldFailoverNodeID + " to " + this.failoverNodeID));
        }
        if (!firstNode && (info = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(new Integer(oldFailoverNodeID))) != null) {
            if (this.trace) {
                log.trace((Object)"Old failover node still exists, telling it remove replicated deliveries");
            }
            AckAllReplicatedDeliveriesMessage request = new AckAllReplicatedDeliveriesMessage(this.thisNodeID);
            this.groupMember.unicastData(request, info.getDataChannelAddress());
            if (this.trace) {
                log.trace((Object)"Sent AckAllReplicatedDeliveriesMessage");
            }
        }
        if (!joined && this.localNameMap != null) {
            HashMap deliveries = new HashMap();
            if (this.serverPeer != null) {
                Collection sessions = this.serverPeer.getSessions();
                for (ServerSessionEndpoint session : sessions) {
                    session.deliverAnyWaitingDeliveries(null);
                    session.collectDeliveries(deliveries, firstNode, null);
                }
                if (!firstNode) {
                    PostOfficeAddressInfo info2 = (PostOfficeAddressInfo)this.nodeIDAddressMap.get(new Integer(this.failoverNodeID));
                    if (info2 == null) {
                        throw new IllegalStateException("Cannot find address for failover node " + this.failoverNodeID);
                    }
                    AddAllReplicatedDeliveriesMessage request = new AddAllReplicatedDeliveriesMessage(this.thisNodeID, deliveries);
                    this.groupMember.unicastData(request, info2.getDataChannelAddress());
                    if (this.trace) {
                        log.trace((Object)"Sent AddAllReplicatedDeliveriesMessage");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFailover(Integer failedNodeID) throws Exception {
        log.info((Object)("JBoss Messaging is failing over for failed node " + failedNodeID + ". If there are many messages to reload this may take some time..."));
        ClusterNotification notification = new ClusterNotification(2, failedNodeID, null);
        this.clusterNotifier.sendNotification(notification);
        log.debug((Object)(this + " announced it is starting failover procedure"));
        this.pm.mergeTransactions(failedNodeID.intValue(), this.thisNodeID);
        this.lock.writeLock().acquire();
        try {
            Map nameMap = (Map)this.nameMaps.get(failedNodeID);
            ArrayList<Binding> toRemove = new ArrayList<Binding>();
            if (nameMap != null) {
                for (Binding binding : nameMap.values()) {
                    Queue queue = binding.queue;
                    if (!queue.isRecoverable() || queue.getNodeID() != failedNodeID.intValue()) continue;
                    toRemove.add(binding);
                }
            }
            for (Binding binding : toRemove) {
                Binding b;
                Condition condition = binding.condition;
                Queue queue = binding.queue;
                if (!queue.isRecoverable()) {
                    throw new IllegalStateException("Found non recoverable queue " + queue.getName() + " in map, these should have been removed!");
                }
                if (!queue.isClustered()) {
                    throw new IllegalStateException("Queue " + queue.getName() + " is not clustered!");
                }
                this.removeBindingInMemory(binding.queue.getNodeID(), binding.queue.getName());
                Queue localQueue = null;
                if (this.localNameMap != null && (b = (Binding)this.localNameMap.get(queue.getName())) != null) {
                    localQueue = b.queue;
                }
                if (localQueue == null) {
                    throw new IllegalStateException("Cannot failover " + queue.getName() + " since it does not exist on this node. " + "You must deploy your clustered destinations on ALL nodes of the cluster");
                }
                log.debug((Object)(this + " has already a queue: " + queue.getName() + " queue so merging queues"));
                localQueue.mergeIn(queue.getChannelID(), failedNodeID);
                log.debug((Object)"Merged queue");
                this.deleteBindingFromStorage(queue);
                log.debug((Object)(this + " deleted binding for " + queue.getName()));
            }
            log.debug((Object)(this + ": server side fail over is now complete"));
        }
        finally {
            this.lock.writeLock().release();
        }
        this.cleanDataForNode(failedNodeID);
        log.debug((Object)(this + " announcing that failover procedure is complete"));
        notification = new ClusterNotification(3, failedNodeID, null);
        this.clusterNotifier.sendNotification(notification);
        this.sendJMXNotification(FAILOVER_COMPLETED_NOTIFICATION);
        log.info((Object)"JBoss Messaging failover completed");
    }

    private void sendJMXNotification(String notificationType) {
        Notification n = new Notification(notificationType, "", 0L);
        this.nbSupport.sendNotification(n);
        log.debug((Object)(this + " sent " + notificationType + " JMX notification"));
    }

    private class CastMessageCallback
    implements TxCallback {
        private Integer nodeID;
        private ClusterRequest request;

        CastMessageCallback(Integer nodeID, ClusterRequest request) {
            this.nodeID = nodeID;
            this.request = request;
        }

        public void afterCommit(boolean onePhase) throws Exception {
            MessagingPostOffice.this.multicastRequest(this.request);
        }

        public void afterPrepare() throws Exception {
        }

        public void afterRollback(boolean onePhase) throws Exception {
        }

        public void beforeCommit(boolean onePhase) throws Exception {
        }

        public void beforePrepare() throws Exception {
        }

        public void beforeRollback(boolean onePhase) throws Exception {
        }
    }

    private class SendReplicatedDeliveriesRunnable
    implements Runnable {
        private String queueName;
        private Address address;

        SendReplicatedDeliveriesRunnable(String queueName, Address address) {
            this.queueName = queueName;
            this.address = address;
        }

        public void run() {
            try {
                if (MessagingPostOffice.this.serverPeer != null) {
                    Collection sessions = MessagingPostOffice.this.serverPeer.getSessions();
                    Iterator iter = sessions.iterator();
                    HashMap dels = new HashMap();
                    boolean gotSome = false;
                    while (iter.hasNext()) {
                        ServerSessionEndpoint session = (ServerSessionEndpoint)iter.next();
                        session.deliverAnyWaitingDeliveries(this.queueName);
                        if (!session.collectDeliveries(dels, MessagingPostOffice.this.firstNode, this.queueName)) continue;
                        gotSome = true;
                    }
                    if (gotSome) {
                        AddAllReplicatedDeliveriesMessage req = new AddAllReplicatedDeliveriesMessage(MessagingPostOffice.this.thisNodeID, dels);
                        MessagingPostOffice.this.groupMember.unicastData(req, this.address);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to collect and send request", (Throwable)e);
            }
        }
    }
}

