/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.bean;

import java.io.Serializable;

/**
 * 障害検知情報クラス
 *
 */
public class TroubleDetectionInfo implements Serializable {
	private static final long serialVersionUID = -349600027568486078L;
	
	public static final String JBOSS_SERVER1 = "";
	public static final String JBOSS_SERVER2 = "";
	public static final String LDAP_PROVIDER = "";
	public static final String LDAP_CONSUMER = "";
	public static final String FOREST1 = "";
	public static final String FOREST2 = "";
	public static final String SYSLOG_FORWARD1 = "";
	public static final String SYSLOG_FORWARD2 = "";
	public static final int INTERVAL = 1;
	public static final int RETRY_MAIL = 5;
	public static final int RETRY_EVENT = 5;
	public static final int RETRY_STATUS = 5;
	
	/** JBoss アクティブサーバ */
	protected String jbossServer1 = null;
	/** JBoss スタンバイサーバ */
	protected String jbossServer2 = null;
	
	/** OpenLDAP プロバイダサーバ */
	protected String ldapProvider = null;
	/** OpenLDAP コンシューマサーバ */
	protected String ldapConsumer = null;

	/** PostgresForest サーバ1 */
	protected String forest1 = null;
	/** PostgresForest サーバ2 */
	protected String forest2 = null;
	
	/** SyslogForward プロセス1 */
	protected String syslogForward1 = null;
	/** SyslogForward プロセス2 */
	protected String syslogForward2 = null;
	
	/** 監視間隔 */
	protected Integer interval = null;

	/** メール送信リトライ回数 */
	protected Integer retryMail = null;
	/** イベント出力リトライ回数 */
	protected Integer retryEvent = null;
	/** ステータス出力リトライ回数 */
	protected Integer retryStatus = null;
	
	public TroubleDetectionInfo() {
		setInterval(new Integer(INTERVAL));
		setRetryMail(new Integer(RETRY_MAIL));
		setRetryEvent(new Integer(RETRY_EVENT));
		setRetryStatus(new Integer(RETRY_STATUS));
		setJbossServer1(JBOSS_SERVER1);
		setJbossServer2(JBOSS_SERVER2);
		setLdapProvider(LDAP_PROVIDER);
		setLdapConsumer(LDAP_CONSUMER);
		setForest1(FOREST1);
		setForest2(FOREST2);
		setSyslogForward1(SYSLOG_FORWARD1);
		setSyslogForward2(SYSLOG_FORWARD2);
	}
	
	/**
	 * @return
	 */
	public String getForest1() {
		return forest1;
	}

	/**
	 * @param forest1
	 */
	public void setForest1(String forest1) {
		this.forest1 = forest1;
	}

	/**
	 * @return
	 */
	public String getForest2() {
		return forest2;
	}

	/**
	 * @param forest2
	 */
	public void setForest2(String forest2) {
		this.forest2 = forest2;
	}

	/**
	 * @return
	 */
	public Integer getInterval() {
		return interval;
	}

	/**
	 * @param interval
	 */
	public void setInterval(Integer interval) {
		this.interval = interval;
	}

	/**
	 * @return
	 */
	public String getJbossServer1() {
		return jbossServer1;
	}

	/**
	 * @param jbossServer1
	 */
	public void setJbossServer1(String jbossServer1) {
		this.jbossServer1 = jbossServer1;
	}

	/**
	 * @return
	 */
	public String getJbossServer2() {
		return jbossServer2;
	}

	/**
	 * @param jbossServer2
	 */
	public void setJbossServer2(String jbossServer2) {
		this.jbossServer2 = jbossServer2;
	}

	/**
	 * @return
	 */
	public String getLdapConsumer() {
		return ldapConsumer;
	}

	/**
	 * @param ldapConsumer
	 */
	public void setLdapConsumer(String ldapConsumer) {
		this.ldapConsumer = ldapConsumer;
	}

	/**
	 * @return
	 */
	public String getLdapProvider() {
		return ldapProvider;
	}

	/**
	 * @param ldapProvider
	 */
	public void setLdapProvider(String ldapProvider) {
		this.ldapProvider = ldapProvider;
	}

	/**
	 * @return
	 */
	public String getSyslogForward1() {
		return syslogForward1;
	}

	/**
	 * @param syslogForward1
	 */
	public void setSyslogForward1(String syslogForward1) {
		this.syslogForward1 = syslogForward1;
	}

	/**
	 * @return
	 */
	public String getSyslogForward2() {
		return syslogForward2;
	}

	/**
	 * @param syslogForward2
	 */
	public void setSyslogForward2(String syslogForward2) {
		this.syslogForward2 = syslogForward2;
	}

	public Integer getRetryEvent() {
		return retryEvent;
	}

	/**
	 * @param retryEvent
	 */
	public void setRetryEvent(Integer retryEvent) {
		this.retryEvent = retryEvent;
	}

	/**
	 * @return
	 */
	public Integer getRetryStatus() {
		return retryStatus;
	}

	/**
	 * @param retryStatus
	 */
	public void setRetryStatus(Integer retryStatus) {
		this.retryStatus = retryStatus;
	}

	/**
	 * @return
	 */
	public Integer getRetryMail() {
		return retryMail;
	}

	/**
	 * @param retryMail
	 */
	public void setRetryMail(Integer retryMail) {
		this.retryMail = retryMail;
	}
}
