/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.ejb.entity;

import javax.ejb.EntityBean;

/**
 * SNMP監視の設定情報を管理するEntity Bean <BR>
 * @ejb.bean name="MonitorSnmpInfo"
 *           jndi-name="MonitorSnmpInfo"
 *           type="CMP"
 *           schema="MonitorSnmpInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_snmp_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorSnmpInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.snmp.ejb.entity.MonitorSnmpInfoPK"
 *   
 */
public abstract class MonitorSnmpInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorSnmpInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			String communityName, 
			String snmpOid,
			Integer convertFlg,
			Integer snmpPort,
			String snmpVersion
			) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setCommunityName(communityName);
		this.setSnmpOid(snmpOid);
		this.setConvertFlg(convertFlg);
		this.setSnmpPort(snmpPort);
		this.setSnmpVersion(snmpVersion);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="community_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the communityName.
	 */
	public abstract String getCommunityName();

	/**
	 * @ejb.interface-method
	 * 
	 * @param communityName The communityName to set.
	 */
	public abstract void setCommunityName(String communityName);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="convert_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the convertFlg.
	 */
	public abstract Integer getConvertFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param convertFlg The convertFlg to set.
	 */
	public abstract void setConvertFlg(Integer convertFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_oid"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the snmpOid.
	 */
	public abstract String getSnmpOid();

	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpOid The snmpOid to set.
	 */
	public abstract void setSnmpOid(String snmpOid);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the snmpPort.
	 */
	public abstract Integer getSnmpPort();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpPort The snmpPort to set.
	 */
	public abstract void setSnmpPort(Integer snmpPort);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="snmp_version"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the snmpVersion.
	 */
	public abstract String getSnmpVersion();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param snmpVersion The snmpVersion to set.
	 */
	public abstract void setSnmpVersion(String snmpVersion);
	
	
}
