/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.factory.SelectMonitorNumericValueType;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK;

/**
 * ping監視判定情報を検索するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SelectMonitorPing extends SelectMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorPing.class );

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public MonitorCheckInfo getCheckInfo() throws FinderException, NamingException{
		
		// ping監視情報を取得
		MonitorPingInfoPK pk = new MonitorPingInfoPK(m_monitorId, m_monitorTypeId);
		MonitorPingInfoLocal pingLocal = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		MonitorPingInfo ping = new MonitorPingInfo();
		ping.setMonitorTypeId(m_monitorTypeId);
		ping.setMonitorId(m_monitorId);
		ping.setRunCount(pingLocal.getRunCount());
		ping.setRunInterval(pingLocal.getRunInterval());
		ping.setTimeout(pingLocal.getTimeout());
		
		return (MonitorCheckInfo)ping;
	}
}
