/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performanceMGR.monitor.factory;

import java.rmi.RemoteException;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.performanceMGR.bean.CollectorType;
import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 性能値収集登録クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifySchedule {
	
	protected static Log m_log = LogFactory.getLog( ModifySchedule.class );
	
	/**
	 * 性能値収集に登録
	 * 
	 * @param parentFacilityId ファシリティID
	 * @param interval 収集間隔(秒)
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean addSchedule(
			String monitorId, 
			String collectorId, 
			String parentFacilityId, 
			int interval, 
			List colletorItemList,
			int valid) {
		// 性能情報の収集を設定します。
		try {
			RecordCollectorData data = new RecordCollectorData();
			data.setCollectorID(collectorId);
			data.setCollectorType(CollectorType.MONITOR);
			data.setLabel(monitorId);  // 監視IDを説明項目に入力
			data.setFacilityID(parentFacilityId);
			data.setInterval(interval);
			data.setPeriod(-1);  // 収集期間は無期限を指定
			
			// スコープツリーを取得
			Repository repository = new Repository();
			FacilityTreeItem facilityTree = repository.getFacilityTree(parentFacilityId);
			data.setFacilityTree(facilityTree);
			
			// 対象スコープが存在しない場合はエラー
			if(facilityTree == null){
				// エラー処理
				return false;				
			}

	        // 有効の場合のみ収集スケジュールを登録
			if(valid == ValidConstant.TYPE_VALID){
				// RealtimeCollector Entity Bean を生成
	        	CollectorHome home = JNDIConnectionManager.getCollectorHome();
	        	Collector myBean = home.create(data, colletorItemList);

				// 収集の開始を指示
				myBean.startCollect();
		    }
			
			return true;
		}catch(CreateException e){
			AplLogger apllog = new AplLogger("PERF", "performance");
			apllog.put("SYS", "001");
			m_log.debug("addSchedule():" + e.getMessage());
		}catch(NamingException e){
			AplLogger apllog = new AplLogger("PERF", "performance");
			apllog.put("SYS", "001");
			m_log.debug("addSchedule():" + e.getMessage());
		} catch (RemoteException e) {
			AplLogger apllog = new AplLogger("PERF", "performance");
			apllog.put("SYS", "001");
			m_log.debug("addSchedule():" + e.getMessage());
		}
		return false;
	}
}
