/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.EJBException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.performanceMGR.bean.DeviceData;


/**
 *デバイス情報のDBアクセスを行うクラス
 * 
 * @version 2.0.0
 * @since 1.0
 */
public class DeviceDAO {
	//ログ出力
	protected static Log m_log = LogFactory.getLog( DeviceDAO.class );
	
	/**
	 * コンストラクター
	 */
	public DeviceDAO(){
	}
	
	/**
	 * 収集ID とファシリティIDとSNMPのOIDでデバイスの個数を検索する。
	 * @param collectorId　収集ID
	 * @param facilityId　ファシリティID
	 * @param Oid　SNMPのOID
	 * @return デバイスの個数
	 * @throws SQLException
	 */
	public int numberDevicePieces(String collectorId ,String facilityId, String Oid)
	throws EJBException{
		
		
		m_log.debug("selectCountDevice() start :"
				+ collectorId + " " + facilityId + " " + Oid);
		
//		SQL文発行準備
		Connection conn = null;
		PreparedStatement stmt = null;
		// 結果セット
		ResultSet res = null;
		//戻り値
		int ret=0;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//		SQL文の作成
			String sql = "SELECT COUNT (*) AS INDEX FROM DEVICE WHERE COLLECTORID=? AND FACILITYID = ? AND OBJECTID LIKE ?";
			
			// SQL文発行準備
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, collectorId);
			stmt.setString(2, facilityId);
			stmt.setString(3, Oid);
			res = stmt.executeQuery();
			
			if(res.next()) {
				
				ret = res.getInt("INDEX");
				
			}
		} catch (SQLException e) {
			m_log.error("selectDevice() error :" + collectorId + " " + facilityId + " " + Oid + " SQLException" );
			
			throw new EJBException(e.getMessage());
		}  finally{
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(res != null){
					res.close();
				}
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectDevice() error :" + collectorId + " " + facilityId + " " + Oid + " SQLException" );
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("selectDevice() end :" + collectorId + " " + facilityId + " " + Oid);
		return ret;
	}

	
	/**
	 * デバイス情報をインサートする
	 * @param itemCode 収集ID
	 * @param dData　デバイス情報
	 * @throws SQLException
	 */
	public void insertDeviceData(String collcetorID, DeviceData dData)
	throws EJBException,CreateException{
		
		m_log.debug("insertDeviceData() start :"
				+ collcetorID + " " + dData.getFacilityId() + " " + dData.getOid());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			String sql = "INSERT INTO DEVICE " +
			"(collectorID, " +
			"facilityID," +
			"objectID," +
			"index," +
			"device_name," +
			"device_type)" +
			"values (?,?,?,?,?,?);";
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, collcetorID);
			stmt.setString(2, dData.getFacilityId());
			stmt.setString(3, dData.getOid());
			stmt.setInt(4,dData.getDeviceIndex());
			stmt.setString(5,dData.getDeviceName());
			stmt.setString(6,dData.getDeviceType());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("insertDeviceData() error :" + dData.toString() + " SQLException" + msg);
				throw new CreateException(msg);
			}
		} catch (SQLException e) {
			m_log.error("insertDeviceData() error :" + dData.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("insertDeviceData() error :" + dData.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("insertDeviceData() start :"
				+ collcetorID + " " + dData.getFacilityId() + " " + dData.getOid());
	}
	
	/**
	 * 収集IDに対応するデバイス情報を一括検索する
	 * 
	 * 収集の設定時のデバイス情報を一括で取得する
	 * @param collectorID
	 * @return　デバイス情報のコレクション
	 * @throws SQLException
	 */
	public Collection selectDeviceByCollectorID(String collectorID)
	throws EJBException{
		m_log.debug("selectDeviceByCollectorID() start :"
				+ collectorID);
		
		ArrayList ret = new ArrayList();
		Connection conn = null;
		PreparedStatement stmt = null;
//		結果セット
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//		SQL文の作成
			String sql = "SELECT * FROM DEVICE WHERE COLLECTORID=?";
			// SQL文発行準備
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, collectorID);
			res = stmt.executeQuery();
			
			while(res.next()) {
				
				DeviceData dData =new  DeviceData();
				dData.setFacilityId(res.getString("FACILITYID"));
				dData.setOid(res.getString("OBJECTID"));
				dData.setDeviceIndex(res.getInt("INDEX"));
				dData.setDeviceName(res.getString("DEVICE_NAME"));
				dData.setDeviceType(res.getString("DEVICE_TYPE"));
				
				ret.add(dData);
			} 
			
		} catch (SQLException e) {
			m_log.error("selectDeviceByCollectorID() error :" + collectorID + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(res != null){
					res.close();
				}
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("selectDeviceByCollectorID() error :" + collectorID + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}	
		m_log.debug("selectDeviceByCollectorID() end :"
				+ collectorID);
		
		return ret;
		
	}
	
	/**
	 * 収集IDに対応するデバイス情報を一括削除する
	 * 
	 * 収集の設定時のデバイス情報を一括で削除する
	 * @param collectorID　収集ID
	 * @throws SQLException
	 */
	public void deleteDeviceDataByCollectorID(String collectorID)
	throws EJBException{
		
		m_log.debug("deleteDeviceDataByCollectorID() start :"
				+ collectorID);
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			//conn.setAutoCommit(false);
			//SQL文の定義
			String sql = "DELETE FROM DEVICE WHERE COLLECTORID = ? ";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,collectorID );
			stmt.executeUpdate();
			
		} catch (SQLException e) {
			m_log.error("deleteDeviceDataByCollectorID() error :" + collectorID + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			
			//コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if(stmt != null){
					stmt.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("deleteDeviceDataByCollectorID() error :" + collectorID + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}	
		
		m_log.debug("deleteDeviceDataByCollectorID() end :"
				+ collectorID);
		
	}
}
