/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.message;

/**
 * ログ出力ジョブ実行情報を保持するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class LogOutputJobRunInfo implements java.io.Serializable{

	private static final long serialVersionUID = 5384985347639870499L;
	
	private int m_jobRun;				// ジョブ実行（する／しない）
	private String m_jobId;			// ジョブID
	private int m_jobInhibitionFlg;	// 通知抑制連動（する／しない）
	private int m_jobFailurePriority;	// ジョブ呼び出し失敗時重要度
	
	/**
	 * ジョブ呼出失敗時重要度を返します。
	 * 
	 * @return ジョブ呼出失敗時重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getJobFailurePriority() {
		return m_jobFailurePriority;
	}
	/**
	 * ジョブ呼出失敗時重要度を設定します。
	 * 
	 * @param jobFailurePriority ジョブ呼出失敗時重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setJobFailurePriority(int jobFailurePriority) {
		this.m_jobFailurePriority = jobFailurePriority;
	}
	/**
	 * ジョブIDを返します。
	 * 
	 * @return ジョブID
	 */
	public String getJobId() {
		return m_jobId;
	}
	/**
	 * ジョブIDを設定します。
	 * 
	 * @param jobId ジョブID
	 */
	public void setJobId(String jobId) {
		this.m_jobId = jobId;
	}
	/**
	 * 通知抑制と連動（する／しない）を返します。
	 * 
	 * @return 通知抑制と連動（する／しない）
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getJobInhibitionFlg() {
		return m_jobInhibitionFlg;
	}
	/**
	 * 通知抑制と連動（する／しない）を設定します。
	 * 
	 * @param jobInhibitionFlg 通知抑制と連動（する／しない）
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setJobInhibitionFlg(int jobInhibitionFlg) {
		this.m_jobInhibitionFlg = jobInhibitionFlg;
	}
	/**
	 * ジョブ実行（する／しない）を返します。
	 * 
	 * @return ジョブ実行（する／しない）
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getJobRun() {
		return m_jobRun;
	}
	/**
	 * ジョブ実行（する／しない）を設定します。
	 * 
	 * @param jobRun ジョブ実行（する／しない）
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setJobRun(int jobRun) {
		this.m_jobRun = jobRun;
	}
}
