/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * メンテナンス機能プロパティ取得クラス
 * 
 * conf/maintenance.propertiesに記述されたプロパティを読むためのクラスです。
 * 
 * シングルトンパターンで実装されています。
 *
 * @version 2.4.2 
 * @since 2.4.2
 * @author Kazutoshi KOZAKAI
 */
public class MaintenanceProperties {
    protected static Log m_log = LogFactory.getLog( MaintenanceProperties.class );

	private static final String DELETE_BUF_SIZE_PATH="delete.buf.size";
	
	private static MaintenanceProperties instance = null;

	private static int deleteBufSize = 100;
	
	/**
	 * コンストラクタ
	 * 
	 * @version 2.4.2
	 * @since 2.4.2
	 */
	private MaintenanceProperties() {
		this.setValue();
	}
	
	public static MaintenanceProperties getInstance() {
		if (instance == null) {
			instance = new MaintenanceProperties();
		}
		
		return instance;
	}
	

	private void setValue() {
		
	    Properties properties = new Properties();
		
		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "maintenance.properties";
			
			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(new FileInputStream(propertyFile));
			
			String deleteBufSizeString = properties.getProperty(DELETE_BUF_SIZE_PATH, new Integer(deleteBufSize).toString());
			try {
				deleteBufSize = Integer.parseInt(deleteBufSizeString);
			} catch (NumberFormatException e) {
				m_log.warn("setValue() delete.buf.size parse failed :" + e.getMessage());
			}

		} catch (FileNotFoundException e) {
			m_log.warn("setValue() maintenance.properties not found : " + e.getMessage());
		} catch (IOException e) {
			m_log.error("setValue(): " + e.getMessage());
		}
	}

	public int getDeleteBufSize() {
		return deleteBufSize;
	}

}
