/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.dialog;

import java.util.ArrayList;
import java.util.StringTokenizer;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.AddNotify;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.notify.mail.composite.MailTemplateIdListComposite;
import com.clustercontrol.util.Messages;

/**
 * 通知作成・変更ダイアログクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class NotifyCreateDialog extends CommonDialog {
	
	/** カラム数（重要度）。 */
	public static final int WIDTH_PRIORITY 		= 1;
	
	/** カラム数（チェックボックス）。 */
	public static final int WIDTH_CHECK 			= 1;
	
	/** カラム数（コンボボックス）。 */
	public static final int WIDTH_COMBO 			= 2;
	
	/** カラム数（メールアドレス）。 */
	public static final int WIDTH_MAIL_ADDRESS 	= 7;
	
	
	/** 入力値を保持するオブジェクト。 */
	private NotifyInfo inputData = null;
	
	/** 入力値の正当性を保持するオブジェクト。 */
	private ValidateResult validateResult = null;
	
	/** 参照フラグ。 */
	private boolean referenceFlg = false;
	
	/** 変更対象の通知ID。 */
	private String notifyId = null;
	
	/** 通知ID テキストボックス。 */
	private Text textNotifyId = null;
	
	/** 説明 テキストボックス。 */
	private Text textDescription = null;
	
	/** 
	 * ステータス通知 チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkStatus = null;
	
	/** 
	 * ステータス通知 ステータス情報の存続期間 コンボボックス。
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	private Combo comboStatusValidPeriod = null;
	
	/**
	 * ステータス通知 存続期間経過後の処理（情報を削除する） ラジオボタン。 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	private Button radioStatusDelete = null;
	
	/**
	 * ステータス通知 存続期間経過後の処理（更新されていない旨のメッセージに置換える） ラジオボタン。
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	private Button radioStatusUpdate = null;
	
	/** 
	 * ステータス通知 更新時の重要度 コンボボックス。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	private Combo comboStatusPriority = null;
	
	/**
	 * イベント通知 チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEvent = null;
	
	/**
	 * イベント通知 通知（重要度：通知） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */ 
	private Button checkEventNormalInfo = null;
	/**
	 * イベント通知 通知（重要度：警告） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEventNormalWarning = null;
	/**
	 * イベント通知 通知（重要度：危険） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEventNormalCritical = null;
	/**
	 * イベント通知 通知（重要度：不明） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEventNormalUnknown = null;
	
	/**
	 * イベント通知 通知状態（重要度：通知） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventNormalInfo = null;
	/**
	 * イベント通知 通知状態（重要度：警告） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventNormalWarning = null;
	/**
	 * イベント通知 通知状態（重要度：危険） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventNormalCritical = null;
	/**
	 * イベント通知 通知状態（重要度：不明） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventNormalUnknown = null;
	
	/**
	 * イベント通知 抑制（重要度：通知） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */ 
	private Button checkEventInhibitionInfo = null;
	/**
	 * イベント通知 抑制（重要度：警告） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEventInhibitionWarning = null;
	/**
	 * イベント通知 抑制（重要度：危険） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEventInhibitionCritical = null;
	/**
	 * イベント通知 抑制（重要度：不明） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkEventInhibitionUnknown = null;
	
	/**
	 * イベント通知 抑制状態（重要度：通知） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventInhibitionInfo = null;
	/**
	 * イベント通知 抑制状態（重要度：警告） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventInhibitionWarning = null;
	/**
	 * イベント通知 抑制状態（重要度：危険） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventInhibitionCritical = null;
	/**
	 * イベント通知 抑制状態（重要度：不明） コンボボックス。
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */ 
	private Combo comboEventInhibitionUnknown = null;
	
	/**
	 * イベント通知 メール（重要度：通知） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */ 
	private Button checkMailInfo = null;
	/**
	 * イベント通知 メール（重要度：通知） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkMailWarning = null;
	/**
	 * イベント通知 メール（重要度：通知） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkMailCritical = null;
	/**
	 * イベント通知 メール（重要度：通知） チェックボックス。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Button checkMailUnknown = null;
	
	/** イベント通知 メールアドレス（重要度：通知） テキストボックス。 */ 
	private Text textMailInfo = null;
	/** イベント通知 メールアドレス（重要度：警告） テキストボックス。 */
	private Text textMailWarning = null;
	/** イベント通知 メールアドレス（重要度：危険） テキストボックス。 */
	private Text textMailCritical = null;
	/** イベント通知 メールアドレス（重要度：不明） テキストボックス。 */
	private Text textMailUnknown = null;
	
	/** 
	 * 抑制間隔（抑制しない） ラジオボタン。
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	private Button radioNoInhibition = null;
	/** 
	 * 抑制間隔（期間で抑制する） ラジオボタン。
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	private Button radioInhibitionPeriod = null;
	/** 
	 * 抑制間隔（回数で抑制する） ラジオボタン。
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	private Button radioInhibitionFrequency = null;
	/** 
	 * 抑制間隔（重要度で抑制する） ラジオボタン。
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	private Button radioInhibitionPriority = null;
	
	/** 抑制期間 テキストボックス。 */
	private Text textInhibitionPeriod = null;
	/** 抑制回数 テキストボックス。 */
	private Text textInhibitionFrequency = null;
	
	/** メールテンプレートID情報コンポジット */
	MailTemplateIdListComposite compositeMailTemplateIdList = null;
	
	/**
	 * 作成用ダイアログのインスタンスを返します。
	 * 
	 * @param parent 親のシェルオブジェクト
	 */
	public NotifyCreateDialog(Shell parent) {
		super(parent);
	}
	
	/**
	 * 変更用ダイアログのインスタンスを返します。
	 * 
	 * @param parent 親のシェルオブジェクト
	 * @param notifyId 変更する通知情報の通知ID
	 * @param referenceFlg 参照フラグ（参照のみで変更不可の場合、<code> true </code>）
	 */
	public NotifyCreateDialog(Shell parent, String notifyId, boolean referenceFlg) {
		super(parent);
		
		this.notifyId = notifyId;
		this.referenceFlg = referenceFlg;
	}
	
	/**
	 * ダイアログエリアを生成します。
	 * 
	 * @param parent 親のコンポジット
	 * 
	 * @see com.clustercontrol.notify.action.GetNotify#getNotify(String)
	 * @see #setInputData(NotifyInfo)
	 */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages.getString("dialog.notify.create.modify"));

        // 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        /*
         * 通知ID
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.id") + " : ");
        // テキスト
        this.textNotifyId = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textNotifyId.setLayoutData(gridData);
        if(this.notifyId != null && !"".equals(this.notifyId.trim())){
        	this.textNotifyId.setEnabled(false);
        }
        this.textNotifyId.addVerifyListener(
				new StringVerifyListener(DataRangeConstant.VARCHAR_64));
        
        // 空白
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * 説明
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("description") + " : ");
        // テキスト
        this.textDescription = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData(gridData);
        this.textDescription.addVerifyListener(
				new StringVerifyListener(DataRangeConstant.VARCHAR_256));
        // 空白
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * ステータス通知
         */
        this.checkStatus = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.checkStatus.setLayoutData(gridData);
        this.checkStatus.setText(Messages.getString("notifies.status") + " : ");
        this.checkStatus.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                setEnabledForStatus(checkStatus.getSelection());
            }
        });
        
        /*
         * 大グループ
         */
        // ステータス通知グループ
        Group groupStatus1 = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupStatus1.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupStatus1.setLayoutData(gridData);

        /*
         * ステータス情報の有効期間（分）
         */
        // ラベル
        label = new Label(groupStatus1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.status.valid.period") + " : ");
        // コンボボックス
        this.comboStatusValidPeriod = new Combo(groupStatus1, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboStatusValidPeriod.setLayoutData(gridData);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_UNLIMITED);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_10);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_20);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_MIN_30);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_1);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_3);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_6);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_HOUR_12);
        this.comboStatusValidPeriod.add(StatusValidPeriodConstant.STRING_DAY_1);
        
        // 空白
        label = new Label(groupStatus1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ラベル
        label = new Label(groupStatus1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.status.invalid.period.treatment") + " : ");
        
        /*
         * 中グループ
         */
        // ステータス情報有効期間経過後の扱い通知グループ
        Group groupStatus2 = new Group(groupStatus1, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupStatus2.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupStatus2.setLayoutData(gridData);
        
        // 情報を削除する
        this.radioStatusDelete = new Button(groupStatus2, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioStatusDelete.setLayoutData(gridData);
        this.radioStatusDelete.setText(Messages.getString("notify.status.invalid.period.delete"));

        // 更新されていない旨のメッセージに置換える。
        this.radioStatusUpdate = new Button(groupStatus2, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioStatusUpdate.setLayoutData(gridData);
        this.radioStatusUpdate.setText(Messages.getString("notify.status.invalid.period.updatet"));
        this.radioStatusUpdate.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	comboStatusPriority.setEnabled(radioStatusUpdate.getSelection());
            }
        });
        
        /*
         * ステータス情報 重要度
         */
        // ラベル
        label = new Label(groupStatus2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("priority") + " : ");
        // コンボボックス
        this.comboStatusPriority = new Combo(groupStatus2, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboStatusPriority.setLayoutData(gridData);
        this.comboStatusPriority.add(PriorityConstant.STRING_CRITICAL);
        this.comboStatusPriority.add(PriorityConstant.STRING_WARNING);
        this.comboStatusPriority.add(PriorityConstant.STRING_INFO);
        this.comboStatusPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.comboStatusPriority.setText(PriorityConstant.STRING_WARNING);
        // 空白
        label = new Label(groupStatus2, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * イベント通知
         */
        this.checkEvent = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.checkEvent.setLayoutData(gridData);
        this.checkEvent.setText(Messages.getString("notifies.event") + " : ");
        this.checkEvent.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	setEnabledForEvent(checkEvent.getSelection());
            }
        });
        
        /*
         * 大グループ
         */
        // イベント通知グループ
        Group groupEvent1 = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent1.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent1.setLayoutData(gridData);
        
//      不要な記述と判断したため、コメントアウトした 2008/02/20:uchiyama
//        /*
//         * 中グループ
//         */
//        // イベント通知
//        Group groupEvent2 = new Group(groupEvent1, SWT.NONE);
//        layout = new GridLayout(1, true);
//        layout.marginWidth = 5;
//        layout.marginHeight = 5;
//        layout.numColumns = 15;
//        groupEvent2.setLayout(layout);
//        gridData = new GridData();
//        gridData.horizontalSpan = 15;
//        gridData.horizontalAlignment = GridData.FILL;
//        gridData.grabExcessHorizontalSpace = true;
//        groupEvent2.setLayoutData(gridData);
        
        // ラベル（重要度）
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_PRIORITY;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ラベル（通知する）
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.treatment.normal"));

        // ラベル（通知状態）
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.state.normal"));

        // ラベル（抑制する）
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.treatment.inhibition"));

        // ラベル（抑制時の状態）
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.state.inhibition"));
        
        // ラベル（送信する）
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.treatment.mail"));
        
        // ラベル（送信先（セミコロン区切り））
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_MAIL_ADDRESS;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("email.address.ssv") + " : ");
        
        // イベント通知 重要度：通知
        label = this.getLabelPriority(groupEvent1, Messages.getString("info"),PriorityColorConstant.COLOR_INFO);
        this.checkEventNormalInfo = this.getCheckEventNormal(groupEvent1);
        this.comboEventNormalInfo = this.getComboEventNormal(groupEvent1);
        this.checkEventInhibitionInfo = this.getCheckEventInhibition(groupEvent1);
        this.comboEventInhibitionInfo = this.getComboEventInhibition(groupEvent1);
        this.checkMailInfo = this.getCheckMail(groupEvent1);
        this.textMailInfo = this.getTextMail(groupEvent1);
        
        this.checkEventNormalInfo.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalInfo.getSelection(), comboEventNormalInfo, checkEventInhibitionInfo, comboEventInhibitionInfo, checkMailInfo, textMailInfo);
        	}
        });
		this.comboEventNormalInfo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalInfo.getText())){
					comboEventInhibitionInfo.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionInfo.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionInfo.setEnabled(checkEventInhibitionInfo.getSelection());
	        	setEnabledForEventInhibition();
	        }
	    });
      	this.comboEventInhibitionInfo.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionInfo.getText())){
      				comboEventNormalInfo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailInfo.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailInfo.setEnabled(checkMailInfo.getSelection());
      			setEnabledForMailTemplateId();
      		}
      	});

        // イベント通知 重要度：警告
        label = this.getLabelPriority(groupEvent1, Messages.getString("warning"),PriorityColorConstant.COLOR_WARNING);
        this.checkEventNormalWarning = this.getCheckEventNormal(groupEvent1);
        this.comboEventNormalWarning = this.getComboEventNormal(groupEvent1);
        this.checkEventInhibitionWarning = this.getCheckEventInhibition(groupEvent1);
        this.comboEventInhibitionWarning = this.getComboEventInhibition(groupEvent1);
        this.checkMailWarning = this.getCheckMail(groupEvent1);
        this.textMailWarning = this.getTextMail(groupEvent1);
        
        this.checkEventNormalWarning.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalWarning.getSelection(), comboEventNormalWarning, checkEventInhibitionWarning, comboEventInhibitionWarning, checkMailWarning, textMailWarning);
        	}
        });
		this.comboEventNormalWarning.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalWarning.getText())){
					comboEventInhibitionWarning.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionWarning.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionWarning.setEnabled(checkEventInhibitionWarning.getSelection());
	        	setEnabledForEventInhibition();
	        }
	    });
      	this.comboEventInhibitionWarning.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionWarning.getText())){
      				comboEventNormalWarning.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailWarning.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailWarning.setEnabled(checkMailWarning.getSelection());
      			setEnabledForMailTemplateId();
      		}
      	});
        
        // イベント通知 重要度：危険
        label = this.getLabelPriority(groupEvent1, Messages.getString("critical"),PriorityColorConstant.COLOR_CRITICAL);
        this.checkEventNormalCritical = this.getCheckEventNormal(groupEvent1);
        this.comboEventNormalCritical = this.getComboEventNormal(groupEvent1);
        this.checkEventInhibitionCritical = this.getCheckEventInhibition(groupEvent1);
        this.comboEventInhibitionCritical = this.getComboEventInhibition(groupEvent1);
        this.checkMailCritical = this.getCheckMail(groupEvent1);
        this.textMailCritical = this.getTextMail(groupEvent1);
        
        this.checkEventNormalCritical.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalCritical.getSelection(), comboEventNormalCritical, checkEventInhibitionCritical, comboEventInhibitionCritical, checkMailCritical, textMailCritical);
        	}
        });
		this.comboEventNormalCritical.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalCritical.getText())){
					comboEventInhibitionCritical.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionCritical.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionCritical.setEnabled(checkEventInhibitionCritical.getSelection());
	        	setEnabledForEventInhibition();
	        }
	    });
      	this.comboEventInhibitionCritical.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionCritical.getText())){
      				comboEventNormalCritical.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailCritical.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailCritical.setEnabled(checkMailCritical.getSelection());
      			setEnabledForMailTemplateId();
      		}
      	});

        // イベント通知 重要度：不明
        label = this.getLabelPriority(groupEvent1, Messages.getString("unknown"),PriorityColorConstant.COLOR_UNKNOWN);
        this.checkEventNormalUnknown = this.getCheckEventNormal(groupEvent1);
        this.comboEventNormalUnknown = this.getComboEventNormal(groupEvent1);
        this.checkEventInhibitionUnknown = this.getCheckEventInhibition(groupEvent1);
        this.comboEventInhibitionUnknown = this.getComboEventInhibition(groupEvent1);
        this.checkMailUnknown = this.getCheckMail(groupEvent1);
        this.textMailUnknown = this.getTextMail(groupEvent1);
        
        this.checkEventNormalUnknown.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent e) {
        		setEnabledForEvent(checkEventNormalUnknown.getSelection(), comboEventNormalUnknown, checkEventInhibitionUnknown, comboEventInhibitionUnknown, checkMailUnknown, textMailUnknown);
        	}
        });
		this.comboEventNormalUnknown.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventNormalUnknown.getText())){
					comboEventInhibitionUnknown.setText(EventConfirmConstant.STRING_DESTRUCTION);
				}
			}
		});
      	this.checkEventInhibitionUnknown.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent e) {
	        	comboEventInhibitionUnknown.setEnabled(checkEventInhibitionUnknown.getSelection());
	        	setEnabledForEventInhibition();
	        }
	    });
      	this.comboEventInhibitionUnknown.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			if(EventConfirmConstant.STRING_CONFIRMED.equals(comboEventInhibitionUnknown.getText())){
      				comboEventNormalUnknown.setText(EventConfirmConstant.STRING_UNCONFIRMED);
      			}
      		}
      	});
      	this.checkMailUnknown.addSelectionListener(new SelectionAdapter() {
      		public void widgetSelected(SelectionEvent e) {
      			textMailUnknown.setEnabled(checkMailUnknown.getSelection());
      			setEnabledForMailTemplateId();
      		}
      	});
        
      	// メールテンプレートID
      	this.compositeMailTemplateIdList = new MailTemplateIdListComposite(groupEvent1, SWT.NONE, true);
      	gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.END;
		gridData.grabExcessHorizontalSpace = true;
		compositeMailTemplateIdList.setLayoutData(gridData);
      	
		
        // ラベル
        label = new Label(groupEvent1, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.event.inhibition") + " : ");
        
        /*
         * 中グループ
         */
        // イベント重複時の通知回数の抑制グループ
        Group groupEvent3 = new Group(groupEvent1, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent3.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent3.setLayoutData(gridData);
        
// 不要な記述と判断したため、コメントアウトした 2008/02/20:uchiyama
//        // ラベル
//        label = new Label(groupEvent3, SWT.NONE);
//        gridData = new GridData();
//        gridData.horizontalSpan = 15;
//        gridData.horizontalAlignment = GridData.FILL;
//        gridData.grabExcessHorizontalSpace = true;
//        label.setLayoutData(gridData);
//        label.setText(Messages.getString("notify.event.inhibition.timing") + " : ");   
//        /*
//         * 小グループ
//         */
//        // 抑制のタイミンググループ
//        Group groupEvent4 = new Group(groupEvent3, SWT.NONE);
//        layout = new GridLayout(1, true);
//        layout.marginWidth = 5;
//        layout.marginHeight = 5;
//        layout.numColumns = 15;
//        groupEvent4.setLayout(layout);
//        gridData = new GridData();
//        gridData.horizontalSpan = 15;
//        gridData.horizontalAlignment = GridData.FILL;
//        gridData.grabExcessHorizontalSpace = true;
//        groupEvent4.setLayoutData(gridData);
        
        /*
         * 小グループ
         */
        // ラジオボタン（抑制しない）
        this.radioNoInhibition = new Button(groupEvent3, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioNoInhibition.setLayoutData(gridData);
        this.radioNoInhibition.setText(Messages.getString("suppress.no"));

        // ラジオボタン（期間で抑制する）
        this.radioInhibitionPeriod = new Button(groupEvent3, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionPeriod.setLayoutData(gridData);
        this.radioInhibitionPeriod.setText(Messages.getString("suppress.by.time.interval") + " : ");
        this.radioInhibitionPeriod.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent e) {
              textInhibitionPeriod.setEnabled(radioInhibitionPeriod.getSelection());
              textInhibitionFrequency.setEnabled(radioInhibitionFrequency.getSelection());
          }
        });

        // テキストボックス（期間で抑制する）
        this.textInhibitionPeriod = new Text(groupEvent3, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textInhibitionPeriod.addVerifyListener(
        		new PositiveNumberVerifyListener(1, DataRangeConstant.SMALLINT_HIGH));
        this.textInhibitionPeriod.setLayoutData(gridData);
        
        // 空白
        label = new Label(groupEvent3, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        
        // ラジオボタン（回数で抑制する）
        this.radioInhibitionFrequency = new Button(groupEvent3, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionFrequency.setLayoutData(gridData);
        this.radioInhibitionFrequency.setText(Messages.getString("suppress.by.counter") + " : ");
        this.radioInhibitionFrequency.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent e) {
        	  textInhibitionPeriod.setEnabled(radioInhibitionPeriod.getSelection());
        	  textInhibitionFrequency.setEnabled(radioInhibitionFrequency.getSelection());
          }
        });

        // テキストボックス（回数で抑制する）
        this.textInhibitionFrequency = new Text(groupEvent3, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textInhibitionFrequency.addVerifyListener(
        		new PositiveNumberVerifyListener(1, DataRangeConstant.SMALLINT_HIGH));
        this.textInhibitionFrequency.setLayoutData(gridData);
        
        // 空白
        label = new Label(groupEvent3, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        
        // ラジオボタン（重要度で抑制する）
        this.radioInhibitionPriority = new Button(groupEvent3, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.radioInhibitionPriority.setLayoutData(gridData);
        this.radioInhibitionPriority.setText(Messages.getString("suppress.by.priority") + " : ");
        this.radioInhibitionPriority.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent e) {
        	  textInhibitionPeriod.setEnabled(radioInhibitionPeriod.getSelection());
        	  textInhibitionFrequency.setEnabled(radioInhibitionFrequency.getSelection());
          }
        });

        // 空白
        label = new Label(groupEvent3, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 11;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData(gridData);

        // サイズを最適化
        // グリッドレイアウトを用いた場合、こうしないと横幅が画面いっぱいになります。
        shell.pack();
        shell.setSize(new Point(780, shell.getSize().y));

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // 通知IDが指定されている場合、その情報を初期表示する。
        NotifyInfo info = null; 
        if(this.notifyId != null){
        	info = new GetNotify().getNotify(this.notifyId);        	
        }
        else{
        	info = new NotifyInfo();
        }
        this.setInputData(info);
        
    }

	/**
	 * 入力値を保持した通知情報を返します。
	 * 
	 * @return 通知情報
	 */
    public NotifyInfo getInputData() {
        return this.inputData;
    }

	/**
	 * 引数で指定された通知情報の値を、各項目に設定します。
	 * 
	 * @param notify 設定値として用いる通知情報
	 * 
	 * @see #setInputDataForEvent(NotifyEventInfo, Button, Combo, Button, Combo, Button, Text)
	 * @see #setEnabled(boolean)
	 * @see #setEnabledForStatus(boolean)
	 * @see #setEnabledForEvent(boolean)
	 */
    protected void setInputData(NotifyInfo notify) {

        this.inputData = notify;

        // 各項目に反映
        if (notify.getNotifyId() != null) {
            this.textNotifyId.setText(notify.getNotifyId());
        }
        if (notify.getDescription() != null) {
            this.textDescription.setText(notify.getDescription());
        }
        
        // ステータス通知
        if (notify.getStatusFlg().intValue() == ValidConstant.TYPE_VALID) {
            this.checkStatus.setSelection(true);
        } else {
            this.checkStatus.setSelection(false);
        }      
        if (notify.getStatusValidPeriod() != null) {
            this.comboStatusValidPeriod.setText(StatusValidPeriodConstant.typeToString(notify.getStatusValidPeriod().intValue()));
        }
        if (notify.getStatusInvalidFlg() != null && notify.getStatusInvalidFlg().intValue() == StatusExpirationConstant.TYPE_DELETE) {
            this.radioStatusDelete.setSelection(true);
        } else {
            this.radioStatusUpdate.setSelection(true);
        }
        this.comboStatusPriority.setText(PriorityConstant.typeToString(notify.getStatusUpdatePriority().intValue()));
        
        // イベント通知
        if (notify.getEventFlg() != null && notify.getEventFlg().intValue() == ValidConstant.TYPE_VALID) {
            this.checkEvent.setSelection(true);
        } else {
            this.checkEvent.setSelection(false);
        }
        
        ArrayList list = notify.getNotifyEventInfo();
        if(list != null){
            for(int index=0; index<list.size(); index++){
            	NotifyEventInfo event = (NotifyEventInfo)list.get(index);
            	if(event != null){
                	if(PriorityConstant.TYPE_INFO ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalInfo, 	this.comboEventNormalInfo, 		this.checkEventInhibitionInfo, 		this.comboEventInhibitionInfo, 		this.checkMailInfo, 	this.textMailInfo);
                	}
                	else if(PriorityConstant.TYPE_WARNING ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalWarning, 	this.comboEventNormalWarning, 	this.checkEventInhibitionWarning, 	this.comboEventInhibitionWarning, 	this.checkMailWarning, 	this.textMailWarning);
                	}
                	else if(PriorityConstant.TYPE_CRITICAL ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalCritical, this.comboEventNormalCritical, 	this.checkEventInhibitionCritical, 	this.comboEventInhibitionCritical, 	this.checkMailCritical,	this.textMailCritical);
                	}
                	else if(PriorityConstant.TYPE_UNKNOWN ==  event.getPriority()){
                        this.setInputDataForEvent(event, this.checkEventNormalUnknown, 	this.comboEventNormalUnknown, 	this.checkEventInhibitionUnknown, 	this.comboEventInhibitionUnknown, 	this.checkMailUnknown, 	this.textMailUnknown);
                	}
            	}
            }
        }
        
        // メールテンプレートID
        if (notify.getMailTemplateId() != null) {
        	this.compositeMailTemplateIdList.setText(notify.getMailTemplateId());
        } 
        
        // イベントの抑制
        if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg().intValue() == ExclusionConstant.TYPE_PERIOD) {
            this.radioInhibitionPeriod.setSelection(true);
        } else if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg().intValue() == ExclusionConstant.TYPE_FREQUENCY) {
            this.radioInhibitionFrequency.setSelection(true);
        } else if (notify.getInhibitionFlg() != null && notify.getInhibitionFlg().intValue() == ExclusionConstant.TYPE_PRIORITY) {
            this.radioInhibitionPriority.setSelection(true);
        } else {
            this.radioNoInhibition.setSelection(true);
        }
        if (notify.getInhibitionPeriod() != null) {
        	this.textInhibitionPeriod.setText(notify.getInhibitionPeriod().toString());
        }
        if (notify.getInhibitionFrequency() != null) {
        	this.textInhibitionFrequency.setText(notify.getInhibitionFrequency().toString());
        }

        // 入力制御
        if(this.referenceFlg){
        	this.setEnabled(false);
        }
        else{
        	this.setEnabledForStatus(this.checkStatus.getSelection());
            this.setEnabledForEvent(this.checkEvent.getSelection());
        }
        
    }

	/**
	 * 入力値を設定した通知情報を返します。<BR>
	 * 入力値チェックを行い、不正な場合は<code>null</code>を返します。
	 * 
	 * @return 通知情報
	 * 
	 * @see #createInputDataForEvent(ArrayList, int, Button, Combo, Button, Combo, Button, Text)
	 * @see #setValidateResult(String, String)
	 */
    protected NotifyInfo createInputData() {
        NotifyInfo info = new NotifyInfo();

        if (this.textNotifyId.getText() != null
                && !"".equals((this.textNotifyId.getText()).trim())) {
        	info.setNotifyId(this.textNotifyId.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.10"));
            return null;
        }
        if (this.textDescription.getText() != null
                && !"".equals((this.textDescription.getText()).trim())) {
        	info.setDescription(this.textDescription.getText());
        }
        
        // ステータス通知
        if (this.checkStatus.getSelection()) {
            info.setStatusFlg(ValidConstant.TYPE_VALID);
        } else {
            info.setStatusFlg(ValidConstant.TYPE_INVALID);
        }
        if (this.comboStatusValidPeriod.getText() != null
                && !"".equals((this.comboStatusValidPeriod.getText()).trim())) {
        	info.setStatusValidPeriod(new Integer(StatusValidPeriodConstant.stringToType(this.comboStatusValidPeriod.getText())));
        }
        else{
        	if(this.checkStatus.getSelection()){
            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.12"));
            	return null;
        	}
        }
        if (this.radioStatusDelete.getSelection()) {
            info.setStatusInvalidFlg(StatusExpirationConstant.TYPE_DELETE);
        } else {
            info.setStatusInvalidFlg(StatusExpirationConstant.TYPE_UPDATE);
        }
        if (this.comboStatusPriority.getText() != null
                && !"".equals((this.comboStatusPriority.getText()).trim())) {
        	info.setStatusUpdatePriority(new Integer(PriorityConstant.stringToType(this.comboStatusPriority.getText())));
        }
        
        // イベント通知
        if (this.checkEvent.getSelection()) {
            info.setEventFlg(ValidConstant.TYPE_VALID);
        } else {
            info.setEventFlg(ValidConstant.TYPE_INVALID);
        }
        
        // イベント通知が選択されているが、各重要度で１つも通知が選択されていない場合はエラー
        if (this.checkEvent.getSelection()) {
        	if(!this.checkEventNormalInfo.getSelection() && !this.checkEventNormalWarning.getSelection() && !this.checkEventNormalCritical.getSelection() && !this.checkEventNormalUnknown.getSelection()){
            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.13"));
                    return null;
        	}
        }
        
        ArrayList<NotifyEventInfo> list = new ArrayList<NotifyEventInfo>();
        
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_INFO,		this.checkEventNormalInfo, 		this.comboEventNormalInfo, 		this.checkEventInhibitionInfo, 		this.comboEventInhibitionInfo, 		this.checkMailInfo, 	this.textMailInfo);
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_WARNING,	this.checkEventNormalWarning,		this.comboEventNormalWarning, 	this.checkEventInhibitionWarning, 	this.comboEventInhibitionWarning, 	this.checkMailWarning, 	this.textMailWarning);
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_CRITICAL,	this.checkEventNormalCritical,	this.comboEventNormalCritical, 	this.checkEventInhibitionCritical, 	this.comboEventInhibitionCritical, 	this.checkMailCritical,	this.textMailCritical);
        list = this.createInputDataForEvent(list, PriorityConstant.TYPE_UNKNOWN,	this.checkEventNormalUnknown, 	this.comboEventNormalUnknown, 	this.checkEventInhibitionUnknown, 	this.comboEventInhibitionUnknown, 	this.checkMailUnknown, 	this.textMailUnknown);
        
        if(list == null){
        	return null;
        }
        info.setNotifyEventInfo(list);
        
        // メールテンプレートID
        String mailTemplateId = this.compositeMailTemplateIdList.getText();
        if (mailTemplateId != null && !"".equals(mailTemplateId.trim())) {
        	info.setMailTemplateId(mailTemplateId);
        }       
        
        // 抑制
        if (this.radioInhibitionPeriod.getSelection()) {
            info.setInhibitionFlg(ExclusionConstant.TYPE_PERIOD);
        }
        else if(this.radioInhibitionFrequency.getSelection()) {
        	info.setInhibitionFlg(ExclusionConstant.TYPE_FREQUENCY);
        }
        else if(this.radioInhibitionPriority.getSelection()) {
        	info.setInhibitionFlg(ExclusionConstant.TYPE_PRIORITY);
        }
        else {
            info.setInhibitionFlg(ExclusionConstant.TYPE_NO);
        }
        
        try {
            info.setInhibitionPeriod(Integer.parseInt(this.textInhibitionPeriod.getText()));
        } catch (NumberFormatException e) {
            if (this.checkEvent.getSelection()
                    && this.radioInhibitionPeriod.getSelection()) {
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.14"));
                return null;
            }
        }
        try {
            info.setInhibitionFrequency(Integer.parseInt(this.textInhibitionFrequency.getText()));
        } catch (NumberFormatException e) {
            if (this.checkEvent.getSelection()
                    && this.radioInhibitionFrequency.getSelection()) {
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.15"));
                return null;
            }
        }

        return info;
    }

	/**
	 * 入力値チェックをします。
	 * 
	 * @return 検証結果
	 */
    protected ValidateResult validate() {
        // 入力値生成
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }
    
    /**
     * 入力値をマネージャに登録します。
     * 
     * @return true：正常、false：異常
     * 
     * @see com.clustercontrol.dialog.CommonDialog#action()
     */
    protected boolean action() {
    	boolean result = false;
    	
    	NotifyInfo info = this.getInputData();
    	if(info != null){
            if(this.notifyId == null){
            	// 作成の場合
            	result = new AddNotify().add(info);
            }
            else{
            	// 変更の場合
            	result = new ModifyNotify().modify(info);
            }
    	}
    	
    	return result;
    }

	/**
	 * ＯＫボタンのテキストを返します。
	 * 
	 * @return ＯＫボタンのテキスト
	 */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

	/**
	 * キャンセルボタンのテキストを返します。
	 * 
	 * @return キャンセルボタンのテキスト
	 */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
	/**
	 * 重要度のラベルを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @param text ラベルに表示するテキスト
	 * @param background ラベルの背景色
	 * @return 生成されたラベル
	 */
    protected Label getLabelPriority(Composite parent,
    		String text,
    		Color background
    		) {
    	
    	// ラベル（重要度）
    	Label label = new Label(parent, SWT.NONE);
    	GridData gridData = new GridData();
    	gridData.horizontalSpan = WIDTH_PRIORITY;
    	gridData.horizontalAlignment = GridData.FILL;
    	gridData.grabExcessHorizontalSpace = true;
    	label.setLayoutData(gridData);
    	label.setText(text + " : ");
    	label.setBackground(background);
        
        return label;
    }
    
	/**
	 * イベント通知の通知のチェックボックスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @return 生成されたチェックボックス
	 */
    protected Button getCheckEventNormal(Composite parent) {
    	
        // チェックボックス（通知する）
    	Button button = new Button(parent, SWT.CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.CENTER;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);
        
        return button;
    }
    
	/**
	 * イベント通知の通知状態コンボボックスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @return 生成されたコンボボックス
	 */
    protected Combo getComboEventNormal(Composite parent) {
    	
        // コンボボックス（通知状態）
    	Combo combo = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData(gridData);
        combo.add(EventConfirmConstant.STRING_UNCONFIRMED);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
        
        return combo;
    }
    
	/**
	 * イベント通知の抑制のチェックボックスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @return 生成されたチェックボックス
	 */
    protected Button getCheckEventInhibition(Composite parent) {
    	
        // チェックボックス（抑制する）
        Button button = new Button(parent, SWT.CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.CENTER;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);
        
        return button;
    }
    
	/**
	 * イベント通知の抑制状態コンボボックスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @return 生成されたコンボボックス
	 */
    protected Combo getComboEventInhibition(Composite parent) {
    	
        // コンボボックス（抑制時の状態）
        Combo combo = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_COMBO;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData(gridData);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.add(EventConfirmConstant.STRING_DESTRUCTION);
        combo.setText(EventConfirmConstant.STRING_CONFIRMED);
        
        return combo;
    }
    
	/**
	 * イベント通知のメールのチェックボックスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @return 生成されたチェックボックス
	 */
    protected Button getCheckMail(Composite parent) {
    	
        // チェックボックス（送信する）
        Button button = new Button(parent, SWT.CHECK);
        GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_CHECK;
        gridData.horizontalAlignment = GridData.CENTER;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);
        
        return button;
    }
    
	/**
	 * イベント通知のメールアドレステキストボックスを返します。
	 * 
	 * @param parent 親のインスタンス
	 * @return 生成されたテキストボックス
	 */
    protected Text getTextMail(Composite parent) {
    	
        // テキスト（送信先（セミコロン区切り））
    	Text text = new Text(parent, SWT.BORDER);
    	GridData gridData = new GridData();
        gridData.horizontalSpan = WIDTH_MAIL_ADDRESS;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData(gridData);
        text.addVerifyListener(
				new StringVerifyListener(DataRangeConstant.VARCHAR_1024));
        
        return text;
    }
    
	/**
	 * 入力値を設定した通知イベント情報を返します。<BR>
	 * 入力値チェックを行い、不正な場合は<code>null</code>を返します。
	 * 
	 * @return 通知イベント情報
	 * 
	 * @see #setValidateResult(String, String)
	 */
    protected ArrayList<NotifyEventInfo> createInputDataForEvent(ArrayList<NotifyEventInfo> list,
    		int priority,
    		Button checkEventNormal, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {
    	
    	if(list == null)
    		return null;
    	
    	NotifyEventInfo event = new NotifyEventInfo();
    	
    	event.setPriority(priority);
        if (checkEventNormal.getSelection()) {
        	event.setEventNormalFlg(new Integer(ValidConstant.TYPE_VALID));
        } else {
        	event.setEventNormalFlg(new Integer(ValidConstant.TYPE_INVALID));
        }
        if (comboEventNormal.getText() != null
                && !"".equals((comboEventNormal.getText()).trim())) {
        	event.setEventNormalState(new Integer(EventConfirmConstant.stringToType(comboEventNormal.getText())));
        }
        if (checkEventInhibition.getSelection()) {
        	if(checkEvent.getSelection() && checkEventNormal.getSelection() && radioNoInhibition.getSelection()){
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.16"));
                return null;
        	}
    		event.setEventInhibitionFlg(new Integer(ValidConstant.TYPE_VALID));
        } else {
        	event.setEventInhibitionFlg(new Integer(ValidConstant.TYPE_INVALID));
        }
        if (comboEventInhibition.getText() != null
                && !"".equals((comboEventInhibition.getText()).trim())) {
        	event.setEventInhibitionState(new Integer(EventConfirmConstant.stringToType(comboEventInhibition.getText())));
        }
        if (checkMail.getSelection()) {
        	event.setMailFlg(new Integer(ValidConstant.TYPE_VALID));
        } else {
        	event.setMailFlg(new Integer(ValidConstant.TYPE_INVALID));
        }
        if (textMail.getText() != null
                && !"".equals((textMail.getText()).trim())) {
    		//セミコロンで分ける
    		StringTokenizer t = new StringTokenizer(textMail.getText(), ";");
    		while (t.hasMoreTokens()) {
    			String mailAddress = t.nextToken();    			
    			//@マークで分ける
    			String attr[] = mailAddress.split("@");
    			if (attr.length != 2) {
            		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.18"));
                    return null;
                }
    		}
        	event.setMailAddress(textMail.getText());
        } else {
        	if(checkEvent.getSelection() && checkEventNormal.getSelection() && checkMail.getSelection()){
                this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.notify.17"));
                return null;
        	}
        }
        list.add(event);
        return list;
    }
    
	/**
	 * 引数で指定された通知イベント情報の値を、各項目に設定します。
	 * 
	 * @param info 設定値として用いる通知イベント情報
	 * @param checkEventNormal 通知チェックボックス
	 * @param comboEventNormal 通知状態コンボボックス
	 * @param checkEventInhibition 抑制チェックボックス
	 * @param comboEventInhibition 抑制状態コンボボックス
	 * @param checkMail メールチェックボックス
	 * @param textMail メールアドレステキストボックス
	 */
    private void setInputDataForEvent(NotifyEventInfo info, 
    		Button checkEventNormal, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {
    	
        if (info.getEventNormalFlg() != null && info.getEventNormalFlg().intValue() == ValidConstant.TYPE_VALID) {
        	checkEventNormal.setSelection(true);
        } 
        if (info.getEventNormalState() != null) {
        	comboEventNormal.setText(EventConfirmConstant.typeToString(info.getEventNormalState().intValue()));
        }
        if (info.getEventInhibitionFlg() != null && info.getEventInhibitionFlg().intValue() == ValidConstant.TYPE_VALID) {
        	checkEventInhibition.setSelection(true);
        } 
        if (info.getEventInhibitionState() != null) {
        	comboEventInhibition.setText(EventConfirmConstant.typeToString(info.getEventInhibitionState().intValue()));
        }
        if (info.getMailFlg() != null && info.getMailFlg().intValue() == ValidConstant.TYPE_VALID) {
        	checkMail.setSelection(true);
        } 
        if (info.getMailAddress() != null) {
        	textMail.setText(info.getMailAddress());
        }
    }
    
	/**
	 * コンポジットの選択可/不可を設定します。
	 * 
	 * @param enable 選択可の場合、<code> true </code>
	 */
    private void setEnabled(boolean enable) {

    	this.textDescription.setEnabled(enable);
    	this.checkStatus.setEnabled(enable);
    	this.checkEvent.setEnabled(enable);
    	
    	this.setEnabledForStatus(enable);
        this.setEnabledForEvent(enable);
    }
    
	/**
	 * ステータス通知のコンポジットの選択可/不可を設定します。
	 * 
	 * @param enable 選択可の場合、<code> true </code>
	 */
    private void setEnabledForStatus(boolean enable) {

        this.comboStatusValidPeriod.setEnabled(enable);
    	this.radioStatusDelete.setEnabled(enable);
        this.radioStatusUpdate.setEnabled(enable);
        if (enable) {
            this.comboStatusPriority.setEnabled(this.radioStatusUpdate.getSelection());
        } else {
            this.comboStatusPriority.setEnabled(enable);
        }
    }
    
	/**
	 * イベント通知の通知関連コンポジットの選択可/不可を設定します。
	 * 
	 * @param enable 選択可の場合、<code> true </code>
	 * 
	 * @see #setEnabledForEvents(boolean, Button, Combo, Button, Combo, Button, Text)
	 */
    private void setEnabledForEvent(boolean enable) {

    	// 通知関連
        this.setEnabledForEvents(enable, this.checkEventNormalInfo, 	this.comboEventNormalInfo, 		this.checkEventInhibitionInfo, 		this.comboEventInhibitionInfo, 		this.checkMailInfo, 	this.textMailInfo);
        this.setEnabledForEvents(enable, this.checkEventNormalWarning, 	this.comboEventNormalWarning, 	this.checkEventInhibitionWarning, 	this.comboEventInhibitionWarning, 	this.checkMailWarning, 	this.textMailWarning);
        this.setEnabledForEvents(enable, this.checkEventNormalCritical, this.comboEventNormalCritical, 	this.checkEventInhibitionCritical, 	this.comboEventInhibitionCritical, 	this.checkMailCritical,	this.textMailCritical);
        this.setEnabledForEvents(enable, this.checkEventNormalUnknown, 	this.comboEventNormalUnknown, 	this.checkEventInhibitionUnknown, 	this.comboEventInhibitionUnknown, 	this.checkMailUnknown, 	this.textMailUnknown);
        
        // メール関連
        setEnabledForMailTemplateId();
        
        // 抑制関連
        setEnabledForEventInhibition();
    }
    
	/**
	 * イベント通知の抑制関連コンポジットの選択可/不可を設定します。
	 * 
	 * @param enable 選択可の場合、<code> true </code>
	 */
    private void setEnabledForEventInhibition() {
    	
    	boolean enable = false;
    	
    	// イベント通知チェックボックスを確認する。
    	if (checkEvent.getSelection()) {
	    	// 全重要度の「抑制」のチェックボックスのチェック内容と表示/非表示を確認する。
	    	if ((this.checkEventInhibitionInfo.getSelection() && this.checkEventInhibitionInfo.getEnabled()) || 
	    			(this.checkEventInhibitionWarning.getSelection() && this.checkEventInhibitionWarning.getEnabled()) || 
	    			(this.checkEventInhibitionCritical.getSelection() && this.checkEventInhibitionCritical.getEnabled()) || 
	    			(this.checkEventInhibitionUnknown.getSelection() && this.checkEventInhibitionUnknown.getEnabled())) {
	    		enable = true;
	    	}
	    	else {
	    		enable = false;
	    	}
	    }
	    else {
	    	enable = false;
	    }
    	
        // 抑制関連
        this.radioNoInhibition.setEnabled(enable);
        this.radioInhibitionPeriod.setEnabled(enable);
        this.radioInhibitionFrequency.setEnabled(enable);
        this.radioInhibitionPriority.setEnabled(enable);
        if (enable) {
            this.textInhibitionPeriod.setEnabled(this.radioInhibitionPeriod.getSelection());
        } else {
            this.textInhibitionPeriod.setEnabled(false);
        }
        if (enable) {
            this.textInhibitionFrequency.setEnabled(this.radioInhibitionFrequency.getSelection());
        } else {
            this.textInhibitionFrequency.setEnabled(false);
        }
    }
    
	/**
	 * 
	 * イベント通知のコンポジットの選択可/不可を設定します。
	 * 
	 * @param enable 選択可の場合、<code> true </code>
	 * @param checkEventNormal 通知チェックボックス
	 * @param comboEventNormal 通知状態コンボボックス
	 * @param checkEventInhibition 抑制チェックボックス
	 * @param comboEventInhibition 抑制状態コンボボックス
	 * @param checkMail メールチェックボックス
	 * @param textMail メールアドレステキストボックス
	 * 
	 * @see #setEnabledForEvent(boolean, Combo, Button, Combo, Button, Text)
	 */
    private void setEnabledForEvents(boolean enable, 
    		Button checkEventNormal, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {

    	checkEventNormal.setEnabled(enable);
    	
        if (enable) {
        	this.setEnabledForEvent(checkEventNormal.getSelection(), comboEventNormal, checkEventInhibition, comboEventInhibition, checkMail, textMail);
        }
        else{
        	this.setEnabledForEvent(false, comboEventNormal, checkEventInhibition, comboEventInhibition, checkMail, textMail);
        }
    }
    
	/**
	 * イベント通知のコンポジットの選択可/不可を設定します。
	 *
	 * @param enable 選択可の場合、<code> true </code>
	 * @param comboEventNormal 通知状態コンボボックス
	 * @param checkEventInhibition 抑制チェックボックス
	 * @param comboEventInhibition 抑制状態コンボボックス
	 * @param checkMail メールチェックボックス
	 */
    private void setEnabledForEvent(boolean enable, 
    		Combo comboEventNormal,
    		Button checkEventInhibition, 
    		Combo comboEventInhibition,
    		Button checkMail,
    		Text textMail
    		) {

        if (enable) {
        	comboEventNormal.setEnabled(true);
        	
        	checkEventInhibition.setEnabled(true);
        	comboEventInhibition.setEnabled(checkEventInhibition.getSelection());
        	
        	checkMail.setEnabled(true);
        	textMail.setEnabled(checkMail.getSelection());
        }
        else{
        	comboEventNormal.setEnabled(false);
        	
        	checkEventInhibition.setEnabled(false);
        	comboEventInhibition.setEnabled(false);
        	
        	checkMail.setEnabled(false);
        	textMail.setEnabled(false);
        }
        setEnabledForMailTemplateId();
    }
    
	/**
	 * メールテンプレートID一覧コンポジットの選択可/不可を設定します。
	 */
    private void setEnabledForMailTemplateId() {
    	
    	// イベント通知チェックボックスを確認する。
    	if (checkEvent.getSelection()) {
	    	// 全重要度の「メール」のテキストボックスを確認する。
    		if (this.textMailInfo.getEnabled() || this.textMailWarning.getEnabled() ||
    				this.textMailUnknown.getEnabled() || this.textMailCritical.getEnabled()) {
	    		this.compositeMailTemplateIdList.setEnabled(true);
	    	} else {
	    		this.compositeMailTemplateIdList.setEnabled(false);
	    	}
    	} else {
    		this.compositeMailTemplateIdList.setEnabled(false);
    	}
    }

	/**
	 * 無効な入力値の情報を設定します。
	 * 
	 * @param id ID
	 * @param message メッセージ
	 */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
    
	/**
	 * ボタンを生成します。<BR>
	 * 参照フラグが<code> true </code>の場合は閉じるボタンを生成し、<code> false </code>の場合は、デフォルトのボタンを生成します。
	 * 
	 * @param parent ボタンバーコンポジット
	 * 
	 * @see #createButtonsForButtonBar(Composite)
	 */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        if(!this.referenceFlg){
        	super.createButtonsForButtonBar(parent);
        }
        else{
        	// 閉じるボタン
            this.createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);
        }
    }
}