/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 通知情報を削除するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteNotify {

    /**
     * 通知情報を削除します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @param notifyId 削除対象の通知ID
	 * @return 削除に成功した場合、<code> true </code>
	 * 
	 * @see com.clustercontrol.notify.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.ejb.session.NotifyController
	 * @see com.clustercontrol.notify.ejb.session.NotifyControllerBean#deleteNotify(java.lang.String)
     */
    public boolean delete(String notifyId) {
    	
        NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

        boolean result = false;
        try {
        	result = notify.deleteNotify(notifyId);
        	return result;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (RemoveException e) {
        } catch (NamingException e) {
        } catch (JMSException e) {
        }
        return false;
    }
}