/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.resource.adapter.jdbc.StatementAccess;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedResultSet;

public class WrappedStatement
implements Statement,
StatementAccess,
org.jboss.ejb.plugins.cmp.jdbc.WrappedStatement {
    private final WrappedConnection lc;
    private final Statement s;
    private HashMap resultSets;

    public WrappedStatement(WrappedConnection lc, Statement s) {
        this.lc = lc;
        this.s = s;
        lc.registerStatement(this);
    }

    public void close() throws SQLException {
        this.lc.unregisterStatement(this);
        this.internalClose();
    }

    public boolean execute(String sql) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql);
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.lc;
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.s.getWarnings();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.s.clearWarnings();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            ResultSet result = this.s.executeQuery(sql);
            return this.registerResultSet(result);
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            return this.s.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.s.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            return this.s.getMaxRows();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            this.s.setMaxRows(max);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.s.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            return this.s.getQueryTimeout();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public void setQueryTimeout(int timeout) throws SQLException {
        try {
            this.s.setQueryTimeout(timeout);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void cancel() throws SQLException {
        try {
            this.s.cancel();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        try {
            this.s.setCursorName(name);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            ResultSet result = this.s.getResultSet();
            if (result == null) {
                return null;
            }
            return this.registerResultSet(result);
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            return this.s.getUpdateCount();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            return this.s.getMoreResults();
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.s.getMoreResults(current);
        }
        catch (SQLException e) {
            this.checkException(e);
            return false;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.s.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            return this.s.getFetchDirection();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            this.s.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            return this.s.getFetchSize();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.s.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            return this.s.getResultSetType();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public void addBatch(String sql) throws SQLException {
        try {
            this.s.addBatch(sql);
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.s.clearBatch();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeBatch();
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            ResultSet resultSet = this.s.getGeneratedKeys();
            return this.registerResultSet(resultSet);
        }
        catch (SQLException e) {
            this.checkException(e);
            return null;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            return this.s.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.checkException(e);
            return 0;
        }
    }

    public Statement getUnderlyingStatement() {
        return this.s;
    }

    protected void checkException(SQLException e) throws SQLException {
        this.lc.checkException(e);
    }

    protected void checkTransaction() throws SQLException {
        this.lc.checkTransaction();
    }

    protected void checkConfiguredQueryTimeout() throws SQLException {
        this.lc.checkConfiguredQueryTimeout(this);
    }

    protected void internalClose() throws SQLException {
        try {
            this.closeResultSets();
            this.s.close();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet registerResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = new WrappedResultSet(this, resultSet);
        }
        if (this.lc.getTrackStatements() == 0) {
            return resultSet;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                this.resultSets = new HashMap();
            }
            if (this.lc.getTrackStatements() == 1) {
                this.resultSets.put(resultSet, new Throwable("STACKTRACE"));
            } else {
                this.resultSets.put(resultSet, null);
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterResultSet(WrappedResultSet resultSet) {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets != null) {
                this.resultSets.remove(resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSets() {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                return;
            }
            Iterator i = this.resultSets.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                WrappedResultSet resultSet = (WrappedResultSet)entry.getKey();
                if (this.lc.getTrackStatements() == 1) {
                    Throwable stackTrace = (Throwable)entry.getValue();
                    this.lc.getLogger().warn((Object)"Closing a result set you left open! Please close it yourself.", stackTrace);
                }
                try {
                    resultSet.internalClose();
                }
                catch (Throwable t) {
                    this.lc.getLogger().warn((Object)"Error closing a result set you left open! Please close it yourself.", t);
                }
            }
            this.resultSets.clear();
        }
    }
}

