/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.BreakIterator;
import org.jfree.text.TextBlock;
import org.jfree.text.TextFragment;
import org.jfree.text.TextLine;
import org.jfree.text.TextMeasurer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public abstract class TextUtilities {
    protected static final LogContext logger = Log.createContext(class$org$jfree$text$TextUtilities == null ? (class$org$jfree$text$TextUtilities = TextUtilities.class$("org.jfree.text.TextUtilities")) : class$org$jfree$text$TextUtilities);
    private static boolean useFontMetricsGetStringBounds = false;
    static /* synthetic */ Class class$org$jfree$text$TextUtilities;

    public static TextBlock createTextBlock(String string, Font font, Paint paint, float f, TextMeasurer textMeasurer) {
        return TextUtilities.createTextBlock(string, font, paint, f, Integer.MAX_VALUE, textMeasurer);
    }

    public static TextBlock createTextBlock(String string, Font font, Paint paint, float f, int n, TextMeasurer textMeasurer) {
        TextBlock textBlock = new TextBlock();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; n2 < n3 && i < n; ++i) {
            int n4 = TextUtilities.nextLineBreak(string, n2, f, breakIterator, textMeasurer);
            if (n4 == -1) {
                textBlock.addLine(string.substring(n2), font, paint);
                return textBlock;
            }
            textBlock.addLine(string.substring(n2, n4), font, paint);
            n2 = n4;
        }
        if (n2 < n3) {
            TextLine textLine = textBlock.getLastLine();
            TextFragment textFragment = textLine.getLastTextFragment();
            String string2 = textFragment.getText();
            String string3 = "...";
            if (string2.length() > 3) {
                string3 = string2.substring(0, string2.length() - 3) + "...";
            }
            textLine.removeFragment(textFragment);
            TextFragment textFragment2 = new TextFragment(string3, textFragment.getFont(), textFragment.getPaint());
            textLine.addFragment(textFragment2);
        }
        return textBlock;
    }

    private static int nextLineBreak(String string, int n, float f, BreakIterator breakIterator, TextMeasurer textMeasurer) {
        int n2;
        int n3 = n;
        float f2 = 0.0f;
        boolean bl = true;
        while ((n2 = breakIterator.next()) != -1) {
            if ((f2 += textMeasurer.getStringWidth(string, n3, n2)) > f) {
                if (bl) {
                    while (textMeasurer.getStringWidth(string, n, n2) > f) {
                        --n2;
                    }
                    return n2;
                }
                n2 = breakIterator.previous();
                return n2;
            }
            bl = false;
            n3 = n2;
        }
        return -1;
    }

    public static Rectangle2D getTextBounds(String string, Graphics2D graphics2D, FontMetrics fontMetrics) {
        Rectangle2D rectangle2D = null;
        if (useFontMetricsGetStringBounds) {
            rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        } else {
            double d = fontMetrics.stringWidth(string);
            double d2 = fontMetrics.getHeight();
            if (logger.isDebugEnabled()) {
                logger.debug("Height = " + d2);
            }
            rectangle2D = new Rectangle2D.Double(0.0, -fontMetrics.getAscent(), d, d2);
        }
        return rectangle2D;
    }

    public static Rectangle2D drawAlignedString(String string, Graphics2D graphics2D, float f, float f2, TextAnchor textAnchor) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        float[] fArray = TextUtilities.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor, double_);
        graphics2D.drawString(string, f + fArray[0], f2 + fArray[1]);
        return double_;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor, Rectangle2D rectangle2D) {
        float[] fArray = new float[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = lineMetrics.getAscent();
        float f2 = f / 2.0f;
        float f3 = lineMetrics.getDescent();
        float f4 = lineMetrics.getLeading();
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.CENTER || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BASELINE_CENTER || textAnchor == TextAnchor.HALF_ASCENT_CENTER) {
            f5 = (float)(-rectangle2D2.getWidth()) / 2.0f;
        } else if (textAnchor == TextAnchor.TOP_RIGHT || textAnchor == TextAnchor.CENTER_RIGHT || textAnchor == TextAnchor.BOTTOM_RIGHT || textAnchor == TextAnchor.BASELINE_RIGHT || textAnchor == TextAnchor.HALF_ASCENT_RIGHT) {
            f5 = (float)(-rectangle2D2.getWidth());
        }
        if (textAnchor == TextAnchor.TOP_LEFT || textAnchor == TextAnchor.TOP_CENTER || textAnchor == TextAnchor.TOP_RIGHT) {
            f6 = -f3 - f4 + (float)rectangle2D2.getHeight();
        } else if (textAnchor == TextAnchor.HALF_ASCENT_LEFT || textAnchor == TextAnchor.HALF_ASCENT_CENTER || textAnchor == TextAnchor.HALF_ASCENT_RIGHT) {
            f6 = f2;
        } else if (textAnchor == TextAnchor.CENTER_LEFT || textAnchor == TextAnchor.CENTER || textAnchor == TextAnchor.CENTER_RIGHT) {
            f6 = -f3 - f4 + (float)(rectangle2D2.getHeight() / 2.0);
        } else if (textAnchor == TextAnchor.BASELINE_LEFT || textAnchor == TextAnchor.BASELINE_CENTER || textAnchor == TextAnchor.BASELINE_RIGHT) {
            f6 = 0.0f;
        } else if (textAnchor == TextAnchor.BOTTOM_LEFT || textAnchor == TextAnchor.BOTTOM_CENTER || textAnchor == TextAnchor.BOTTOM_RIGHT) {
            f6 = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        if (rectangle2D != null) {
            rectangle2D.setRect(rectangle2D2);
        }
        fArray[0] = f5;
        fArray[1] = f6;
        return fArray;
    }

    public static boolean getUseFontMetricsGetStringBounds() {
        return useFontMetricsGetStringBounds;
    }

    public static void setUseFontMetricsGetStringBounds(boolean bl) {
        useFontMetricsGetStringBounds = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

