/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.util.Base64;

public class HTTPClientInvoker
extends RemoteClientInvoker {
    protected final Logger log = Logger.getLogger(this.getClass());

    public HTTPClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        String targetURL = this.getLocator().getOriginalURI();
        Object httpResponse = this.useHttpURLConnection(targetURL, invocation, metadata, marshaller, unmarshaller);
        return httpResponse;
    }

    private Object useHttpURLConnection(String url, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) {
        Object result = null;
        try {
            HttpURLConnection conn = this.createURLConnection(url, metadata);
            String basicAuth = this.getBasicAuth(metadata);
            if (basicAuth != null) {
                conn.setRequestProperty("Authorization", basicAuth);
            }
            boolean isPost = true;
            if (metadata != null) {
                Map header;
                String type = (String)metadata.get("TYPE");
                if (type != null && type.equals("GET")) {
                    isPost = false;
                }
                if ((header = (Map)metadata.get("HEADER")) != null) {
                    Set keys = header.keySet();
                    Iterator itr = keys.iterator();
                    while (itr.hasNext()) {
                        String key = (String)itr.next();
                        String value = (String)header.get(key);
                        this.log.debug("Setting request header with " + key + " : " + value);
                        conn.setRequestProperty(key, value);
                    }
                }
            }
            if (!isPost) {
                throw new Exception("HTTP GET opperation not currently supported.");
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            OutputStream stream = conn.getOutputStream();
            marshaller.write(invocation, stream);
            InputStream is = conn.getInputStream();
            Map<String, List<String>> headers = conn.getHeaderFields();
            result = unmarshaller.read(is, headers);
        }
        catch (Exception e) {
            this.log.debug("Error invoking http client invoker.", e);
            throw new CannotConnectException("Can not connect http client invoker.", e);
        }
        return result;
    }

    protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
        URL externalURL = null;
        HttpURLConnection httpURLConn = null;
        String proxyHost = null;
        String proxyportString = null;
        int proxyPort = -1;
        boolean proxyOn = true;
        if (metadata != null) {
            proxyHost = (String)metadata.get("http.proxyHost");
            proxyportString = (String)metadata.get("http.proxyPort");
            if (proxyportString != null && proxyportString.length() > 0) {
                try {
                    proxyPort = Integer.parseInt(proxyportString);
                }
                catch (NumberFormatException e) {
                    this.log.warn("Error converting proxy port specified (" + proxyportString + ") to a number.");
                }
            }
        }
        if (proxyHost == null) {
            String proxyOnString;
            proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost == null) {
                proxyHost = System.getProperty("proxyHost");
            }
            if ((proxyOnString = System.getProperty("http.proxySet")) == null) {
                proxyOnString = System.getProperty("proxySet");
            }
            if (proxyOnString != null) {
                proxyOn = Boolean.getBoolean(proxyOnString);
            }
        }
        if (proxyPort < 0) {
            String proxyPortString = System.getProperty("http.proxyPort");
            if (proxyPortString == null) {
                proxyPortString = System.getProperty("proxyPort");
            }
            if (proxyPortString != null) {
                try {
                    proxyPort = Integer.parseInt(proxyPortString);
                }
                catch (NumberFormatException e) {
                    this.log.warn("Error converting proxy port specified (" + proxyportString + ") to a number.");
                }
            }
        }
        if (proxyHost != null && proxyOn) {
            externalURL = new URL("http", proxyHost, proxyPort, url);
            httpURLConn = (HttpURLConnection)externalURL.openConnection();
            String proxyAuth = this.getProxyAuth(metadata);
            if (proxyAuth != null) {
                httpURLConn.setRequestProperty("Proxy-Authorization", proxyAuth);
            }
        } else {
            externalURL = new URL(url);
            httpURLConn = (HttpURLConnection)externalURL.openConnection();
        }
        return httpURLConn;
    }

    private String getProxyAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.proxy.username");
        }
        if (username == null || username.length() == 0) {
            username = System.getProperty("http.proxy.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.proxy.password");
        }
        if (password == null || password.length() == 0) {
            password = System.getProperty("http.proxy.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes(buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    private String getBasicAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.basic.username");
        }
        if (username == null || username.length() == 0) {
            username = System.getProperty("http.basic.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.basic.password");
        }
        if (password == null || password.length() == 0) {
            password = System.getProperty("http.basic.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes(buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    protected void handleConnect() throws ConnectionFailedException {
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "http";
    }
}

