/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PingProperties {
    protected static Log m_log = LogFactory.getLog(PingProperties.class);
    private static final String FPING_ENABLE = "true";
    private static final String FPING_COUNT = "1";
    private static final String FPING_INTERVAL = "1000";
    private static final String FPING_TIMEOUT = "1000";
    private static final String FPING_PATH = "/opt/hinemos/sbin/fping";
    private static final String FPING_ENABLE_KEY = "hinemos.fping.enable";
    private static final String FPING_COUNT_KEY = "hinemos.fping.count";
    private static final String FPING_INTERVAL_KEY = "hinemos.fping.interval";
    private static final String FPING_TIMEOUT_KEY = "hinemos.fping.timeout";
    private static final String FPING_PATH_KEY = "hinemos.fping.path";
    private static PingProperties m_instance = null;
    private static boolean m_fpingEnable;
    private static int m_fpingCount;
    private static int m_fpingInterval;
    private static int m_fpingTimeout;
    private static String m_fpingPath;

    public static PingProperties getProperties() {
        if (m_instance == null) {
            m_instance = new PingProperties();
        }
        return m_instance;
    }

    private PingProperties() {
        this.setValue();
    }

    private void setValue() {
        Properties properties = new Properties();
        try {
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "ping.properties";
            properties.load(new FileInputStream(propertyFile));
            String enable = properties.getProperty(FPING_ENABLE_KEY, FPING_ENABLE);
            String count = properties.getProperty(FPING_COUNT_KEY, FPING_COUNT);
            String interval = properties.getProperty(FPING_INTERVAL_KEY, "1000");
            String timeout = properties.getProperty(FPING_TIMEOUT_KEY, "1000");
            m_fpingPath = properties.getProperty(FPING_PATH_KEY, FPING_PATH);
            m_fpingEnable = new Boolean(enable);
            m_fpingCount = new Integer(count);
            m_fpingInterval = new Integer(interval);
            m_fpingTimeout = new Integer(timeout);
        }
        catch (Exception e) {
            m_log.error((Object)("setValue(): " + e.getMessage()));
        }
    }

    public static int getM_fpingCount() {
        return m_fpingCount;
    }

    public static boolean isM_fpingEnable() {
        return m_fpingEnable;
    }

    public static int getM_fpingInterval() {
        return m_fpingInterval;
    }

    public static int getM_fpingTimeout() {
        return m_fpingTimeout;
    }

    public static String getM_fpingPath() {
        return m_fpingPath;
    }
}

