/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class StyledTextComposite
extends Composite {
    private StyledText textCanvas;
    private String[] keywords;
    private Color color;

    public StyledTextComposite(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.textCanvas = new StyledText((Composite)this, style);
        this.textCanvas.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                if (StyledTextComposite.this.keywords == null) {
                    return;
                }
                String lineText = event.lineText;
                ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
                int i = 0;
                while (i < StyledTextComposite.this.keywords.length) {
                    int index = 0;
                    int fromIndex = 0;
                    String keyword = StyledTextComposite.this.keywords[i];
                    while ((index = lineText.indexOf(keyword, fromIndex)) != -1) {
                        StyleRange styleRange = new StyleRange();
                        styleRange.start = event.lineOffset + index;
                        styleRange.length = keyword.length();
                        styleRange.foreground = StyledTextComposite.this.color;
                        styleRanges.add(styleRange);
                        fromIndex = index + keyword.length();
                    }
                    ++i;
                }
                event.styles = styleRanges.toArray(new StyleRange[styleRanges.size()]);
            }
        });
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public String getText() {
        return this.textCanvas.getText();
    }

    public void setText(String text) {
        this.textCanvas.setText(text);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void addVerifyListener(VerifyListener listener) {
        this.textCanvas.addVerifyListener(listener);
    }

    public void setInputUpper(int upper) {
        this.textCanvas.addVerifyListener((VerifyListener)new StringVerifyListener(upper));
    }

    private class StringVerifyListener
    implements VerifyListener {
        private Integer length;

        public StringVerifyListener(int length) {
            this.length = new Integer(length);
        }

        public void verifyText(VerifyEvent e) {
            StyledText text = (StyledText)e.getSource();
            StringBuilder input = new StringBuilder(text.getText());
            if (e.keyCode == 0) {
                input.replace(e.start, e.end, e.text);
            } else if (e.character == '\b' || e.character == '\u007f') {
                input.delete(e.start, e.end);
            } else {
                input.replace(e.start, e.end, e.text);
            }
            this.checkLength(e, input.toString());
        }

        private void checkLength(VerifyEvent e, String inputText) {
            if (inputText.length() > this.length) {
                e.doit = false;
                Object[] args = new String[]{this.length.toString()};
                MessageDialog.openWarning(null, (String)Messages.getString("message.hinemos.1"), (String)Messages.getString("message.hinemos.7", args));
            }
        }
    }
}

