/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.EclipseBundleListener;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionDelta;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.ReadWriteMonitor;
import org.eclipse.core.internal.registry.RegistryChangeEvent;
import org.eclipse.core.internal.registry.RegistryDelta;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.TableReader;
import org.eclipse.core.internal.registry.TableWriter;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.adaptor.FileManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

public class ExtensionRegistry
implements IExtensionRegistry {
    private EclipseBundleListener pluginBundleListener;
    public static boolean DEBUG;
    private static final String OPTION_DEBUG_EVENTS_EXTENSION = "org.eclipse.core.runtime/registry/debug/events/extension";
    private ReadWriteMonitor access = new ReadWriteMonitor();
    private transient Map deltas = new HashMap(11);
    private FileManager currentFileManager = null;
    private transient ListenerList listeners = new ListenerList();
    private RegistryObjectManager registryObjects = null;
    static /* synthetic */ Class class$0;

    RegistryObjectManager getObjectManager() {
        return this.registryObjects;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Contribution element) {
        this.access.enterWrite();
        try {
            this.basicAdd(element, true);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.access.exitWrite();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Contribution[] elements) {
        this.access.enterWrite();
        try {
            int i = 0;
            while (true) {
                block4: {
                    if (i < elements.length) break block4;
                    this.fireRegistryChangeEvent();
                    break;
                }
                this.basicAdd(elements[i], true);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.access.exitWrite();
            return;
        }
    }

    static Object concatArrays(Object a, Object b) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), Array.getLength(a) + Array.getLength(b));
        System.arraycopy(a, 0, result, 0, Array.getLength(a));
        System.arraycopy(b, 0, result, Array.getLength(a), Array.getLength(b));
        return result;
    }

    private String addExtension(int extension) {
        Extension addedExtension = (Extension)this.registryObjects.getObject(extension, (byte)2);
        String extensionPointToAddTo = addedExtension.getExtensionPointIdentifier();
        ExtensionPoint extPoint = this.registryObjects.getExtensionPointObject(extensionPointToAddTo);
        if (extPoint == null) {
            this.registryObjects.addOrphan(extensionPointToAddTo, extension);
            return null;
        }
        int[] existingExtensions = extPoint.getRawChildren();
        int[] newExtensions = new int[existingExtensions.length + 1];
        System.arraycopy(existingExtensions, 0, newExtensions, 0, existingExtensions.length);
        newExtensions[newExtensions.length - 1] = extension;
        this.link(extPoint, newExtensions);
        return this.recordChange(extPoint, extension, 1);
    }

    private String addExtensionPoint(int extPoint) {
        ExtensionPoint extensionPoint = (ExtensionPoint)this.registryObjects.getObject(extPoint, (byte)3);
        int[] orphans = this.registryObjects.removeOrphans(extensionPoint.getUniqueIdentifier());
        if (orphans == null) {
            return null;
        }
        this.link(extensionPoint, orphans);
        return this.recordChange(extensionPoint, orphans, 1);
    }

    private Set addExtensionsAndExtensionPoints(Contribution element) {
        HashSet<String> affectedNamespaces = new HashSet<String>();
        int[] extPoints = element.getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            String namespace = this.addExtensionPoint(extPoints[i]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i;
        }
        int[] extensions = element.getExtensions();
        int i2 = 0;
        while (i2 < extensions.length) {
            String namespace = this.addExtension(extensions[i2]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i2;
        }
        return affectedNamespaces;
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener) {
        this.addRegistryChangeListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistryChangeListener(IRegistryChangeListener listener, String filter) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.add(new ListenerInfo(listener, filter));
        }
    }

    private void basicAdd(Contribution element, boolean link) {
        if (element.getNamespace() == null) {
            return;
        }
        this.registryObjects.addContribution(element);
        if (!link) {
            return;
        }
        Set affectedNamespaces = this.addExtensionsAndExtensionPoints(element);
        this.setObjectManagers(affectedNamespaces, this.registryObjects.createDelegatingObjectManager(this.registryObjects.getAssociatedObjects(element.getContributingBundle().getBundleId())));
    }

    private void setObjectManagers(Set affectedNamespaces, IObjectManager manager) {
        Iterator iter = affectedNamespaces.iterator();
        while (iter.hasNext()) {
            this.getDelta((String)iter.next()).setObjectManager(manager);
        }
    }

    private void basicRemove(long bundleId) {
        Set affectedNamespaces = this.removeExtensionsAndExtensionPoints(bundleId);
        Map associatedObjects = this.registryObjects.getAssociatedObjects(bundleId);
        this.registryObjects.removeObjects(associatedObjects);
        this.setObjectManagers(affectedNamespaces, this.registryObjects.createDelegatingObjectManager(associatedObjects));
        this.registryObjects.removeContribution(bundleId);
    }

    void enterRead() {
        this.access.enterRead();
    }

    void exitRead() {
        this.access.exitRead();
    }

    private void fireRegistryChangeEvent() {
        if (this.deltas.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        Object[] tmpListeners = this.listeners.getListeners();
        HashMap tmpDeltas = new HashMap(this.deltas);
        this.deltas.clear();
        new ExtensionEventDispatcherJob(tmpListeners, tmpDeltas).schedule();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return new IConfigurationElement[0];
        }
        return this.getConfigurationElementsFor(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1));
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointSimpleId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointSimpleId);
        if (extPoint == null) {
            return new IConfigurationElement[0];
        }
        return extPoint.getConfigurationElements();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointName, String extensionId) {
        IExtension extension = this.getExtension(pluginId, extensionPointName, extensionId);
        if (extension == null) {
            return new IConfigurationElement[0];
        }
        return extension.getConfigurationElements();
    }

    private RegistryDelta getDelta(String namespace) {
        RegistryDelta existingDelta = (RegistryDelta)this.deltas.get(namespace);
        if (existingDelta != null) {
            return existingDelta;
        }
        RegistryDelta delta = new RegistryDelta();
        this.deltas.put(namespace, delta);
        return delta;
    }

    public IExtension getExtension(String extensionId) {
        if (extensionId == null) {
            return null;
        }
        int lastdot = extensionId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        String namespace = extensionId.substring(0, lastdot);
        Bundle[] allBundles = this.findAllBundles(namespace);
        int i = 0;
        while (i < allBundles.length) {
            int[] extensions = this.registryObjects.getExtensionsFrom(allBundles[i].getBundleId());
            int j = 0;
            while (j < extensions.length) {
                Extension ext = (Extension)this.registryObjects.getObject(extensions[j], (byte)2);
                if (extensionId.equals(ext.getUniqueIdentifier()) && this.registryObjects.getExtensionPointObject(ext.getExtensionPointIdentifier()) != null) {
                    return (IExtension)((Object)this.registryObjects.getHandle(extensions[j], (byte)2));
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtension(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1), extensionId);
    }

    public IExtension getExtension(String pluginId, String extensionPointName, String extensionId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointName);
        if (extPoint != null) {
            return extPoint.getExtension(extensionId);
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        return this.registryObjects.getExtensionPointHandle(xptUniqueId);
    }

    public IExtensionPoint getExtensionPoint(String elementName, String xpt) {
        this.access.enterRead();
        try {
            ExtensionPointHandle extensionPointHandle = this.registryObjects.getExtensionPointHandle(String.valueOf(elementName) + '.' + xpt);
            Object var3_4 = null;
            this.access.exitRead();
            return extensionPointHandle;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtensionPoint[] getExtensionPoints() {
        this.access.enterRead();
        try {
            IExtensionPoint[] iExtensionPointArray = this.registryObjects.getExtensionPointsHandles();
            Object var1_2 = null;
            this.access.exitRead();
            return iExtensionPointArray;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtensionPoint[] getExtensionPoints(String namespace) {
        this.access.enterRead();
        try {
            Bundle[] correspondingBundles = this.findAllBundles(namespace);
            IExtensionPoint[] result = ExtensionPointHandle.EMPTY_ARRAY;
            int i = 0;
            while (i < correspondingBundles.length) {
                result = (IExtensionPoint[])ExtensionRegistry.concatArrays(result, this.registryObjects.getHandles(this.registryObjects.getExtensionPointsFrom(correspondingBundles[i].getBundleId()), (byte)3));
                ++i;
            }
            IExtensionPoint[] iExtensionPointArray = result;
            Object var5_6 = null;
            this.access.exitRead();
            return iExtensionPointArray;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    private Bundle[] findAllBundles(String namespace) {
        Bundle correspondingHost = Platform.getBundle(namespace);
        if (correspondingHost == null) {
            return new Bundle[0];
        }
        Bundle[] fragments = Platform.getFragments(correspondingHost);
        if (fragments == null) {
            return new Bundle[]{correspondingHost};
        }
        Bundle[] result = new Bundle[fragments.length + 1];
        System.arraycopy(fragments, 0, result, 0, fragments.length);
        result[fragments.length] = correspondingHost;
        return result;
    }

    public IExtension[] getExtensions(String namespace) {
        ArrayList<Handle> tmp;
        block6: {
            this.access.enterRead();
            try {
                Bundle[] correspondingBundles = this.findAllBundles(namespace);
                tmp = new ArrayList<Handle>();
                int i = 0;
                while (i < correspondingBundles.length) {
                    Extension[] exts = (Extension[])this.registryObjects.getObjects(this.registryObjects.getExtensionsFrom(correspondingBundles[i].getBundleId()), (byte)2);
                    int j = 0;
                    while (j < exts.length) {
                        if (this.registryObjects.getExtensionPointObject(exts[j].getExtensionPointIdentifier()) != null) {
                            tmp.add(this.registryObjects.getHandle(exts[j].getObjectId(), (byte)2));
                        }
                        ++j;
                    }
                    ++i;
                }
                if (tmp.size() != 0) break block6;
                IExtension[] iExtensionArray = ExtensionHandle.EMPTY_ARRAY;
                Object var7_10 = null;
                this.access.exitRead();
                return iExtensionArray;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.access.exitRead();
                throw throwable;
            }
        }
        IExtension[] result = new IExtension[tmp.size()];
        IExtension[] iExtensionArray = tmp.toArray(result);
        Object var7_11 = null;
        this.access.exitRead();
        return iExtensionArray;
    }

    public String[] getNamespaces() {
        this.access.enterRead();
        try {
            Set namespaces = this.registryObjects.getNamespaces();
            String[] result = new String[namespaces.size()];
            String[] stringArray = namespaces.toArray(result);
            Object var3_4 = null;
            this.access.exitRead();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    boolean hasNamespace(long name) {
        this.access.enterRead();
        try {
            boolean bl = this.registryObjects.hasContribution(name);
            Object var3_3 = null;
            this.access.exitRead();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    private void link(ExtensionPoint extPoint, int[] extensions) {
        extPoint.setRawChildren(extensions);
        this.registryObjects.add(extPoint, true);
    }

    private String recordChange(ExtensionPoint extPoint, int extension, int kind) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        ExtensionDelta extensionDelta = new ExtensionDelta();
        extensionDelta.setExtension(extension);
        extensionDelta.setExtensionPoint(extPoint.getObjectId());
        extensionDelta.setKind(kind);
        this.getDelta(extPoint.getNamespace()).addExtensionDelta(extensionDelta);
        return extPoint.getNamespace();
    }

    private String recordChange(ExtensionPoint extPoint, int[] extensions, int kind) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        if (extensions == null || extensions.length == 0) {
            return null;
        }
        RegistryDelta pluginDelta = this.getDelta(extPoint.getNamespace());
        int i = 0;
        while (i < extensions.length) {
            ExtensionDelta extensionDelta = new ExtensionDelta();
            extensionDelta.setExtension(extensions[i]);
            extensionDelta.setExtensionPoint(extPoint.getObjectId());
            extensionDelta.setKind(kind);
            pluginDelta.addExtensionDelta(extensionDelta);
            ++i;
        }
        return extPoint.getNamespace();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(long removedBundleId) {
        this.access.enterWrite();
        try {
            this.basicRemove(removedBundleId);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.access.exitWrite();
            return;
        }
    }

    private String removeExtension(int extensionId) {
        Extension extension = (Extension)this.registryObjects.getObject(extensionId, (byte)2);
        String xptName = extension.getExtensionPointIdentifier();
        ExtensionPoint extPoint = this.registryObjects.getExtensionPointObject(xptName);
        if (extPoint == null) {
            this.registryObjects.removeOrphan(xptName, extensionId);
            return null;
        }
        int[] existingExtensions = extPoint.getRawChildren();
        int[] newExtensions = RegistryObjectManager.EMPTY_INT_ARRAY;
        if (existingExtensions.length > 1) {
            if (existingExtensions.length == 1) {
                newExtensions = RegistryObjectManager.EMPTY_INT_ARRAY;
            }
            newExtensions = new int[existingExtensions.length - 1];
            int i = 0;
            int j = 0;
            while (i < existingExtensions.length) {
                if (existingExtensions[i] != extension.getObjectId()) {
                    newExtensions[j++] = existingExtensions[i];
                }
                ++i;
            }
        }
        this.link(extPoint, newExtensions);
        return this.recordChange(extPoint, extension.getObjectId(), 2);
    }

    private String removeExtensionPoint(int extPoint) {
        ExtensionPoint extensionPoint = (ExtensionPoint)this.registryObjects.getObject(extPoint, (byte)3);
        int[] existingExtensions = extensionPoint.getRawChildren();
        if (existingExtensions == null || existingExtensions.length == 0) {
            return null;
        }
        this.registryObjects.addOrphans(extensionPoint.getUniqueIdentifier(), existingExtensions);
        this.link(extensionPoint, RegistryObjectManager.EMPTY_INT_ARRAY);
        return this.recordChange(extensionPoint, existingExtensions, 2);
    }

    private Set removeExtensionsAndExtensionPoints(long bundleId) {
        HashSet<String> affectedNamespaces = new HashSet<String>();
        int[] extensions = this.registryObjects.getExtensionsFrom(bundleId);
        int i = 0;
        while (i < extensions.length) {
            String namespace = this.removeExtension(extensions[i]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i;
        }
        int[] extPoints = this.registryObjects.getExtensionPointsFrom(bundleId);
        int i2 = 0;
        while (i2 < extPoints.length) {
            String namespace = this.removeExtensionPoint(extPoints[i2]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i2;
        }
        return affectedNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryChangeListener(IRegistryChangeListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.remove(new ListenerInfo(listener, null));
        }
    }

    public ExtensionRegistry() {
        String debugOption;
        boolean fromCache = false;
        this.registryObjects = new RegistryObjectManager();
        if (!"true".equals(System.getProperty("eclipse.noRegistryCache"))) {
            long start = 0L;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            File cacheFile = null;
            try {
                this.currentFileManager = InternalPlatform.getDefault().getRuntimeFileManager();
                cacheFile = this.currentFileManager.lookup(".table", false);
            }
            catch (IOException iOException) {}
            if (cacheFile == null || !cacheFile.isFile()) {
                Location currentLocation = Platform.getConfigurationLocation();
                Location parentLocation = null;
                if (currentLocation != null && (parentLocation = currentLocation.getParentLocation()) != null) {
                    try {
                        this.currentFileManager = new FileManager(new File(String.valueOf(parentLocation.getURL().getFile()) + '/' + "org.eclipse.core.runtime"), null, true);
                        this.currentFileManager.open(false);
                        cacheFile = this.currentFileManager.lookup(".table", false);
                    }
                    catch (IOException iOException) {}
                }
            }
            if (cacheFile != null && cacheFile.isFile()) {
                TableReader.setTableFile(cacheFile);
                try {
                    TableReader.setExtraDataFile(this.currentFileManager.lookup(".extraData", false));
                    TableReader.setMainDataFile(this.currentFileManager.lookup(".mainData", false));
                    TableReader.setContributionsFile(this.currentFileManager.lookup(".contributions", false));
                    TableReader.setOrphansFile(this.currentFileManager.lookup(".orphans", false));
                    fromCache = this.registryObjects.init(this.computeRegistryStamp());
                }
                catch (IOException iOException) {}
            }
            if (InternalPlatform.DEBUG && fromCache) {
                System.out.println("Reading registry cache: " + (System.currentTimeMillis() - start));
            }
            if (InternalPlatform.DEBUG_REGISTRY) {
                if (!fromCache) {
                    System.out.println("Reloading registry from manifest files...");
                } else {
                    System.out.println("Using registry cache...");
                }
            }
        }
        boolean bl = DEBUG = (debugOption = InternalPlatform.getDefault().getOption(OPTION_DEBUG_EVENTS_EXTENSION)) == null ? false : debugOption.equalsIgnoreCase("true");
        if (DEBUG) {
            this.addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent event) {
                    System.out.println(event);
                }
            });
        }
        this.pluginBundleListener = new EclipseBundleListener(this);
        InternalPlatform.getDefault().getBundleContext().addBundleListener((BundleListener)this.pluginBundleListener);
        if (!fromCache) {
            this.pluginBundleListener.processBundles(InternalPlatform.getDefault().getBundleContext().getBundles());
        }
        BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        bundleContext.registerService(clazz.getName(), (Object)this, new Hashtable());
    }

    public void stop() {
        InternalPlatform.getDefault().getBundleContext().removeBundleListener((BundleListener)this.pluginBundleListener);
        if (!this.registryObjects.isDirty()) {
            return;
        }
        if (this.currentFileManager == null) {
            return;
        }
        if (this.currentFileManager.isReadOnly()) {
            if (this.currentFileManager != InternalPlatform.getDefault().getRuntimeFileManager()) {
                this.currentFileManager.close();
            }
            return;
        }
        File tableFile = null;
        File mainFile = null;
        File extraFile = null;
        File contributionsFile = null;
        File orphansFile = null;
        try {
            this.currentFileManager.lookup(".table", true);
            this.currentFileManager.lookup(".mainData", true);
            this.currentFileManager.lookup(".extraData", true);
            this.currentFileManager.lookup(".contributions", true);
            this.currentFileManager.lookup(".orphans", true);
            tableFile = File.createTempFile(".table", ".new", this.currentFileManager.getBase());
            mainFile = File.createTempFile(".mainData", ".new", this.currentFileManager.getBase());
            extraFile = File.createTempFile(".extraData", ".new", this.currentFileManager.getBase());
            contributionsFile = File.createTempFile(".contributions", ".new", this.currentFileManager.getBase());
            orphansFile = File.createTempFile(".orphans", ".new", this.currentFileManager.getBase());
            TableWriter.setTableFile(tableFile);
            TableWriter.setExtraDataFile(extraFile);
            TableWriter.setMainDataFile(mainFile);
            TableWriter.setContributionsFile(contributionsFile);
            TableWriter.setOrphansFile(orphansFile);
        }
        catch (IOException iOException) {
            return;
        }
        try {
            if (new TableWriter().saveCache(this.registryObjects, this.computeRegistryStamp())) {
                this.currentFileManager.update(new String[]{".table", ".mainData", ".extraData", ".contributions", ".orphans"}, new String[]{tableFile.getName(), mainFile.getName(), extraFile.getName(), contributionsFile.getName(), orphansFile.getName()});
            }
        }
        catch (IOException iOException) {}
        if (this.currentFileManager != InternalPlatform.getDefault().getRuntimeFileManager()) {
            this.currentFileManager.close();
        }
    }

    public void clearRegistryCache() {
        String[] keys = new String[]{".table", ".mainData", ".extraData", ".contributions", ".orphans"};
        int i = 0;
        while (i < keys.length) {
            try {
                this.currentFileManager.remove(keys[i]);
            }
            catch (IOException e) {
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 4, Messages.meta_registryCacheReadProblems, e));
            }
            ++i;
        }
    }

    private long computeRegistryStamp() {
        if (!"true".equalsIgnoreCase(System.getProperty("osgi.checkConfiguration"))) {
            return 0L;
        }
        Bundle[] allBundles = InternalPlatform.getDefault().getBundleContext().getBundles();
        long result = 0L;
        int i = 0;
        while (i < allBundles.length) {
            URL pluginManifest = allBundles[i].getEntry("plugin.xml");
            if (pluginManifest == null) {
                pluginManifest = allBundles[i].getEntry("fragment.xml");
            }
            if (pluginManifest != null) {
                try {
                    URLConnection connection = pluginManifest.openConnection();
                    result ^= connection.getLastModified() + allBundles[i].getBundleId();
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            ++i;
        }
        return result;
    }

    private static final class ExtensionEventDispatcherJob
    extends Job {
        private static final ISchedulingRule EXTENSION_EVENT_RULE = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
        private Map deltas;
        private Object[] listenerInfos;

        public ExtensionEventDispatcherJob(Object[] listenerInfos, Map deltas) {
            super("Registry event dispatcher");
            this.setSystem(true);
            this.listenerInfos = listenerInfos;
            this.deltas = deltas;
            this.setRule(EXTENSION_EVENT_RULE);
        }

        public IStatus run(IProgressMonitor monitor) {
            MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 0, Messages.plugin_eventListenerError, null);
            int i = 0;
            while (i < this.listenerInfos.length) {
                ListenerInfo listenerInfo = (ListenerInfo)this.listenerInfos[i];
                if (listenerInfo.filter == null || this.deltas.containsKey(listenerInfo.filter)) {
                    try {
                        listenerInfo.listener.registryChanged(new RegistryChangeEvent(this.deltas, listenerInfo.filter));
                    }
                    catch (RuntimeException re) {
                        String message = re.getMessage() == null ? "" : re.getMessage();
                        result.add(new Status(4, "org.eclipse.core.runtime", 0, message, re));
                    }
                }
                ++i;
            }
            Iterator iter = this.deltas.values().iterator();
            while (iter.hasNext()) {
                ((RegistryDelta)iter.next()).getObjectManager().close();
            }
            return result;
        }
    }

    class ListenerInfo {
        String filter;
        IRegistryChangeListener listener;

        public ListenerInfo(IRegistryChangeListener listener, String filter) {
            this.listener = listener;
            this.filter = filter;
        }

        public boolean equals(Object another) {
            return another instanceof ListenerInfo && ((ListenerInfo)another).listener == this.listener;
        }
    }
}

