/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.Iterator;
import java.util.LinkedList;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.SimpleClassLoadHelper;
import org.quartz.simpl.ThreadContextClassLoadHelper;
import org.quartz.spi.ClassLoadHelper;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private LinkedList loadHelpers;
    private ClassLoadHelper bestCandidate;

    public void initialize() {
        this.loadHelpers = new LinkedList();
        this.loadHelpers.add(new SimpleClassLoadHelper());
        this.loadHelpers.add(new ThreadContextClassLoadHelper());
        this.loadHelpers.add(new InitThreadContextClassLoadHelper());
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext()) {
            ClassLoadHelper loadHelper = (ClassLoadHelper)iter.next();
            loadHelper.initialize();
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        ClassNotFoundException cnfe = null;
        Class clazz = null;
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext()) {
            loadHelper = (ClassLoadHelper)iter.next();
            try {
                clazz = loadHelper.loadClass(name);
                break;
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        if (clazz == null) {
            throw cnfe;
        }
        this.bestCandidate = loadHelper;
        return clazz;
    }
}

