/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol;

import java.util.Hashtable;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.clustercontrol.performanceMGR.ejb.session.CollectorRunController;
import com.clustercontrol.performanceMGR.ejb.session.CollectorRunControllerHome;



/**
 * 一括制御で使う定周期実行をQuartzに設定するクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class PerformanceSetup {
    public static final String QUARTZ_NAME = "Quartz";
    
    /**
     * メインメソッド<BR>
     * 
     * @param args
     */
    public static void main(String[] args) {
        PerformanceSetup setup = new PerformanceSetup();
        try {
            setup.setup(args);
        } catch (Exception e) {
        	e.printStackTrace();
        }
    }

    /**
     * Quartzへ登録を行います。<BR>
     * @param args
     */
    public void setup(String[] args) throws Exception {
        if(args.length != 2 && args.length != 3){
            return;
        }
        
        //QuartzのSchedulerをルックアップ
        InitialContext context = getContext("jnp://" + args[1]);
        CollectorRunControllerHome home = 
            (CollectorRunControllerHome)context.lookup(CollectorRunControllerHome.JNDI_NAME);
        
        CollectorRunController collectorRunController = home.create();
         
        
        if(args[0].compareTo("add") == 0){
        	collectorRunController.addQuartz(args[2]);
        }
        else if(args[0].compareTo("del") == 0){
        	collectorRunController.deleteQuartz();
        }
    }
    
    /**
     * InitialContextを取得します。<BR>
     * 
     * @return
     * @throws NamingException
     */
    private InitialContext getContext(String url) throws NamingException {
        Hashtable props = new Hashtable();
        
        props.put(InitialContext.INITIAL_CONTEXT_FACTORY, 
                "org.jnp.interfaces.NamingContextFactory");
        props.put(InitialContext.PROVIDER_URL, 
                url);

        InitialContext initialContext = new InitialContext(props);
        return initialContext;
    }
}
