/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.port.bean;

import com.clustercontrol.bean.PortRunCountConstant;
import com.clustercontrol.bean.PortRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;

/**
 * port監視情報クラスです。
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class MonitorPortInfo extends MonitorCheckInfo {

	/** ポート番号 */
	protected java.lang.Integer portNo = 80;

	/** リトライ回数（回） */
	protected java.lang.Integer runCount = Integer.valueOf(PortRunCountConstant.TYPE_COUNT_01);

	/** リトライ間隔（ミリ秒） */
	protected java.lang.Integer runInterval = Integer.valueOf(PortRunIntervalConstant.TYPE_SEC_01);

	/** タイムアウト（ミリ秒） */
	protected java.lang.Integer timeout = 1000;

	/** 各サービスの監視を実装したクラス名 */
	protected java.lang.String serviceId;

	public MonitorPortInfo() {
	}

	// ポート番号
	public java.lang.Integer getPortNo() {
		return this.portNo;
	}

	public void setPortNo(java.lang.Integer portNo) {
		this.portNo = portNo;
	}

	// 各サービスの監視を実装したクラス名
	public java.lang.String getServiceId() {
		return this.serviceId;
	}

	public void setServiceId(String serviceId) {
		this.serviceId = serviceId;
	}

	public java.lang.Integer getRunCount() {
		return this.runCount;
	}

	public void setRunCount(java.lang.Integer runCount) {
		this.runCount = runCount;
	}

	public java.lang.Integer getRunInterval() {
		return this.runInterval;
	}

	public void setRunInterval(java.lang.Integer runInterval) {
		this.runInterval = runInterval;
	}

	public java.lang.Integer getTimeout() {
		return this.timeout;
	}

	public void setTimeout(java.lang.Integer timeout) {
		this.timeout = timeout;
	}
}
