/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoHome;

/**
 * JNDI経由でEJBインスタンスを取得するクラス
 *
 */
public class JNDIConnectionManager extends com.clustercontrol.commons.util.JNDIConnectionManager {
	
	/**
	 * CollectorクラスのHomeインタフェースを取得する。
	 * @return CollectorクラスのHomeインタフェース
	 * @throws NamingException
	 */
	public static CollectorHome getCollectorHome() throws NamingException {
		Object obj = null;
		InitialContext initialContext = null;
		
		// 可用性対応 取得できるまで10回を上限にリトライする
		for(int i=0; i<10; i++){
			try {
				initialContext = getInitialContext();
				
				try {
					obj = initialContext.lookup(CollectorHome.JNDI_NAME);
				} catch (NamingException e) {
				}
			} finally {
				initialContext.close();
				
				if(obj != null){
					return (CollectorHome)PortableRemoteObject.narrow(obj, CollectorHome.class);
				} else {
					// 10秒待つ
					try {
						Thread.sleep(10000);
					} catch (InterruptedException e1) {
					}
				}
			}
		}
		
		throw new NamingException();
	}
	
	/**
	 * MonitorPerfInfoクラスのHomeインタフェースを取得する。
	 * 
	 * @return MonitorPerfInfoクラスのHomeインタフェース
	 * @throws NamingException
	 */
	public static MonitorPerfInfoHome getMonitorPerfInfo() throws NamingException {
		InitialContext initialContext = getInitialContext();
		
		try {
			Object obj = initialContext.lookup(MonitorPerfInfoHome.JNDI_NAME);
			return (MonitorPerfInfoHome)PortableRemoteObject.narrow(obj, MonitorPerfInfoHome.class);
		} finally {
			initialContext.close();
		}
	}
}
