/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;


/**
 * 各ファシリティの親子関係を保持するクラス<p>
 * 
 * DBに対応するテーブルが存在し、DAOへの登録、読み出しのオブジェクトとして
 * 用いる
 * 
 * @version 1.0
 * @since 1.0
 */
public class ScopeRelationData {
	
	private String collectorID;
	private String facilityID;
	private String parentFacilityID;
	
	
	/**
	 * コンストラクター
	 *
	 */
	public ScopeRelationData()
	{
		
		this.collectorID = null;
		this.facilityID = null;
		this.parentFacilityID = null;
		
	}
	/**
	 * コンストラクター
	 * @param collectorID
	 */
	public ScopeRelationData(String collectorID) {
		super();
		this.collectorID = collectorID;
	}
	
	/**
	 * コンストラクター
	 * @param collectorID
	 * @param facilityID
	 * @param parentFacilityID
	 */
	public ScopeRelationData(String collectorID, String facilityID,
			String parentFacilityID) {
		super();
		this.collectorID = collectorID;
		this.facilityID = facilityID;
		this.parentFacilityID = parentFacilityID;
	}
	/**
	 * 収集IDを取得します。
	 * @return collectorID 収集ID
	 */
	public String getCollectorID() {
		return collectorID;
	}
	/**
	 * 収集IDを設定します。
	 * @param collectorID 収集ID
	 */
	public void setCollectorID(String collectorID) {
		this.collectorID = collectorID;
	}
	/**
	 * ファシリティIDを取得します。
	 * @return facilityID ファシリティID
	 */
	public String getFacilityID() {
		return facilityID;
	}
	/**
	 * ファシリティIDを設定します。
	 * @param facilityID ファシリティID
	 */
	public void setFacilityID(String facilityID) {
		this.facilityID = facilityID;
	}
	/**
	 * このファシリティの親となるファシリティのIDを取得します。
	 * @return parentFacilityID 親のファシリティID
	 */
	public String getParentFacilityID() {
		return parentFacilityID;
	}
	/**
	 * このファシリティの親となるファシリティのIDを設定します。
	 * @param parentFacilityID 親のファシリティID
	 */
	public void setParentFacilityID(String parentFacilityID) {
		this.parentFacilityID = parentFacilityID;
	}
}
