/*
Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
package com.clustercontrol.performanceMGR.bean;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performanceMGR.ejb.bmp.CollectorLocalHome;

/**
 * Quartz関連定数クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class QuartzConstant {
	private static Log m_log = LogFactory.getLog( QuartzConstant.class );
	
	public static final String GROUP_COLLECT  = "PERF_COLLECT";
	public static final String GROUP_MONITOR  = "PERF_MONITOR";
	public static final String JNDI_NAME = CollectorLocalHome.JNDI_NAME;
	public static final String QUARTZ_NAME = getQuartzName();
	//public static final String JNDI_NAME_PERF = CollectorRunManagementHome.JNDI_NAME;
	public static final String JNDI_NAME_PERF_MNG ="CollectorRunController";
	public static final String METHOD_NAME_PERF_MNG = "managePresavePeriod";
	
	/**
	 * 性能管理機能で利用するQuartzスケジューラへ参照可能なJNDI名を返す。
	 * 
	 * @return JNDI名
	 */
	public static String getQuartzName() {
		// 性能値算出用設定ファイルを読み込む
	    Properties properties = new Properties();
		
		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf" + File.separator + "performance.properties";
			
			// プロパティファイルからキーと値のリストを読み込みます
			properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
			// エラー処理
			m_log.error(e.getMessage(), e);
		}
		
		return properties.getProperty("QuartzJndiName");
	}
}
