/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * システム通知イベント情報のCMP Entity Bean
 * 
 * @ejb.bean name="SystemNotifyEventInfo"
 *     jndi-name="SystemNotifyEventInfo"
 *     type="CMP"
 *     primkey-field="notifyId","priority"
 *     schema="SystemNotifyEventInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *        
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_system_notify_event_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM SystemNotifyEventInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoPK"
 *           
 */
public abstract class SystemNotifyEventInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * システム通知イベント情報を生成します。
	 * 
	 * @ejb.create-method
	 *  
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param eventNormalFlg イベント通知フラグ
	 * @param eventNormalState イベント通知状態
	 * @param eventInhibitionFlg イベント抑制フラグ
	 * @param eventInhibitionState イベント抑制状態
	 * @param mailFlg メールフラグ
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public SystemNotifyEventInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer eventNormalFlg,
			Integer eventNormalState,
			Integer eventInhibitionFlg,
			Integer eventInhibitionState,
			Integer mailFlg,
			String mailAddress) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setEventNormalFlg(eventNormalFlg);
		setEventNormalState(eventNormalState);
		setEventInhibitionFlg(eventInhibitionFlg);
		setEventInhibitionState(eventInhibitionState);
		setMailFlg(mailFlg);
		setMailAddress(mailAddress);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * イベント通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_normal_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getEventNormalFlg();
	
	/**
	 * イベント通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventNormalFlg イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setEventNormalFlg(Integer eventNormalFlg);
	
	/**
	 * イベント通知状態を返します。
	 * 
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_normal_state"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public abstract Integer getEventNormalState();
	
	/**
	 * イベント通知状態を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventNormalState イベント通知状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public abstract void setEventNormalState(Integer eventNormalState);
	
	/**
	 * イベント抑制フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント抑制フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getEventInhibitionFlg();
	
	/**
	 * イベント抑制フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventInhibitionFlg イベント抑制フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setEventInhibitionFlg(Integer eventInhibitionFlg);
	
	/**
	 * イベント抑制状態を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_inhibition_state"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント抑制状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public abstract Integer getEventInhibitionState();
	
	/**
	 * イベント抑制状態を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventInhibitionState  イベント抑制状態
	 * 
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public abstract void setEventInhibitionState(Integer eventInhibitionState);
	
	/**
	 * メールフラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return メールフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getMailFlg();
	
	/**
	 * メールフラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailFlg メールフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setMailFlg(Integer mailFlg);
	
	/**
	 * メールアドレスを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_address"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メールアドレス（セミコロン区切り）
	 */
	public abstract String getMailAddress();
	
	/**
	 * メールアドレスを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 */
	public abstract void setMailAddress(String mailAddress);
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * システム通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="SystemNotifyInfo-SystemNotifyEventInfo"
	 * role-name="SystemNotifyEventInfo-SystemNotifyInfo(multi)"
	 * cascade-delete="yes"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * 
	 * @return システム通知情報
	 */
	public abstract SystemNotifyInfoLocal getSystemNotifyInfo();
	
	/**
	 * システム通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo システム通知情報
	 */
	public abstract void setSystemNotifyInfo(SystemNotifyInfoLocal notifyInfo);
}
