/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 通知情報を変更するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class ModifyNotify {

    /**
     * 通知情報を変更します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @param info 変更対象の通知情報
	 * @return 変更に成功した場合、<code> true </code>
	 * 
	 * @see com.clustercontrol.notify.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.ejb.session.NotifyController
	 * @see com.clustercontrol.notify.ejb.session.NotifyControllerBean#modifyNotify(com.clustercontrol.notify.bean.NotifyInfo)
     */
    public boolean modify(NotifyInfo info) {
    	
        NotifyController notify = EjbConnectionManager.getConnectionManager().getNotifyController();

        boolean result = false;
        String[] args = { info.getNotifyId() };
        try {
        	result = notify.modifyNotify(info);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (RemoveException e) {
        } catch (NamingException e) {
        } catch (JMSException e) {
        }
		
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.notify.3", args));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.notify.4", args));
		}
    	
    	return result;
    }
}