/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.bean;

import java.sql.Timestamp;
import java.util.ArrayList;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * 監視情報を保持するクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class MonitorInfo
extends Object
implements java.io.Serializable
{
	private static final long serialVersionUID = 8016002145318844928L;
	
	/** アプリケーション。 */
	protected String m_application;
	
	/** カレンダID。 */
	protected String m_calendarId;
	
	/** 説明。 */
	protected String m_description;
	
	/** 判定ID（未使用）。 */
	protected String m_determinationId;
	
	/** スコープ。 */
	protected String m_scope;
	
	/** ファシリティID。 */
	protected String m_facilityId;
	
	/** 
	 * 値失敗時の重要度。
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	protected int m_failurePriority = PriorityConstant.TYPE_UNKNOWN;
	
	/**
	 * 監視単位。
	 * 
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 */
	protected int m_monitorBlock = MonitorBlockConstant.TYPE_ALL;
	
	/** 監視項目ID。 */
	protected String m_monitorId;
	
	/** 監視対象ID。 */
	protected String m_monitorTypeId;
	
	/** 通知ID。 */
	protected String m_notifyId;
	
	/**
	 * 実行間隔（秒）。
	 *
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	protected int m_runInterval = RunIntervalConstant.TYPE_MIN_01;
	
	/** 作成日時。 */
	protected Timestamp m_regDate;
	
	/** 最終変更日時。 */
	protected Timestamp m_updateDate;
	
	/**
	 * 有効/無効。
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	protected int m_valid = ValidConstant.TYPE_VALID;
	
	/** 
	 * 判定情報。
	 * {@link com.clustercontrol.monitor.run.bean.MonitorJudgementInfo}のリスト。
	 */
	protected ArrayList m_judgementInfo;
	
	/** チェック条件情報。 */
	protected MonitorCheckInfo m_checkInfo;
	
	/**
	 * 監視判定タイプ。
	 * 
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 */
	protected int m_monitorType;
	
	/** タイムアウト。 */
	protected int m_timeout;
	
	/**
	 * ジョブ実行。
	 *
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	protected int m_jobRun = YesNoConstant.TYPE_NO;
	
	/** 値取得の失敗時のメッセージID（未使用）。 */
	protected String m_failureMessageId;
	
	/** 値取得の失敗時のメッセージ（未使用）。 */
	protected String m_failureMessage;
	
	/**
	 * 値取得の失敗時のジョブ実行（未使用）。
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	protected int m_failureJobRun = YesNoConstant.TYPE_NO;
	
	/** 値取得の失敗時のジョブID（未使用）。 */
	protected String m_failureJobId;
	
	/** 
	 * 値取得の失敗時のジョブの通知抑制と連動（未使用）。
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	protected int m_failureJobInhibitionFlg = YesNoConstant.TYPE_NO;
	
	/** 
	 * 値取得の失敗時のジョブ呼出の失敗時の重要度（未使用）。
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	protected int m_failureJobFailurePriority = PriorityConstant.TYPE_UNKNOWN;
	
	/** 新規作成ユーザ。 */
	protected String m_regUser;
	
	/** 最終変更ユーザ。 */
	protected String m_updateUser;
	
	/**
	 * コンストラクタ。 
	 */
	public MonitorInfo() {
		super();
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param application アプリケーション
	 * @param calendarId カレンダID
	 * @param description 説明
	 * @param determinationId 判定ID（未使用）
	 * @param scope スコープ
	 * @param facilityId ファシリティID
	 * @param failurePriority 値取得の失敗時の重要度
	 * @param jobRun ジョブ実行
	 * @param monitorBlock 監視単位
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視対象ID
	 * @param monitorType 監視種別
	 * @param notifyId 通知ID
	 * @param regDate 作成日時
	 * @param regUser 新規作成ユーザ
	 * @param runInterval 実行間隔（秒）
	 * @param timeout タイムアウト
	 * @param failureMessageId 値取得の失敗時のメッセージID（未使用）
	 * @param failureMessage  値取得の失敗時のメッセージ（未使用）
	 * @param failureJobRun 値取得の失敗時のジョブ実行（未使用）
	 * @param failureJobId 値取得の失敗時のジョブID（未使用）
	 * @param failureJobInhibitionFlg 値取得の失敗時の通知抑制と連動（未使用）
	 * @param failureJobFailurePriority 値取得の失敗時のジョブ呼出の失敗時の重要度（未使用）
	 * @param updateDate 最終変更日時
	 * @param updateUser 最終変更ユーザ
	 * @param valid 有効/無効
	 * @param judgementInfo 判定情報
	 * @param checkInfo チェック条件情報
	 */
	public MonitorInfo(
			String application,
			String calendarId,
			String description,
			String determinationId,
			String scope,
			String facilityId,
			int failurePriority,
			int jobRun,
			int monitorBlock,
			String monitorId,
			String monitorTypeId,
			int monitorType,
			String notifyId,
			Timestamp regDate,
			String regUser,
			int runInterval,
			int timeout,
			String failureMessageId, 
			String failureMessage,
			Integer failureJobRun,
			String failureJobId,
			Integer failureJobInhibitionFlg,
			Integer failureJobFailurePriority,
			Timestamp updateDate,
			String updateUser,
			int valid,
			ArrayList judgementInfo,
			MonitorCheckInfo checkInfo) {
		
		setApplication(application);
		setCalendarId(calendarId);
		setDescription(description);
		setDeterminationId(determinationId);
		setScope(scope);
		setFacilityId(facilityId);
		setFailurePriority(failurePriority);
		setJobRun(jobRun);
		setMonitorBlock(monitorBlock);
		setMonitorId(monitorId);
		setMonitorTypeId(monitorTypeId);
		setMonitorType(monitorType);
		setNotifyId(notifyId);
		setRegDate(regDate);
		setRegUser(regUser);
		setRunInterval(runInterval);
		setTimeout(timeout);
		setFailureMessageId(failureMessageId);
		setFailureMessage(failureMessage);
		setFailureJobRun(failureJobRun);
		setFailureJobId(failureJobId);
		setFailureJobInhibitionFlg(failureJobInhibitionFlg);
		setFailureJobFailurePriority(failureJobFailurePriority);
		setUpdateDate(updateDate);
		setUpdateUser(updateUser);
		setValid(valid);
		setJudgementInfo(judgementInfo);
		setCheckInfo(checkInfo);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の監視情報
	 */
	public MonitorInfo( MonitorInfo otherData ) {
		
		setApplication(otherData.getApplication());
		setCalendarId(otherData.getCalendarId());
		setDescription(otherData.getDescription());
		setDeterminationId(otherData.getDeterminationId());
		setScope(otherData.getScope());
		setFacilityId(otherData.getFacilityId());
		setFailurePriority(otherData.getFailurePriority());
		setJobRun(otherData.getJobRun());
		setMonitorBlock(otherData.getMonitorBlock());
		setMonitorId(otherData.getMonitorId());
		setMonitorTypeId(otherData.getMonitorTypeId());
		setMonitorType(otherData.getMonitorType());
		setNotifyId(otherData.getNotifyId());
		setRegDate(otherData.getRegDate());
		setRegUser(otherData.getRegUser());
		setRunInterval(otherData.getRunInterval());
		setFailureMessageId(otherData.getFailureMessageId());
		setFailureMessage(otherData.getFailureMessage());
		setFailureJobRun(otherData.getFailureJobRun());
		setFailureJobId(otherData.getFailureJobId());
		setFailureJobInhibitionFlg(otherData.getFailureJobInhibitionFlg());
		setFailureJobFailurePriority(otherData.getFailureJobFailurePriority());
		setUpdateDate(otherData.getUpdateDate());
		setUpdateUser(otherData.getUpdateUser());
		setValid(otherData.getValid());
		setJudgementInfo(otherData.getJudgementInfo());
		setCheckInfo(otherData.getCheckInfo());
	}
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @return アプリケーション
	 */
	public String getApplication(){
		return this.m_application;
	}
	
	/**
	 * アプリケーションを設定します。
	 * 
	 * @param application アプリケーション
	 */
	public void setApplication( String application ){
		this.m_application = application;
	}
	
	/**
	 * カレンダIDを返します。
	 * 
	 * @return カレンダID
	 */
	public String getCalendarId(){
		return this.m_calendarId;
	}
	
	/**
	 * カレンダIDを設定します。
	 * 
	 * @param calendarId カレンダID
	 */
	public void setCalendarId( String calendarId ){
		this.m_calendarId = calendarId;
	}
	
	/**
	 * 説明を返します。
	 * 
	 * @return 説明
	 */
	public String getDescription(){
		return this.m_description;
	}
	
	/**
	 * 説明を設定します。
	 * 
	 * @param description 説明
	 */
	public void setDescription( String description ){
		this.m_description = description;
	}
	
	/**
	 * 判定IDを返します（未使用）。
	 * 
	 * @return 判定ID
	 */
	public String getDeterminationId(){
		return this.m_determinationId;
	}
	
	/**
	 * 判定IDを設定します（未使用）。
	 * 
	 * @param determinationId 判定ID
	 */
	public void setDeterminationId( String determinationId ){
		this.m_determinationId = determinationId;
	}
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @return ファシリティID
	 */
	public String getFacilityId(){
		return this.m_facilityId;
	}
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @param facilityId ファシリティID
	 */
	public void setFacilityId( String facilityId ){
		this.m_facilityId = facilityId;
	}
	
	/**
	 * 値取得の失敗時の重要度を返します。
	 * 
	 * @return 値取得の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getFailurePriority(){
		return this.m_failurePriority;
	}
	
	/**
	 * 値取得の失敗時の重要度を設定します。
	 * 
	 * @param failurePriority 値取得の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setFailurePriority( int failurePriority ){
		this.m_failurePriority = failurePriority;
	}
	
	/**
	 * 監視単位を返します。
	 * 
	 * @return 監視単位
	 * 
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 */
	public int getMonitorBlock(){
		return this.m_monitorBlock;
	}
	
	/**
	 * 監視単位を設定します。
	 * 
	 * @param monitorBlock 監視単位
	 * 
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 */
	public void setMonitorBlock( int monitorBlock ){
		this.m_monitorBlock = monitorBlock;
	}
	
	/**
	 * 監視項目IDを返します。
	 * 
	 * @return 監視項目ID
	 */
	public String getMonitorId(){
		return this.m_monitorId;
	}
	
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @param monitorId 監視項目ID
	 */
	public void setMonitorId( String monitorId ){
		this.m_monitorId = monitorId;
	}
	
	/**
	 * 監視対象IDを返します。
	 * 
	 * @return 監視対象ID
	 */
	public String getMonitorTypeId(){
		return this.m_monitorTypeId;
	}
	
	/**
	 * 監視対象IDを設定します。
	 * 
	 * @param monitorTypeId 監視対象ID
	 */
	public void setMonitorTypeId( String monitorTypeId ){
		this.m_monitorTypeId = monitorTypeId;
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId(){
		return this.m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId( String notifyId ){
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 作成日時を返します。
	 * 
	 * @return regDate 作成日時
	 */
	public Timestamp getRegDate(){
		return this.m_regDate;
	}
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @param regDate 作成日時
	 */
	public void setRegDate( Timestamp regDate ){
		this.m_regDate = regDate;
	}
	
	/**
	 * 実行間隔を返します。
	 * 
	 * @return 実行間隔（秒）
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	public int getRunInterval(){
		return this.m_runInterval;
	}
	
	/**
	 * 実行間隔を設定します。
	 * 
	 * @param runInterval 実行間隔（秒）
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 */
	public void setRunInterval( int runInterval ){
		this.m_runInterval = runInterval;
	}
	
	/**
	 * スコープを返します。
	 * 
	 * @return スコープ
	 */
	public String getScope(){
		return m_scope;
	}
	
	/**
	 * スコープを設定します。
	 * 
	 * @param scope スコープ
	 */
	public void setScope(String scope) {
		this.m_scope = scope;
	}
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @return 最終変更日時
	 */
	public Timestamp getUpdateDate(){
		return this.m_updateDate;
	}
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @param updateDate 最終変更日時
	 */
	public void setUpdateDate( Timestamp updateDate ){
		this.m_updateDate = updateDate;
	}
	
	/**
	 * 有効/無効を返します。
	 * 
	 * @return 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public int getValid() {
		return m_valid;
	}
	
	/**
	 * 有効/無効を設定します。
	 * 
	 * @param valid 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setValid(int valid) {
		this.m_valid = valid;
	}
	
	/**
	 * 判定情報を返します。
	 * 
	 * @return 判定情報（{@link com.clustercontrol.monitor.run.bean.MonitorJudgementInfo}のリスト）
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorJudgementInfo
	 */
	public ArrayList getJudgementInfo() {
		return this.m_judgementInfo;
	}
	
	/**
	 * 判定情報を設定します。
	 * 
	 * @param judgementInfo 判定情報（{@link com.clustercontrol.monitor.run.bean.MonitorJudgementInfo}のリスト）
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorJudgementInfo
	 */
	public void setJudgementInfo(ArrayList judgementInfo) {
		this.m_judgementInfo = judgementInfo;
	}
	
	/**
	 * チェック条件情報を返します。
	 * 
	 * @return チェック条件情報
	 */
	public MonitorCheckInfo getCheckInfo() {
		return this.m_checkInfo;
	}
	
	/**
	 * チェック条件情報を設定します。
	 * 
	 * @param checkInfo チェック条件情報
	 */
	public void setCheckInfo(MonitorCheckInfo checkInfo) {
		this.m_checkInfo = checkInfo;
	}
	
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @return 新規作成ユーザ
	 */
	public String getRegUser() {
		return m_regUser;
	}
	
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @param user 新規作成ユーザ
	 */
	public void setRegUser(String user) {
		m_regUser = user;
	}
	
	/**
	 * 最終変更ユーザを返します。
	 * 
	 * @return 最終変更ユーザ
	 */
	public String getUpdateUser() {
		return m_updateUser;
	}
	
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @param user 最終変更ユーザ 
	 */
	public void setUpdateUser(String user) {
		m_updateUser = user;
	}
	
	/**
	 * ジョブ実行を返します。
	 * 
	 * @return ジョブ実行
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getJobRun() {
		return m_jobRun;
	}
	
	/**
	 * ジョブ実行を設定します。
	 * 
	 * @param run ジョブ実行
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setJobRun(int run) {
		m_jobRun = run;
	}
	
	/**
	 * 値取得の失敗時のジョブ呼出の失敗時の重要度を返します（未使用）。
	 * 
	 * @return 値取得の失敗時のジョブ呼出の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getFailureJobFailurePriority() {
		return m_failureJobFailurePriority;
	}
	
	/**
	 * 値取得の失敗時のジョブ呼出の失敗時の重要度を設定します（未使用）。
	 * 
	 * @param jobFailurePriority 値取得の失敗時のジョブ呼出の失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setFailureJobFailurePriority(int jobFailurePriority) {
		m_failureJobFailurePriority = jobFailurePriority;
	}
	
	/**
	 * 値取得の失敗時のジョブIDを返します（未使用）。
	 * 
	 * @return 値取得の失敗時のジョブID
	 */
	public String getFailureJobId() {
		return m_failureJobId;
	}
	
	/**
	 * 値取得の失敗時のジョブIDを設定します（未使用）。
	 * 
	 * @param jobId 値取得の失敗時のジョブID
	 */
	public void setFailureJobId(String jobId) {
		m_failureJobId = jobId;
	}
	
	/**
	 * 値取得の失敗時のジョブの通知抑制と連動を返します（未使用）。
	 * 
	 * @return 値取得の失敗時のジョブの通知抑制と連動
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getFailureJobInhibitionFlg() {
		return m_failureJobInhibitionFlg;
	}
	
	/**
	 * 値取得の失敗時のジョブの通知抑制と連動を設定します（未使用）。
	 * 
	 * @param jobInhibitionFlg 値取得の失敗時のジョブの通知抑制と連動
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setFailureJobInhibitionFlg(int jobInhibitionFlg) {
		m_failureJobInhibitionFlg = jobInhibitionFlg;
	}
	
	/**
	 * 値取得の失敗時のジョブ実行を返します（未使用）。
	 * 
	 * @return 値取得の失敗時のジョブ実行
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getFailureJobRun() {
		return m_failureJobRun;
	}
	
	/**
	 * 値取得の失敗時のジョブ実行を設定します（未使用）。
	 * 
	 * @param jobRun 値取得の失敗時のジョブ実行
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setFailureJobRun(int jobRun) {
		m_failureJobRun = jobRun;
	}
	
	/**
	 * 値取得の失敗時のメッセージを返します（未使用）。
	 * 
	 * @return 値取得の失敗時のメッセージ
	 */
	public String getFailureMessage() {
		return m_failureMessage;
	}
	
	/**
	 * 値取得の失敗時のメッセージを設定します（未使用）。
	 * 
	 * @param message 値取得の失敗時のメッセージ
	 */
	public void setFailureMessage(String message) {
		m_failureMessage = message;
	}
	
	/**
	 * 値取得の失敗時のメッセージIDを返します（未使用）。
	 * 
	 * @return 値取得の失敗時のメッセージID
	 */
	public String getFailureMessageId() {
		return m_failureMessageId;
	}
	
	/**
	 * 値取得の失敗時のメッセージIDを設定します（未使用）。
	 * 
	 * @param messageId 値取得の失敗時のメッセージID
	 */
	public void setFailureMessageId(String messageId) {
		m_failureMessageId = messageId;
	}
	
	/**
	 * 監視種別を返します。
	 * 
	 * @return 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public int getMonitorType() {
		return m_monitorType;
	}
	
	/**
	 * 監視種別を設定します。
	 * 
	 * @param type 監視種別
	 * 
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 */
	public void setMonitorType(int type) {
		m_monitorType = type;
	}
	
	/**
	 * タイムアウトを返します（未使用）。
	 * 
	 * @return タイムアウト
	 */
	public int getTimeout() {
		return m_timeout;
	}
	
	/**
	 * タイムアウトを設定します（未使用）。
	 * 
	 * @param timeout タイムアウト
	 */
	public void setTimeout(int timeout) {
		this.m_timeout = timeout;
	}
}
