/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.calendar.action.DeleteCalendarProperty;
import com.clustercontrol.calendar.bean.CalendarListTableDefine;
import com.clustercontrol.calendar.view.CalendarListView;
import com.clustercontrol.util.Messages;

/**
 * カレンダの削除を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarDeleteAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.CalendarDeleteAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // カレンダ一覧より、選択されているカレンダIDを取得

        CalendarListView view = (CalendarListView) this.viewPart
                .getAdapter(CalendarListView.class);

        StructuredSelection selection = (StructuredSelection) view
                .getListComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String) list.get(CalendarListTableDefine.CALENDAR_ID);
        }

        if (id != null) {
            // 確認ダイアログにて変更が選択された場合、削除処理を行う。
            String[] args = { id };
            if (MessageDialog.openConfirm(
        			null, 
        			Messages.getString("confirmed"), 
        			Messages.getString("message.calendar.7", args))) {

                if (new DeleteCalendarProperty().delete(id)) {
                    // 成功報告ダイアログを生成
                	MessageDialog.openInformation(
                			null, 
                			Messages.getString("successful"), 
                			Messages.getString("message.calendar.5"));
                } else {
                    // 失敗報告ダイアログを生成
                	MessageDialog.openError(
                			null, 
                			Messages.getString("failed"), 
                			Messages.getString("message.calendar.6"));
                }

                // ビューを更新
                view.update();
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}