/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationReference;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class DecorationScheduler {
    Map resultCache = new HashMap();
    List awaitingDecoration = new ArrayList();
    Set pendingUpdate = new HashSet();
    Map awaitingDecorationValues = new HashMap();
    DecoratorManager decoratorManager;
    boolean shutdown = false;
    Job decorationJob;
    UIJob updateJob;
    private Collection removedListeners = Collections.synchronizedSet(new HashSet());
    private Job clearJob;
    static int NEEDS_INIT = -1;

    DecorationScheduler(DecoratorManager manager) {
        this.decoratorManager = manager;
        this.createDecorationJob();
    }

    public String decorateWithText(String text, Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement);
        if (decoration == null) {
            return text;
        }
        return decoration.decorateWithText(text);
    }

    synchronized void queueForDecoration(Object element, Object adaptedElement, boolean forceUpdate, String undecoratedText) {
        if (this.awaitingDecorationValues.containsKey(element)) {
            if (forceUpdate) {
                DecorationReference reference = (DecorationReference)this.awaitingDecorationValues.get(element);
                reference.setForceUpdate(forceUpdate);
            }
        } else {
            DecorationReference reference = new DecorationReference(element, adaptedElement);
            reference.setForceUpdate(forceUpdate);
            reference.setUndecoratedText(undecoratedText);
            this.awaitingDecorationValues.put(element, reference);
            this.awaitingDecoration.add(element);
            if (this.shutdown) {
                return;
            }
            if (this.decorationJob.getState() == 1) {
                this.decorationJob.wakeUp();
            }
            this.decorationJob.schedule();
        }
    }

    public Image decorateWithOverlays(Image image, Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement);
        if (decoration == null) {
            return image;
        }
        return decoration.decorateWithOverlays(image, this.decoratorManager.getLightweightManager().getOverlayCache());
    }

    private DecorationResult getResult(Object element, Object adaptedElement) {
        if (element == null) {
            return null;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement, false, null);
            return null;
        }
        return decoration;
    }

    void decorated() {
        if (this.shutdown) {
            return;
        }
        if (this.updateJob == null) {
            this.updateJob = this.getUpdateJob();
            this.updateJob.setPriority(50);
        }
        this.updateJob.schedule(100L);
    }

    void shutdown() {
        this.shutdown = true;
    }

    synchronized DecorationReference nextElement() {
        if (this.shutdown || this.awaitingDecoration.isEmpty()) {
            return null;
        }
        Object element = this.awaitingDecoration.remove(0);
        return (DecorationReference)this.awaitingDecorationValues.remove(element);
    }

    private void createDecorationJob() {
        this.decorationJob = new Job(WorkbenchMessages.DecorationScheduler_CalculationJobName){

            /*
             * Unable to fully structure code
             */
            public IStatus run(IProgressMonitor monitor) {
                if (!DecorationScheduler.this.shutdown) ** GOTO lbl9
                return Status.CANCEL_STATUS;
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException v0) {
                        this.schedule();
                        return Status.CANCEL_STATUS;
                    }
lbl9:
                    // 2 sources

                    ** while (DecorationScheduler.this.updatesPending())
                }
lbl10:
                // 1 sources

                monitor.beginTask(WorkbenchMessages.DecorationScheduler_CalculatingTask, 100);
                monitor.worked(5);
                workCount = 5;
                while ((reference = DecorationScheduler.this.nextElement()) != null) {
                    if (workCount < 90) {
                        monitor.worked(1);
                        ++workCount;
                    }
                    cacheResult = new DecorationBuilder();
                    monitor.subTask(reference.getSubTask());
                    element = reference.getElement();
                    adapted = reference.getAdaptedElement();
                    elementIsCached = true;
                    adaptedResult = null;
                    elementIsCached = DecorationScheduler.this.resultCache.containsKey(element);
                    if (elementIsCached) {
                        DecorationScheduler.this.pendingUpdate.add(element);
                    }
                    if (adapted != null) {
                        adaptedResult = (DecorationResult)DecorationScheduler.this.resultCache.get(adapted);
                    }
                    if (!elementIsCached) {
                        if (adapted != null) {
                            if (adaptedResult == null) {
                                DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(adapted, cacheResult, true);
                                if (cacheResult.hasValue()) {
                                    adaptedResult = cacheResult.createResult();
                                }
                            } else {
                                cacheResult.applyResult(adaptedResult);
                                adaptedResult = null;
                            }
                        }
                        DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(element, cacheResult, false);
                        if (cacheResult.hasValue() || reference.shouldForceUpdate()) {
                            if (adaptedResult != null) {
                                DecorationScheduler.this.resultCache.put(adapted, adaptedResult);
                            }
                            DecorationScheduler.this.resultCache.put(element, cacheResult.createResult());
                            DecorationScheduler.this.pendingUpdate.add(element);
                        }
                    }
                    if (!DecorationScheduler.this.awaitingDecoration.isEmpty()) continue;
                    DecorationScheduler.this.decorated();
                }
                monitor.worked(100 - workCount);
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return DecoratorManager.FAMILY_DECORATE == family;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        this.decorationJob.setSystem(true);
        this.decorationJob.setPriority(50);
        this.decorationJob.schedule();
    }

    protected boolean updatesPending() {
        if (this.updateJob != null && this.updateJob.getState() != 0) {
            return true;
        }
        return this.clearJob != null && this.clearJob.getState() != 0;
    }

    void clearResults() {
        if (this.clearJob == null) {
            this.clearJob = this.getClearJob();
        }
        this.clearJob.schedule();
    }

    private Job getClearJob() {
        Job clear = new Job(WorkbenchMessages.DecorationScheduler_ClearResultsJob){

            protected IStatus run(IProgressMonitor monitor) {
                DecorationScheduler.this.resultCache.clear();
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        clear.setSystem(true);
        return clear;
    }

    private WorkbenchJob getUpdateJob() {
        WorkbenchJob job = new WorkbenchJob(WorkbenchMessages.DecorationScheduler_UpdateJobName){
            int currentIndex = NEEDS_INIT;
            LabelProviderChangedEvent labelProviderChangedEvent;
            ILabelProviderListener[] listeners;

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DecorationScheduler.this.shutdown) {
                    return Status.CANCEL_STATUS;
                }
                if (this.currentIndex == NEEDS_INIT) {
                    if (DecorationScheduler.this.pendingUpdate.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    this.setUpUpdates();
                }
                monitor.beginTask(WorkbenchMessages.DecorationScheduler_UpdatingTask, 10);
                monitor.worked(5);
                if (this.listeners.length == 0) {
                    return Status.OK_STATUS;
                }
                ILabelProviderListener listener = this.listeners[this.currentIndex];
                ++this.currentIndex;
                if (!DecorationScheduler.this.removedListeners.contains(listener)) {
                    DecorationScheduler.this.decoratorManager.fireListener(this.labelProviderChangedEvent, listener);
                }
                monitor.done();
                if (this.currentIndex >= this.listeners.length) {
                    if (DecorationScheduler.this.awaitingDecoration.isEmpty()) {
                        DecorationScheduler.this.resultCache.clear();
                    }
                    if (!DecorationScheduler.this.pendingUpdate.isEmpty()) {
                        DecorationScheduler.this.decorated();
                    }
                    this.currentIndex = NEEDS_INIT;
                    this.labelProviderChangedEvent = null;
                    DecorationScheduler.this.removedListeners.clear();
                } else {
                    this.schedule();
                }
                return Status.OK_STATUS;
            }

            private void setUpUpdates() {
                DecorationScheduler.this.removedListeners.clear();
                this.currentIndex = 0;
                Object[] elements = DecorationScheduler.this.pendingUpdate.toArray(new Object[DecorationScheduler.this.pendingUpdate.size()]);
                DecorationScheduler.this.pendingUpdate.clear();
                this.labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)DecorationScheduler.this.decoratorManager, elements);
                this.listeners = DecorationScheduler.this.decoratorManager.getListeners();
            }

            public boolean belongsTo(Object family) {
                return DecoratorManager.FAMILY_DECORATE == family;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        job.setSystem(true);
        return job;
    }

    public boolean isDecorationReady(Object element) {
        return this.resultCache.get(element) != null;
    }

    public Color getBackgroundColor(Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement);
        if (decoration == null) {
            return null;
        }
        return decoration.getBackgroundColor();
    }

    public Font getFont(Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement);
        if (decoration == null) {
            return null;
        }
        return decoration.getFont();
    }

    public Color getForegroundColor(Object element, Object adaptedElement) {
        DecorationResult decoration = this.getResult(element, adaptedElement);
        if (decoration == null) {
            return null;
        }
        return decoration.getForegroundColor();
    }

    public boolean processingUpdates() {
        return !this.pendingUpdate.isEmpty() && !this.awaitingDecoration.isEmpty();
    }

    void listenerRemoved(ILabelProviderListener listener) {
        if (this.updatesPending()) {
            this.removedListeners.add(listener);
        }
        if (!this.updatesPending()) {
            this.removedListeners.remove(listener);
        }
    }
}

