/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.factory;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class WeekdayProperty {
    public static final String WEEKDAY = "weekday";
    public static final String TIME_FROM = "timeFrom";
    public static final String TIME_TO = "timeTo";
    public static final String DESCRIPTION = "description";
    public static final String CREATE_TIME = "createTimestamp";
    public static final String CREATOR_NAME = "creatorName";
    public static final String MODIFIER_NAME = "ModifierName";
    public static final String MODIFY_TIME = "ModifyTime";

    public Property getProperty(String id, Integer weekday, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
        CalendarWeekdayInfoLocal info;
        Property property = this.getProperty(mode, locale);
        if (mode == 1 && (info = CalendarWeekdayInfoUtil.getLocalHome().findByPrimaryKey(new CalendarWeekdayInfoPK(id, weekday, new Time(from.getTime()), new Time(to.getTime())))) != null) {
            ArrayList propertyList = PropertyUtil.getProperty((Property)property, (String)WEEKDAY);
            ((Property)propertyList.get(0)).setValue((Object)DayOfWeekConstant.typeToString((int)info.getWeekday()));
            propertyList = PropertyUtil.getProperty((Property)property, (String)TIME_FROM);
            ((Property)propertyList.get(0)).setValue((Object)info.getTime_from());
            propertyList = PropertyUtil.getProperty((Property)property, (String)TIME_TO);
            ((Property)propertyList.get(0)).setValue((Object)info.getTime_to());
            propertyList = PropertyUtil.getProperty((Property)property, (String)DESCRIPTION);
            if (info.getDescription() != null && info.getDescription().compareTo("") != 0) {
                ((Property)propertyList.get(0)).setValue((Object)info.getDescription());
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)CREATOR_NAME);
            if (info.getReg_user() != null && info.getReg_user().compareTo("") != 0) {
                ((Property)propertyList.get(0)).setValue((Object)info.getReg_user());
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)CREATE_TIME);
            if (info.getReg_date() != null) {
                ((Property)propertyList.get(0)).setValue((Object)info.getReg_date());
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)MODIFIER_NAME);
            if (info.getUpdate_user() != null && info.getUpdate_user().compareTo("") != 0) {
                ((Property)propertyList.get(0)).setValue((Object)info.getUpdate_user());
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)MODIFY_TIME);
            if (info.getUpdate_date() != null) {
                ((Property)propertyList.get(0)).setValue((Object)info.getUpdate_date());
            }
        }
        return property;
    }

    public Property getProperty(int mode, Locale locale) {
        Property weekday = new Property(WEEKDAY, Messages.getString((String)WEEKDAY, (Locale)locale), "com.clustercontrol.composite.ComboPropertyDefine");
        Property timeFrom = new Property(TIME_FROM, Messages.getString((String)"timestamp", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ") " + Messages.getString((String)"timestamp.example", (Locale)locale), "com.clustercontrol.composite.TimePropertyDefine");
        Property timeTo = new Property(TIME_TO, Messages.getString((String)"timestamp", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ") " + Messages.getString((String)"timestamp.example", (Locale)locale), "com.clustercontrol.composite.TimePropertyDefine");
        Property description = new Property(DESCRIPTION, Messages.getString((String)DESCRIPTION, (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine", 256);
        Property createTime = new Property(CREATE_TIME, Messages.getString((String)"create.time", (Locale)locale), "com.clustercontrol.composite.DateTimePropertyDefine");
        Property creatorName = new Property(CREATOR_NAME, Messages.getString((String)"creator.name", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property modifyTime = new Property(MODIFY_TIME, Messages.getString((String)"update.time", (Locale)locale), "com.clustercontrol.composite.DateTimePropertyDefine");
        Property modifierName = new Property(MODIFIER_NAME, Messages.getString((String)"modifier.name", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Object[][] values = new Object[][]{{DayOfWeekConstant.STRING_SUNDAY, DayOfWeekConstant.STRING_MONDAY, DayOfWeekConstant.STRING_TUESDAY, DayOfWeekConstant.STRING_WEDNESDAY, DayOfWeekConstant.STRING_THURSDAY, DayOfWeekConstant.STRING_FRIDAY, DayOfWeekConstant.STRING_SATURDAY}, {DayOfWeekConstant.STRING_SUNDAY, DayOfWeekConstant.STRING_MONDAY, DayOfWeekConstant.STRING_TUESDAY, DayOfWeekConstant.STRING_WEDNESDAY, DayOfWeekConstant.STRING_THURSDAY, DayOfWeekConstant.STRING_FRIDAY, DayOfWeekConstant.STRING_SATURDAY}};
        weekday.setSelectValues(values);
        weekday.setValue((Object)DayOfWeekConstant.STRING_SUNDAY);
        timeFrom.setValue((Object)"");
        timeTo.setValue((Object)"");
        description.setValue((Object)"");
        createTime.setValue((Object)"");
        creatorName.setValue((Object)"");
        modifyTime.setValue((Object)"");
        modifierName.setValue((Object)"");
        if (mode == 0) {
            weekday.setModify(1);
            timeFrom.setModify(1);
            timeTo.setModify(1);
            description.setModify(1);
        } else if (mode == 1) {
            weekday.setModify(1);
            timeFrom.setModify(1);
            timeTo.setModify(1);
            description.setModify(1);
        }
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren((PropertyTreeItem)weekday);
        property.addChildren((PropertyTreeItem)timeFrom);
        property.addChildren((PropertyTreeItem)timeTo);
        property.addChildren((PropertyTreeItem)description);
        property.addChildren((PropertyTreeItem)createTime);
        property.addChildren((PropertyTreeItem)creatorName);
        property.addChildren((PropertyTreeItem)modifyTime);
        property.addChildren((PropertyTreeItem)modifierName);
        return property;
    }
}

