/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.AbstractNamedHandleEvent;

public final class CommandEvent
extends AbstractNamedHandleEvent {
    private static final int CHANGED_CATEGORY = 8;
    private static final int CHANGED_HANDLED = 16;
    private static final int CHANGED_PARAMETERS = 32;
    private final Command command;

    public CommandEvent(Command command, boolean categoryChanged, boolean definedChanged, boolean descriptionChanged, boolean handledChanged, boolean nameChanged, boolean parametersChanged) {
        super(definedChanged, descriptionChanged, nameChanged);
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command;
        if (categoryChanged) {
            this.changedValues |= 8;
        }
        if (handledChanged) {
            this.changedValues |= 0x10;
        }
        if (parametersChanged) {
            this.changedValues |= 0x20;
        }
    }

    public final Command getCommand() {
        return this.command;
    }

    public final boolean isCategoryChanged() {
        return (this.changedValues & 8) != 0;
    }

    public final boolean isHandledChanged() {
        return (this.changedValues & 0x10) != 0;
    }

    public final boolean isParametersChanged() {
        return (this.changedValues & 0x20) != 0;
    }
}

