/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.dialog.NodeFilterDialog;
import com.clustercontrol.repository.view.NodeListView;

/**
 * ノード検索ダイアログによる、検索処理を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeFilterAction implements IViewActionDelegate {

    //	 ----- instance フィールド ----- //

    private IViewPart viewPart; // ビュー

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // ノード一覧より、選択されているノードのファシリティIDを取得

        NodeListView view = (NodeListView) this.viewPart
                .getAdapter(NodeListView.class);

        if (action.isChecked()) {
            // ダイアログを生成
            NodeFilterDialog dialog = new NodeFilterDialog(this.viewPart
                    .getSite().getShell());

            // ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
            if (dialog.open() == IDialogConstants.OK_ID) {
                Property condition = dialog.getInputData();

                view.update(condition);
            } else {
                action.setChecked(false);
            }
        } else {
            view.update(null);
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}