/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.factory;

import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.priority.bean.PriorityJudgmentInfo;
import com.clustercontrol.priority.ejb.entity.PriorityInfoLocal;
import com.clustercontrol.priority.ejb.entity.PriorityInfoUtil;
import com.clustercontrol.priority.util.PriorityJudgment;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 重要度判定更新クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyPriorityJudgment {
	protected static Log m_log = LogFactory.getLog(ModifyPriorityJudgment.class);

	/**
	 * 重要度判定追加
	 * 
	 * @param info
	 * @param userName
	 * @throws NamingException
	 * @throws CreateException
	 * @throws FinderException
	 */
	public void addPriorityJudgment(PriorityJudgmentInfo info, String userName) throws NamingException, CreateException, FinderException  {
    	//アクセスロック
    	AccessLock.lock(AccessLock.PRIORITY_JUDGMENT);
    	
	    try {
			//現在日時を取得
			Date now = new Date();
			
			//重要度判定を作成
			PriorityInfoUtil.getLocalHome().create(
					info.getJudgment_id(), 
					info.getDescription(),
					info.getPattern_01(), 
					info.getPattern_02(), 
					info.getPattern_03(), 
					info.getPattern_04(), 
					info.getPattern_05(), 
					info.getPattern_06(), 
					info.getPattern_07(), 
					info.getPattern_08(), 
					info.getPattern_09(), 
					info.getPattern_10(), 
					info.getPattern_11(), 
					info.getPattern_12(), 
					info.getPattern_13(), 
					info.getPattern_14(), 
					info.getPattern_15(), 
					now, 
					now, 
					userName, 
					userName);
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "001", args);
            
            m_log.debug("addPriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "001", args);
            
            m_log.debug("addPriorityJudgment() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * 重要度判定変更
	 * 
	 * @param info
	 * @param userName
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyPriorityJudgment(PriorityJudgmentInfo info, String userName) throws NamingException, FinderException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.PRIORITY_JUDGMENT);
    	
	    try {
			Date now = new Date();
			
			//PriorityInfoを検索し取得
			PriorityInfoLocal priority = PriorityInfoUtil.getLocalHome().findByPrimaryKey(info.getJudgment_id());
			//説明を取得し、PriorityInfoに設定
			priority.setDescription(info.getDescription());
			//パターン01を取得し、PriorityInfoに設定
			priority.setPattern_01(info.getPattern_01());
			//パターン02を取得し、PriorityInfoに設定
			priority.setPattern_02(info.getPattern_02());
			//パターン03を取得し、PriorityInfoに設定
			priority.setPattern_03(info.getPattern_03());
			//パターン04を取得し、PriorityInfoに設定
			priority.setPattern_04(info.getPattern_04());
			//パターン05を取得し、PriorityInfoに設定
			priority.setPattern_05(info.getPattern_05());
			//パターン06を取得し、PriorityInfoに設定
			priority.setPattern_06(info.getPattern_06());
			//パターン07を取得し、PriorityInfoに設定
			priority.setPattern_07(info.getPattern_07());
			//パターン08を取得し、PriorityInfoに設定
			priority.setPattern_08(info.getPattern_08());
			//パターン09を取得し、PriorityInfoに設定
			priority.setPattern_09(info.getPattern_09());
			//パターン10を取得し、PriorityInfoに設定
			priority.setPattern_10(info.getPattern_10());
			//パターン11を取得し、PriorityInfoに設定
			priority.setPattern_11(info.getPattern_11());
			//パターン12を取得し、PriorityInfoに設定
			priority.setPattern_12(info.getPattern_12());
			//パターン13を取得し、PriorityInfoに設定
			priority.setPattern_13(info.getPattern_13());
			//パターン14を取得し、PriorityInfoに設定
			priority.setPattern_14(info.getPattern_14());
			//パターン15を取得し、PriorityInfoに設定
			priority.setPattern_15(info.getPattern_15());
			//更新者を取得し、PriorityInfoに設定
			priority.setUpdate_user(userName);
			//更新日時を取得し、PriorityInfoに設定
			priority.setUpdate_date(now);
			
			//重要度判定情報更新
			PriorityJudgment.setPattern();
			
		} catch (EJBException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "002", args);
            
            m_log.debug("modifyPriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {info.getJudgment_id()};
            apllog.put("SYS", "002", args);
            
            m_log.debug("modifyPriorityJudgment() : " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * 重要度判定削除
	 * 
	 * @param judgmentId
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws FinderException
	 */
	public void deletePriorityJudgment(String judgmentId) throws NamingException, RemoveException, FinderException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.PRIORITY_JUDGMENT);
    	
    	try {
			//重要度判定情報を検索し取得
    		PriorityInfoLocal priority = PriorityInfoUtil.getLocalHome().findByPrimaryKey(judgmentId);

            //重要度判定情報を削除
            priority.remove();
            
		} catch (FinderException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {judgmentId};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deletePriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {judgmentId};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deletePriorityJudgment() : " + e.getMessage());
			throw e;
		} catch (NamingException e) {
            AplLogger apllog = new AplLogger("PRIORITY", "priority");
            String[] args = {judgmentId};
            apllog.put("SYS", "003", args);
            
            m_log.debug("deletePriorityJudgment() : " + e.getMessage());
			throw e;
		}
	}
}
