/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performanceMGR.monitor.factory;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifyMonitorNumericValueType;
import com.clustercontrol.monitor.run.factory.SelectSchedule;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.bean.CollectorRunStatus;
import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 性能値閾値監視情報更新クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyMonitorPerformance extends ModifyMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorPerformance.class );

	@Override
	public boolean modify(MonitorInfo info, String user) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
		String collectorId = ((MonitorPerfCheckInfo)info.getCheckInfo()).getCollectorId();

		super.modify(info, user);
		
		try{
			// 登録されている収集を停止する
        	CollectorHome home = JNDIConnectionManager.getCollectorHome();
        	Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorId));
			
			// 前の収集を停止し、収集情報を削除
			myBean.stopCollect();  // 収集を停止
			
			// まだ動作中の場合
			if(myBean.getStatus() == CollectorRunStatus.RUNNING){
				m_log.debug("deleteRecordCollector()  : " + collectorId + " is running.");
				throw new RemoveException(collectorId + " is running.");
			} else {
				// 収集設定を削除
				myBean.remove();
			}
		} catch (FinderException e) {
			// 収集が登録されていない場合は何もしない
		} catch (RemoteException e) {
			throw new EJBException(e);
		}
		
        // 有効の場合、収集を開始
	    if(info.getValid() == ValidConstant.TYPE_VALID){
			// 性能監視情報を設定
			MonitorPerfCheckInfo mpInfo = (MonitorPerfCheckInfo)info.getCheckInfo();
			
			// 収集項目情報を保持するリスト
			ArrayList itemList = new ArrayList();
			
			// 収集項目情報を生成
			CollectorItemInfo itemInfo = new CollectorItemInfo(
					mpInfo.getCollectorId(),
					0,                        // 収集IDを整数型で設定
					mpInfo.getItemCode(),
					mpInfo.getDeviceIndex(),
					mpInfo.getDeviceName()
					);
			
			itemList.add(itemInfo);
			
			// 性能管理の収集に登録
			ModifySchedule scheduler = new ModifySchedule();
			scheduler.addSchedule(
					info.getMonitorId(),
					collectorId,
					info.getFacilityId(),
					info.getRunInterval(),
					itemList,
					info.getValid());
	    }
	    
		return true;
	}

	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.ModifyMonitor#modifyCheckInfo()
	 */
	@Override
	public boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
		
		// 閾値監視情報を取得
		MonitorPerfInfoPK pk = new MonitorPerfInfoPK(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// 閾値監視情報を設定
		MonitorPerfCheckInfo perfCheck = (MonitorPerfCheckInfo)m_monitorInfo.getCheckInfo();
		perfLocal.setCollectorId(perfCheck.getCollectorId());
		perfLocal.setItemCode(perfCheck.getItemCode());
		perfLocal.setDeviceIndex(perfCheck.getDeviceIndex());
		perfLocal.setDeviceName(perfCheck.getDeviceName());
		
		boolean result = true;
				
		return result;
	}
	
	/**
	 * 監視情報を更新
	 * 
	 * @param info
	 * @return 更新に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 */
	@Override
	protected boolean modifyMonitorInfo(String user) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException{

		try 
		{
			// 監視情報を取得
			MonitorInfoPK pk = new MonitorInfoPK(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
			m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);

			if(!m_monitorInfo.getFacilityId().equals(m_monitor.getFacilityId())){
				m_isModifyFacilityId = true;
			}
			if(m_monitorInfo.getRunInterval() != m_monitor.getRunInterval().intValue()){
				m_isModifyRunInterval = true;
			}
			if(!m_isModifyRunInterval){
				int oldValid = new SelectSchedule().getValid(m_monitorInfo.getMonitorTypeId(), m_monitorInfo.getMonitorId());
				if(m_monitorInfo.getValid() != oldValid){
					m_isModifyValid = true;
				}
			}
			
			// 監視情報を設定
			m_monitor.setDescription(m_monitorInfo.getDescription());
			if(m_isModifyFacilityId)
				m_monitor.setFacilityId(m_monitorInfo.getFacilityId());
			if(m_isModifyRunInterval)
				m_monitor.setRunInterval(m_monitorInfo.getRunInterval());
			m_monitor.setTimeout(m_monitorInfo.getTimeout());
			m_monitor.setCalendarId(m_monitorInfo.getCalendarId());
			m_monitor.setMonitorBlock(m_monitorInfo.getMonitorBlock());
			m_monitor.setDeterminationId(m_monitorInfo.getDeterminationId());
			m_monitor.setFailurePriority(m_monitorInfo.getFailurePriority());
			m_monitor.setNotifyId(m_monitorInfo.getNotifyId());
			m_monitor.setApplication(m_monitorInfo.getApplication());
			m_monitor.setJobRun(m_monitorInfo.getJobRun());
			m_monitorInfo.setFailureMessageId(m_monitorInfo.getFailureMessageId());
			m_monitorInfo.setFailureMessage(m_monitorInfo.getFailureMessage());
			m_monitorInfo.setFailureJobRun(m_monitorInfo.getFailureJobRun());
			m_monitorInfo.setFailureJobId(m_monitorInfo.getFailureJobId());
			m_monitorInfo.setFailureJobInhibitionFlg(m_monitorInfo.getFailureJobInhibitionFlg());
			m_monitorInfo.setFailureJobFailurePriority(m_monitorInfo.getFailureJobFailurePriority());
			m_monitor.setUpdateDate(new Timestamp(new Date().getTime()));
			m_monitor.setUpdateUser(user);
			
			// 判定情報を設定
			if(modifyJudgementInfo()){
				// 監視チェック情報を設定
				if(modifyCheckInfo()){
					return true;
				}
			}
			return false;
			
		} catch (CreateException e) {
			outputLog(e, "modifyMonitorInfo()");
            e.printStackTrace();
			throw e;
		} catch (FinderException e) {
			outputLog(e, "modifyMonitorInfo()");
            e.printStackTrace();
			throw e;
		} catch (RemoveException e) {
			outputLog(e, "modifyMonitorInfo()");
			e.printStackTrace();
			throw e;
		} catch (SchedulerException e) {
			outputLog(e, "modifyMonitorInfo()");
			e.printStackTrace();
			throw e;
		} catch (NamingException e) {
			outputLog(e, "modifyMonitorInfo()");
			e.printStackTrace();
			throw e;
		}
	}
	
	/**
     * アプリケーションログにログを出力
     * 
     * @param e 例外
     */
	private void outputLog(Exception e, String method) {
		AplLogger apllog = new AplLogger("PERF", "perf");
		String[] args = {m_monitorInfo.getMonitorTypeId(), m_monitorInfo.getMonitorId() };
        apllog.put("SYS", "008", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
