/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;

/**
 * 収集項目のPKクラス
 * 
 * @version 1.0
 * @since 1.0
 *
 */
public class CollectorItemPK implements Serializable
{
   private String itemCode;
   private int    deviceIndex;

   public CollectorItemPK(){}

   /**
    * コンストラクタ
    * 収集項目コードとデバイス番号を設定した状態で、CollectorItemPKクラスのインスタンスを生成します。
    * 
    * @param itemCode 収集項目コード
    * @param deviceIndex デバイス番号
    */
   public CollectorItemPK(String itemCode, int deviceIndex){
      this.itemCode = itemCode;
      this.deviceIndex = deviceIndex;
   }

   /**
    * 収集項目コードを取得します。
    * @return 収集ID
    */
   public String getItemCode(){
      return itemCode;
   }
   
   /**
    * デバイス番号を取得します。
    * @return 収集項目ID
    */
   public int getDeviceIndex(){
      return deviceIndex;
   }
   
   /**
    * このオブジェクトと他のオブジェクトが等しいかどうかを示します。
    */
   public boolean equals(Object o) {  	
	   if(this == o){
		   return true;
	   }
	   
	   if(o instanceof CollectorItemPK){
		   CollectorItemPK other = (CollectorItemPK)o;
		   boolean equals = false;
		   
		   if(this.itemCode == null || other.itemCode == null){
			   equals = false;
		   } else  if(itemCode.equals(other.itemCode) && deviceIndex == other.deviceIndex){
			   equals = true;
		   }
		   
		   return equals;
	   } else {
		   return false;
	   }
   }
   
   /**
    * オブジェクトのハッシュコード値を返します。
    */
   public int hashCode() {
	   int result = 17;
	   
	   result = 37*result + ((this.itemCode != null) ? this.itemCode.hashCode() : 0);
	   result = 37*result + deviceIndex;
	   
	   return result;
   }
}
