/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.util;

/**
 * リアルタイムグラフの４つのグラフの情報を個々に保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeCollectorItemInfo extends RealtimeCollectorInfo {
	private int graphNum = 4;
	
	private int itemNum = 0;
	
	private String itemInfo[][] = null;

	// ダイアログ操作用 
	private String itemInfoForDialog[][] = null;

	private String itemInfoForCollector[][] = null;
	
	private boolean itemInfoBoolean[][] = null;
	// ダイアログ操作用 
	private boolean itemInfoForDialogBoolean[][] = null;

	private boolean itemInfoForCollectorBoolean[][] = null;

	private boolean isCollect[][] = null;

	private boolean hasDevice[][] = null;

    /**
     * コンストラクター
     * 
     * @param watchItem
     */
    public RealtimeCollectorItemInfo() {
        super();
        
        // 行数：グラフ表示の最大数。現行仕様は4で固定。
        // 列数：データの属性
        //			SelectedScope:スコープ代表値
        //			SubScope:サブスコープ値
        //			Detail:スコープ内訳値
        //			NonDisplay:非表示
        //				暫定仕様。ダイアログ画面でデータ項目が固定のバージョン用。
        //				将来はデータ項目を選択可能にすることを視野にいれる。
        itemInfo = new String[graphNum][5];
        itemInfoForDialog = new String[graphNum][5];

      itemInfoBoolean = new boolean[graphNum][1];
      itemInfoForDialogBoolean = new boolean[graphNum][1];

      isCollect = new boolean[graphNum][1];
      for (int i = 0; i < graphNum; i++) {
    	  isCollect[i][0] = false; //初期値.
      }
      hasDevice = new boolean[graphNum][1];
      for (int i = 0; i < graphNum; i++) {
    	  hasDevice[i][0] = true; //初期値.
      }
    }

    
    // itemInfo操作用
    public void setItemInfo(int i, String itemCode, String displayType, String deviceIndex, String itemId, String deviceName, boolean isDetailed) {
    	itemInfo[i][0] = itemCode;
    	itemInfo[i][1] = displayType;
    	itemInfo[i][2] = deviceIndex;
    	itemInfo[i][3] = itemId;
    	itemInfo[i][4] = deviceName;
    	itemInfoBoolean[i][0] = isDetailed;
    }
    public String getItemCode(int i) {
    	return (itemInfo[i][0]) ;
    }
    public String getDisplayType(int i) {
    	return (itemInfo[i][1]) ;
    }
    public String getDeviceIndex(int i) {
    	return (itemInfo[i][2]) ;
    }
    public String getItemId(int i) {
    	return (itemInfo[i][3]) ;
    }
    public String getDeviceName(int i) {
    	return (itemInfo[i][4]) ;
    }
    public void setDeviceIndex(int i, String deviceIndex) {
    	itemInfo[i][2] = deviceIndex;
    }
    public void setItemId(int i, String itemId) {
    	itemInfo[i][3] = itemId;
    }
    public boolean getItemDetailed(int i) {
    	return (this.itemInfoBoolean[i][0]) ;
    }
    public void isItemDetailed(int i, boolean isDetailed) {
    	this.itemInfoBoolean[i][0] = isDetailed;
    }
    public boolean isCollect(int i) {
    	return isCollect[i][0];
    }
    public void setIsCollect(int i, boolean isCollect) {
    	this.isCollect[i][0] = isCollect;
    }
    
    public boolean hasDevice(int i) {
    	return hasDevice[i][0];
    }
    public void setHasDevice(int i, boolean hasDevice) {
    	this.hasDevice[i][0] = hasDevice;
    }
    
    
    // itemInfoForDialog操作用
    public void setItemInfoForDialog(int i, String itemCode, String displayType, String deviceIndex, String itemId, String deviceName, boolean isDetailed) {
    	itemInfoForDialog[i][0] = itemCode;
    	itemInfoForDialog[i][1] = displayType;
    	itemInfoForDialog[i][2] = deviceIndex;
    	itemInfoForDialog[i][3] = itemId;
    	itemInfoForDialog[i][4] = deviceName;
    	itemInfoForDialogBoolean[i][0] = isDetailed;
    }
    public String getItemCodeForDialog(int i) {
    	return (itemInfoForDialog[i][0]) ;
    }
    public String getDisplayTypeForDialog(int i) {
    	return (itemInfoForDialog[i][1]) ;
    }
    public String getDeviceIndexForDialog(int i) {
    	return (itemInfoForDialog[i][2]) ;
    }
    public String getItemIdForDialog(int i) {
    	return (itemInfoForDialog[i][3]) ;
    }
    public void isItemDetailedForDialog(int i, boolean isDetailed) {
    	this.itemInfoForDialogBoolean[i][0] = isDetailed;
    }
    public void setItemCodeForDialog(int i, String itemCode) {
    	itemInfoForDialog[i][0] = itemCode;
    }
    public void setDisplayTypeForDialog(int i, String displayType) {
    	itemInfoForDialog[i][1] = displayType;
    }
    public void setDeviceIndexForDialog(int i, String deviceIndex) {
    	itemInfoForDialog[i][2] = deviceIndex;
    }
    public void setItemIdForDialog(int i, String itemId) {
    	itemInfoForDialog[i][3] = itemId;
    }
    public void setDeviceNameForDialog(int i, String deviceName) {
    	itemInfoForDialog[i][4] = deviceName;
    }
    public void refreshItemInfoForDialog() {
    	for (int i = 0; i < itemInfo.length ; i++) {
    		setItemInfoForDialog(i,
    				itemInfo[i][0],
    				itemInfo[i][1],
    				itemInfo[i][2],
    				itemInfo[i][3],
    				itemInfo[i][4],
    				itemInfoBoolean[i][0]);
    	}
    }
    public void copyItemInfoForDialog() {
    	for (int i = 0; i < itemInfo.length ; i++) {
    		setItemInfo(i,
    				itemInfoForDialog[i][0],
    				itemInfoForDialog[i][1],
    				itemInfoForDialog[i][2],
    				itemInfoForDialog[i][3],
    				itemInfoForDialog[i][4],
    				itemInfoForDialogBoolean[i][0]);
    	}
    }
    
//  itemInfoForCollector操作用
    public String getItemCodeForCollector(int i) {
    	return (itemInfoForCollector[i][0]) ;
    }
    public String getIndexForCollector(int i) {
    	return (itemInfoForCollector[i][1]) ;
    }
    public String getDeviceNameForCollector(int i) {
    	return (itemInfoForCollector[i][3]) ;
    }
    public void setItemInfoForCollector(int i, String itemCode, String deviceIndex, String itemId, String deviceName, boolean isDetailed) {
    	this.itemInfoForCollector[i][0] = itemCode;
    	this.itemInfoForCollector[i][1] = deviceIndex;
    	this.itemInfoForCollector[i][2] = itemId; // itemIdは配列のインデックスと同値なので必要ないかも.
    	if (deviceName != null && ! deviceName.equals("Non")) {
    		this.itemInfoForCollector[i][3] = deviceName;
    	}
    	this.itemInfoForCollectorBoolean[i][0] = isDetailed;
    }
    public void createItemInfoForCollector(int itemNum) {
    	this.itemNum = itemNum;
    	itemInfoForCollector = new String[itemNum][4];
    	itemInfoForCollectorBoolean  = new boolean[itemNum][1];
    }
    public int getItemNumForCollector() {
    	return (this.itemNum) ;
    }
    public void isItemDetailedForCollector(int i, boolean isDetailed) {
    	this.itemInfoForCollectorBoolean[i][0] = isDetailed;
    }
    public boolean getItemDetailedForCollector(int i) {
    	return (this.itemInfoForCollectorBoolean[i][0]) ;
    }
}