/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.util;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;
import com.clustercontrol.monitor.factory.OutputEventLog;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.util.Messages;

/**
 * ジョブを呼出すクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class RunJob {
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( RunJob.class );

	/** ログ出力情報。 */
    protected LogOutputInfo m_info;
	
	/** ログ出力ジョブ実行情報。 */
    protected LogOutputJobRunInfo m_jobRunInfo;
    
    /**
     * コンストラクタ。<BR>
     * ログ出力情報とログ出力ジョブ実行情報を設定します。
     * 
     * @param info ログ出力情報
     */
    public RunJob(LogOutputInfo info){
    	m_info = info;
    	m_jobRunInfo = m_info.getJobRun();
    }
    
    /**
     * ジョブ管理機能の指定されたジョブを呼出します。
     * <p>含まれているログ出力情報を基にジョブを呼出します。<BR>
     * ジョブの呼出に失敗した場合は、ログ出力情報の呼出失敗時の重要度で、監視管理機能のイベントへ通知します。
     * 
     * @see com.clustercontrol.monitor.message.LogOutputInfo
     * @see com.clustercontrol.monitor.factory.OutputEventLog#insertEventLog(LogOutputInfo, int)
     */
    public void run() {
    	
		try {
			// ジョブ実行
			JobControllerLocal job = JobControllerUtil.getLocalHome().create();
			job.runJob(m_jobRunInfo.getJobId(), m_info);
		}
		catch (Exception e) {
			//ジョブ呼出失敗時、通知
			
			//ジョブ失敗時の重要度を設定
			m_info.setPriority(m_jobRunInfo.getJobFailurePriority());
			m_info.setMessageId("200");
            String[] args1 = { m_jobRunInfo.getJobId() };
			m_info.setMessage(Messages.getString("message.monitor.41", args1));
			m_info.setMessageOrg("");
			OutputEventLog eventLog = new OutputEventLog();
			Date now = new Date();
			eventLog.setOutputDate(new Timestamp(now.getTime()));
			try {
				eventLog.insertEventLog(m_info, YesNoConstant.TYPE_NO);
			} catch (NamingException e1) {
				//TODO NamingException 未実装
			} catch (CreateException e1) {
				//TODO CreateException 未実装
			}
		}
    }
}

