/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.FinderException;

/**
 * イベント多重化情報のBMP Entity Beanです。
 * 
 * @ejb.bean name="EventMultiInfo"
 *           jndi-name="EventMultiInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.monitor.dao.EventMultiInfoDAO"
 * impl-class="com.clustercontrol.monitor.dao.EventMultiInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.monitor.dao.EventMultiInfoDAO
 * @see com.clustercontrol.monitor.dao.EventMultiInfoDAOImpl
 */
public abstract class EventMultiInfoBean implements javax.ejb.EntityBean {
	
	/** 監視項目ID。 */
	protected String monitorId;
	
	/** プラグインID。 */
	protected String pluginId;
	
	/** ファシリティID。 */
	protected String facilityId;
	
	/** 受信日時。 */
	protected Timestamp outputDate;
	
	/** 多重化ID。 */
	protected String multiId;
	
	/** 重複カウンタ。 */
	protected Integer duplicationCount;
	
	/**
	 * イベント多重化情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param monitorId 監視項目ID
	 * @param pluginId プラグインID
	 * @param facilityId ファシリティID
	 * @param outputDate 受信日時
	 * @param multiId 多重化ID
	 * @param duplicationCount 重複カウンタ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.monitor.dao.EventMultiInfoDAOImpl#create(EventMultiInfoBean)
	 */
	public com.clustercontrol.monitor.ejb.entity.EventMultiInfoPK ejbCreate(
			String monitorId,
			String pluginId,
			String facilityId,
			Timestamp outputDate,
			String multiId,
			Integer duplicationCount
	) throws javax.ejb.CreateException {
		
		this.monitorId = monitorId;
		this.pluginId = pluginId;
		this.facilityId = facilityId;
		this.outputDate = outputDate;
		this.multiId = multiId;
		this.duplicationCount = duplicationCount;
		
		return null;
	}
	
	
	/**
	 * 全てのイベント多重化情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.monitor.dao.EventMultiInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するイベント多重化情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.monitor.dao.EventMultiInfoDAOImpl#findByPrimaryKey(EventMultiInfoPK)
	 */
	public EventMultiInfoPK ejbFindByPrimaryKey(EventMultiInfoPK pk)
	throws FinderException {
		return null;
	}

	/**
	 * 重複カウンタを返します。
	 * 
	 * @return 重複カウンタ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getDuplicationCount() {
		return duplicationCount;
	}
	
	/**
	 * 重複カウンタを設定します。
	 * 
	 * @param duplicationCount 重複カウンタ
	 * @ejb.interface-method
	 */
	public void setDuplicationCount(Integer duplicationCount) {
		this.duplicationCount = duplicationCount;
	}
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @return ファシリティID
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @param facilityId ファシリティID
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * 監視項目IDを返します。
	 * 
	 * @return 監視項目ID
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @param monitorId 監視項目ID
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * 多重化IDを返します。
	 * 
	 * @return 多重化ID
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMultiId() {
		return multiId;
	}
	
	/**
	 * 多重化IDを設定します。
	 * 
	 * @param multiId 多重化ID
	 * @ejb.interface-method
	 */
	public void setMultiId(String multiId) {
		this.multiId = multiId;
	}
	
	/**
	 * 受信日時を返します。
	 * 
	 * @return 受信日時
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * 受信日時を設定します。
	 * 
	 * @param outputDate 受信日時
	 * @ejb.interface-method
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * プラグインIDを返します。
	 * 
	 * @return プラグインID
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getPluginId() {
		return pluginId;
	}
	
	/**
	 * プラグインIDを設定します。
	 * 
	 * @param pluginId プラグインID
	 * @ejb.interface-method
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
}
