/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;

/**
 * メンテナンス情報を削除するためのクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 *
 */
public class DeleteMaintenance {
	
	public boolean deleteMaintenance(String maintenanceId) throws EJBException, RemoveException, NamingException {

		AccessLock.lock(AccessLock.MAINTENANCE);
		
		MaintenanceInfoUtil.getLocalHome().remove(maintenanceId);
		
		return true;
	}

}
