/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * @ejb.bean name="MaintenanceInfo"
 *           display-name="MaintenanceInfo"
 *           description="MaintenanceInfo"
 *           jndi-name="MaintenanceInfo"
 *           type="CMP"
 *           primkey-field="maintenance_id"
 *           cmp-version="2.x"
 *           schema="MaintenanceInfo"
 *           data-source="java:/HinemosDS"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.permission
 *     unchecked="true"
 *        
 * @ejb.persistence 
 *   table-name="maintenance_info" 
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MaintenanceInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *    
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MaintenanceInfo as a WHERE a.maintenance_id = ?1"
 *    signature="java.util.Collection findAll(java.lang.String maintenance_id)"
 *    
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MaintenanceInfo as a ORDER BY a.maintenance_id"
 *    signature="java.util.Collection findAllOrderByMaintenanceId()"
 *
 * @ejb.pk class="java.lang.String"
 * 
 */
public abstract class MaintenanceInfoBean implements EntityBean {
	
	public MaintenanceInfoBean() {
		super();
		// TODO 自動生成されたコンストラクター・スタブ
	}

	public void setEntityContext(EntityContext ctx)
		throws EJBException,
		RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}
	
	
	/**
	 * 
	 * @ejb.create-method
	 * 
	 * @param maintenance_id
	 * @param description
	 * @param type_id
	 * @param keep_id
	 * @param calendar_id
	 * @param schedule_date
	 * @param notify_id
	 * @param application
	 * @param valid_flg
	 * @param reg_user
	 * @param reg_date
	 * @param update_user
	 * @param update_date
	 * @return
	 * @throws CreateException
	 */
	public String ejbCreate(
			String maintenance_id,
			String description,
			String type_id,
			String keep_id,
			String calendar_id,
			Timestamp schedule_date,
			String notify_id,
			String application,
			Integer valid_flg,
			String reg_user,
			Timestamp reg_date,
			String update_user,
			Timestamp update_date
			) throws CreateException {
		
		this.setMaintenance_id(maintenance_id);
		this.setDescription(description);
		this.setType_id(type_id);
		this.setKeep_id(keep_id);
		this.setCalendar_id(calendar_id);
		this.setSchedule_date(schedule_date);
		this.setNotify_id(notify_id);
		this.setApplication(application);
		this.setValid_flg(valid_flg);
		this.setRegUser(reg_user);
		this.setRegDate(reg_date);
		this.setUpdateUser(update_user);
		this.setUpdateDate(update_date);
		
		return null;
	}
	
	public void ejbPostCreate() throws CreateException {}	

	public void ejbRemove()
		throws RemoveException,
		EJBException,
		RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbActivate() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbLoad() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	public void ejbStore() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	/**
	 * 
     * @ejb.persistent-field 
     * @ejb.persistence
     *    column-name="maintenance_id"
     *     jdbc-type="VARCHAR"
     *     sql-type="VARCHAR(64)"
     *     read-only="false"
     *     
	 * @ejb.pk-field 
     *     
     * @ejb.interface-method
     * 
	 * @return
	 */
	public abstract String getMaintenance_id();

	/**
     * @ejb.interface-method
     * 
	 * @param maintenance_id
	 */
	public abstract void setMaintenance_id(String maintenance_id);
	

	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();

	/**
     * @ejb.interface-method
     * 
	 * @param maintenance_id
	 */
	public abstract void setDescription(String description);
	
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract String getType_id();
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @param type_id
	 */
	public abstract void setType_id(String type_id);
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="keep_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract String getKeep_id();
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @param keep_id
	 */
	public abstract void setKeep_id(String keep_id);
	
	
	/**
	 * カレンダIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public abstract String getCalendar_id();
	
	
	/**
	 * 
	 * カレンダIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendarId カレンダID
	 */
	public abstract void setCalendar_id(String calendar_id);
	
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="schedule_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 *  
	 * @return
	 */
	public abstract Timestamp getSchedule_date();
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_date
	 */
	public abstract void setSchedule_date(Timestamp schedule_date);
	
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotify_id();
	
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notify_id
	 */
	public abstract void setNotify_id(String notify_id);
	
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return アプリケーション
	 */
	public abstract String getApplication();
	
	/**
	 * 
	 * @ejb.interface-method
	 * 
	 * @param application
	 */
	public abstract void setApplication(String application);
	
	/**
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getValid_flg();
	
	/**
	 * 
	 * アプリケーションを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param valid_flg
	 */
	public abstract void setValid_flg(Integer valid_flg);
	
	
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regUser 新規作成ユーザ
	 */
	public abstract void setRegUser(java.lang.String regUser);	
	
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract Timestamp getRegDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract void setRegDate(Timestamp regDate);
		
	
	/**
	 * 最終変更ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終変更ユーザ
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateUser 最終変更ユーザ 
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
		
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	


}
