/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * セッションIDを作成するクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class CreateSessionId {
	protected static Log m_log = LogFactory.getLog( CreateSessionId.class );

	protected static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
	protected static DecimalFormat format = new DecimalFormat("-000");
	
	protected static String prevDate = "";
	protected static int prevNumber = 0;
	
	/**
	 * 現在時刻からセッションIDを作成します。
	 * 
	 * @return セッションID
	 */
	synchronized public static String create() {
		String sessionId = null;
		
		String dateString = dateFormat.format(new Date());
		
		if(prevDate.equals(dateString)){
			sessionId = dateString + format.format(prevNumber + 1);
			prevNumber++;
		}
		else{
			sessionId = dateString + format.format(0);
			prevDate = dateString;
			prevNumber = 0;
		}
	
	    return sessionId;
    }
}
