/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.List;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.collectiverun.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * 履歴フィルタ用プロパティ作成クラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryFilterProperty extends HistoryFilterPropertyConstant {

	/**
	 * 履歴フィルタ用プロパティを返します。
	 * 
	 * @param local
	 * @return 履歴フィルタ用プロパティ
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public Property getProperty(Locale locale) throws FinderException, NamingException {
	
		//開始日時（自）
		Property m_startFromDate =
			new Property(START_FROM_DATE, Messages.getString("start", locale), PropertyConstant.EDITOR_DATETIME);
		//開始日時（至）
		Property m_startToDate =
			new Property(START_TO_DATE, Messages.getString("end", locale), PropertyConstant.EDITOR_DATETIME);
		//終了日時（自）
		Property m_endFromDate =
			new Property(END_FROM_DATE, Messages.getString("start", locale), PropertyConstant.EDITOR_DATETIME);
		//終了日時（至）
		Property m_endToDate =
			new Property(END_TO_DATE, Messages.getString("end", locale), PropertyConstant.EDITOR_DATETIME);
		//管理種別
		Property m_type =
			new Property(TYPE, Messages.getString("type", locale), PropertyConstant.EDITOR_SELECT);
		//状態
		Property m_status =
			new Property(STATUS, Messages.getString("run.status", locale), PropertyConstant.EDITOR_SELECT);

		//開始日時
		Property m_startDate = 
			new Property(START_DATE, Messages.getString("start.time", locale), PropertyConstant.EDITOR_TEXT);
		//終了日時
		Property m_endDate = 
			new Property(END_DATE, Messages.getString("end.time", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		Object statusValues[][] = {
				{ "", StatusConstant.STRING_RUNNING, StatusConstant.STRING_END }, 
				{ "", StatusConstant.STRING_RUNNING, StatusConstant.STRING_END }};

		m_status.setSelectValues(statusValues);
		m_status.setValue("");
		
		List<String> typeStringList = null;
		try {
			typeStringList = SelectMaster.getTypeStringList(locale);
		} catch (FinderException e) {
			throw new FinderException("HistoryFilterPropetry.getProperty() : locale=" + locale.getDisplayName());
		} catch (NamingException e) {
			throw e;
		}
		typeStringList.add(0, "");
		
		Object typeValues[][] = {
				new Object[typeStringList.size()], 
				new Object[typeStringList.size()]};
		
		for(int i = 0; i < typeStringList.size(); i++){
		    typeValues[PropertyConstant.SELECT_VALUE][i] = typeStringList.get(i);
		    typeValues[PropertyConstant.SELECT_DISP_TEXT][i] = typeStringList.get(i);
		}

		m_type.setSelectValues(typeValues);
		m_type.setValue("");
		
		m_startFromDate.setValue("");
		m_startToDate.setValue("");
		m_endFromDate.setValue("");
		m_endToDate.setValue("");

		m_startDate.setValue("");
		m_endDate.setValue("");
		
		//変更の可/不可を設定
		m_startFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_startToDate.setModify(PropertyConstant.MODIFY_OK);
		m_endFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_endToDate.setModify(PropertyConstant.MODIFY_OK);
		m_type.setModify(PropertyConstant.MODIFY_OK);
		m_status.setModify(PropertyConstant.MODIFY_OK);

		m_startDate.setModify(PropertyConstant.MODIFY_NG);
		m_endDate.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_startDate);
		property.addChildren(m_endDate);
		property.addChildren(m_type);
		property.addChildren(m_status);
		
		// 開始・再実行日時
		m_startDate.removeChildren();
		m_startDate.addChildren(m_startFromDate);
		m_startDate.addChildren(m_startToDate);

		// 終了・中断日時
		m_endDate.removeChildren();
		m_endDate.addChildren(m_endFromDate);
		m_endDate.addChildren(m_endToDate);
		
		return property;
	}
}
