/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.bean.StringValueListTabelDefine;

/**
 * 文字列監視の判定情報一覧のラベルプロバイダークラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringValueListTableLabelProvider extends LabelProvider implements ITableLabelProvider {
	
	/**
	 * カラム文字列を返します。
	 * 
	 * @since 2.1.0
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		
		if (element instanceof MonitorStringValueInfo) {
			MonitorStringValueInfo filterInfo = (MonitorStringValueInfo) element;
			
			if (columnIndex == StringValueListTabelDefine.ORDER_NO) {
				return Integer.toString(filterInfo.getOrderNo());
				
			} else if (columnIndex == StringValueListTabelDefine.PROCESS_TYPE) {
				return ProcessConstant.typeToString(filterInfo.getProcessType());
				
			} else if (columnIndex == StringValueListTabelDefine.DESCRIPTION) {
				if (filterInfo.getDescription() != null) {
					return filterInfo.getDescription();
				}
			} else if (columnIndex == StringValueListTabelDefine.NOTIFY_ID) {
				if (filterInfo.getNotifyId() != null) {
					return filterInfo.getNotifyId();
				}
			} else if (columnIndex == StringValueListTabelDefine.MESSAGE_ID) {
				if (filterInfo.getMessageId() != null) {
					return filterInfo.getMessageId();
				}
			}
		}
		return "";
	}
	
	/**
	 * カラムイメージ(アイコン)を返します。
	 * 
	 * @since 2.1.0
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}
}